/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.registry;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.client.screen.ScreenObservatory;
import hellfirepvp.astralsorcery.client.screen.container.ScreenContainerAltarAttunement;
import hellfirepvp.astralsorcery.client.screen.container.ScreenContainerAltarConstellation;
import hellfirepvp.astralsorcery.client.screen.container.ScreenContainerAltarDiscovery;
import hellfirepvp.astralsorcery.client.screen.container.ScreenContainerAltarRadiance;
import hellfirepvp.astralsorcery.client.screen.container.ScreenContainerTome;
import hellfirepvp.astralsorcery.common.container.ContainerObservatory;
import hellfirepvp.astralsorcery.common.container.factory.ContainerAltarAttunementProvider;
import hellfirepvp.astralsorcery.common.container.factory.ContainerAltarConstellationProvider;
import hellfirepvp.astralsorcery.common.container.factory.ContainerAltarDiscoveryProvider;
import hellfirepvp.astralsorcery.common.container.factory.ContainerAltarRadianceProvider;
import hellfirepvp.astralsorcery.common.container.factory.ContainerObservatoryProvider;
import hellfirepvp.astralsorcery.common.container.factory.ContainerTomeProvider;
import hellfirepvp.astralsorcery.common.lib.ContainerTypesAS;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.IContainerFactory;

public class RegistryContainerTypes {
    private RegistryContainerTypes() {
    }

    public static void init() {
        ContainerTypesAS.TOME = RegistryContainerTypes.register("tome", new ContainerTomeProvider.Factory());
        ContainerTypesAS.OBSERVATORY = RegistryContainerTypes.register("observatory", new ContainerObservatoryProvider.Factory());
        ContainerTypesAS.ALTAR_DISCOVERY = RegistryContainerTypes.register("altar_discovery", new ContainerAltarDiscoveryProvider.Factory());
        ContainerTypesAS.ALTAR_ATTUNEMENT = RegistryContainerTypes.register("altar_attunement", new ContainerAltarAttunementProvider.Factory());
        ContainerTypesAS.ALTAR_CONSTELLATION = RegistryContainerTypes.register("altar_constellation", new ContainerAltarConstellationProvider.Factory());
        ContainerTypesAS.ALTAR_RADIANCE = RegistryContainerTypes.register("altar_radiance", new ContainerAltarRadianceProvider.Factory());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void initClient() {
        ScreenManager.func_216911_a(ContainerTypesAS.TOME, ScreenContainerTome::new);
        ScreenManager.func_216911_a(ContainerTypesAS.OBSERVATORY, (ScreenManager.IScreenFactory)new ScreenManager.IScreenFactory<ContainerObservatory, ScreenObservatory>(){

            public ScreenObservatory create(ContainerObservatory observatory, PlayerInventory playerInventory, ITextComponent name) {
                return new ScreenObservatory(observatory);
            }
        });
        ScreenManager.func_216911_a(ContainerTypesAS.ALTAR_DISCOVERY, ScreenContainerAltarDiscovery::new);
        ScreenManager.func_216911_a(ContainerTypesAS.ALTAR_ATTUNEMENT, ScreenContainerAltarAttunement::new);
        ScreenManager.func_216911_a(ContainerTypesAS.ALTAR_CONSTELLATION, ScreenContainerAltarConstellation::new);
        ScreenManager.func_216911_a(ContainerTypesAS.ALTAR_RADIANCE, ScreenContainerAltarRadiance::new);
    }

    private static <C extends Container, T extends ContainerType<C>> T register(String name, IContainerFactory<C> containerFactory) {
        return RegistryContainerTypes.register(AstralSorcery.key(name), containerFactory);
    }

    private static <C extends Container, T extends ContainerType<C>> T register(ResourceLocation name, IContainerFactory<C> containerFactory) {
        ContainerType type = new ContainerType(containerFactory);
        type.setRegistryName(name);
        AstralSorcery.getProxy().getRegistryPrimer().register(type);
        return (T)type;
    }
}

