/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.registry;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.crafting.helper.IHandlerRecipe;
import hellfirepvp.astralsorcery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.astralsorcery.common.crafting.helper.ResolvingRecipeType;
import hellfirepvp.astralsorcery.common.crafting.nojson.AttunementCraftingRegistry;
import hellfirepvp.astralsorcery.common.crafting.nojson.LiquidStarlightCraftingRegistry;
import hellfirepvp.astralsorcery.common.crafting.nojson.WorldFreezingRegistry;
import hellfirepvp.astralsorcery.common.crafting.nojson.WorldMeltableRegistry;
import hellfirepvp.astralsorcery.common.crafting.recipe.BlockTransmutation;
import hellfirepvp.astralsorcery.common.crafting.recipe.LiquidInfusion;
import hellfirepvp.astralsorcery.common.crafting.recipe.SimpleAltarRecipe;
import hellfirepvp.astralsorcery.common.crafting.recipe.WellLiquefaction;
import hellfirepvp.astralsorcery.common.crafting.recipe.altar.effect.AltarRecipeEffect;
import hellfirepvp.astralsorcery.common.crafting.recipe.altar.effect.BuiltInEffectAttunementSparkle;
import hellfirepvp.astralsorcery.common.crafting.recipe.altar.effect.BuiltInEffectConstellationFinish;
import hellfirepvp.astralsorcery.common.crafting.recipe.altar.effect.BuiltInEffectConstellationLines;
import hellfirepvp.astralsorcery.common.crafting.recipe.altar.effect.BuiltInEffectDiscoveryCentralBeam;
import hellfirepvp.astralsorcery.common.crafting.recipe.altar.effect.BuiltInEffectTraitFocusCircle;
import hellfirepvp.astralsorcery.common.crafting.recipe.altar.effect.BuiltInEffectTraitRelayHighlight;
import hellfirepvp.astralsorcery.common.crafting.recipe.altar.effect.EffectAltarDefaultLightbeams;
import hellfirepvp.astralsorcery.common.crafting.recipe.altar.effect.EffectAltarDefaultSparkle;
import hellfirepvp.astralsorcery.common.crafting.recipe.altar.effect.EffectAltarFocusSparkle;
import hellfirepvp.astralsorcery.common.crafting.recipe.altar.effect.EffectAltarRandomSparkle;
import hellfirepvp.astralsorcery.common.crafting.recipe.altar.effect.EffectFocusDustSwirl;
import hellfirepvp.astralsorcery.common.crafting.recipe.altar.effect.EffectFocusEdge;
import hellfirepvp.astralsorcery.common.crafting.recipe.altar.effect.EffectGatewayEdge;
import hellfirepvp.astralsorcery.common.crafting.recipe.altar.effect.EffectLargeDustSwirl;
import hellfirepvp.astralsorcery.common.crafting.recipe.altar.effect.EffectLiquidBurst;
import hellfirepvp.astralsorcery.common.crafting.recipe.altar.effect.EffectLuminescenceBurst;
import hellfirepvp.astralsorcery.common.crafting.recipe.altar.effect.EffectLuminescenceFlare;
import hellfirepvp.astralsorcery.common.crafting.recipe.altar.effect.EffectPillarLightbeams;
import hellfirepvp.astralsorcery.common.crafting.recipe.altar.effect.EffectPillarSparkle;
import hellfirepvp.astralsorcery.common.crafting.recipe.altar.effect.EffectUpgradeAltar;
import hellfirepvp.astralsorcery.common.crafting.recipe.altar.effect.EffectVortexPlane;
import hellfirepvp.astralsorcery.common.lib.AltarRecipeEffectsAS;
import hellfirepvp.astralsorcery.common.lib.RecipeTypesAS;
import hellfirepvp.astralsorcery.common.util.NameUtil;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.items.IItemHandler;

public class RegistryRecipeTypes {
    private RegistryRecipeTypes() {
    }

    public static void init() {
        RecipeTypesAS.TYPE_WELL = new ResolvingRecipeType("well", WellLiquefaction.class, (recipe, context) -> recipe.matches(context.getInput()));
        RecipeTypesAS.TYPE_INFUSION = new ResolvingRecipeType("infusion", LiquidInfusion.class, (recipe, context) -> recipe.matches(context.getInfuser(), context.getCrafter(), context.getSide()));
        RecipeTypesAS.TYPE_BLOCK_TRANSMUTATION = new ResolvingRecipeType("block_transmutation", BlockTransmutation.class, (recipe, context) -> recipe.matches(context.getWorld(), context.getPos(), context.getState(), context.getConstellation()));
        RecipeTypesAS.TYPE_ALTAR = new ResolvingRecipeType("simple_altar", SimpleAltarRecipe.class, (recipe, context) -> recipe.matches(context.getSide(), context.getCrafter(), context.getAltar(), context.ignoreStarlightRequirement()));
        LiquidStarlightCraftingRegistry.INSTANCE.init();
        AttunementCraftingRegistry.INSTANCE.init();
        WorldMeltableRegistry.INSTANCE.init();
        WorldFreezingRegistry.INSTANCE.init();
    }

    public static void initAltarEffects() {
        AltarRecipeEffectsAS.BUILTIN_ATTUNEMENT_SPARKLE = RegistryRecipeTypes.registerEffect(new BuiltInEffectAttunementSparkle());
        AltarRecipeEffectsAS.BUILTIN_CONSTELLATION_LINES = RegistryRecipeTypes.registerEffect(new BuiltInEffectConstellationLines());
        AltarRecipeEffectsAS.BUILTIN_CONSTELLATION_FINISH = RegistryRecipeTypes.registerEffect(new BuiltInEffectConstellationFinish());
        AltarRecipeEffectsAS.BUILTIN_DISCOVERY_CENTRAL_BEAM = RegistryRecipeTypes.registerEffect(new BuiltInEffectDiscoveryCentralBeam());
        AltarRecipeEffectsAS.BUILTIN_TRAIT_FOCUS_CIRCLE = RegistryRecipeTypes.registerEffect(new BuiltInEffectTraitFocusCircle());
        AltarRecipeEffectsAS.BUILTIN_TRAIT_RELAY_HIGHLIGHT = RegistryRecipeTypes.registerEffect(new BuiltInEffectTraitRelayHighlight());
        AltarRecipeEffectsAS.ALTAR_DEFAULT_LIGHTBEAMS = RegistryRecipeTypes.registerEffect(new EffectAltarDefaultLightbeams());
        AltarRecipeEffectsAS.ALTAR_DEFAULT_SPARKLE = RegistryRecipeTypes.registerEffect(new EffectAltarDefaultSparkle());
        AltarRecipeEffectsAS.ALTAR_FOCUS_SPARKLE = RegistryRecipeTypes.registerEffect(new EffectAltarFocusSparkle());
        AltarRecipeEffectsAS.ALTAR_RANDOM_SPARKLE = RegistryRecipeTypes.registerEffect(new EffectAltarRandomSparkle());
        AltarRecipeEffectsAS.FOCUS_DUST_SWIRL = RegistryRecipeTypes.registerEffect(new EffectFocusDustSwirl());
        AltarRecipeEffectsAS.FOCUS_EDGE = RegistryRecipeTypes.registerEffect(new EffectFocusEdge());
        AltarRecipeEffectsAS.GATEWAY_EDGE = RegistryRecipeTypes.registerEffect(new EffectGatewayEdge());
        AltarRecipeEffectsAS.LARGE_DUST_SWIRL = RegistryRecipeTypes.registerEffect(new EffectLargeDustSwirl());
        AltarRecipeEffectsAS.LIQUID_BURST = RegistryRecipeTypes.registerEffect(new EffectLiquidBurst());
        AltarRecipeEffectsAS.LUMINESCENCE_BURST = RegistryRecipeTypes.registerEffect(new EffectLuminescenceBurst());
        AltarRecipeEffectsAS.LUMINESCENCE_FLARE = RegistryRecipeTypes.registerEffect(new EffectLuminescenceFlare());
        AltarRecipeEffectsAS.PILLAR_LIGHTBEAMS = RegistryRecipeTypes.registerEffect(new EffectPillarLightbeams());
        AltarRecipeEffectsAS.PILLAR_SPARKLE = RegistryRecipeTypes.registerEffect(new EffectPillarSparkle());
        AltarRecipeEffectsAS.UPGRADE_ALTAR = RegistryRecipeTypes.registerEffect(new EffectUpgradeAltar());
        AltarRecipeEffectsAS.VORTEX_PLANE = RegistryRecipeTypes.registerEffect(new EffectVortexPlane());
    }

    private static <T extends AltarRecipeEffect> T registerEffect(T recipeEffect) {
        recipeEffect.setRegistryName(NameUtil.fromClass(recipeEffect, "Effect"));
        AstralSorcery.getProxy().getRegistryPrimer().register(recipeEffect);
        return recipeEffect;
    }

    private static <C extends IItemHandler, T extends IHandlerRecipe<C>, R extends RecipeCraftingContext<T, C>, S extends ResolvingRecipeType<C, T, R>> S register(S recipeType) {
        Registry.func_218322_a((Registry)Registry.field_218367_H, (ResourceLocation)recipeType.getRegistryName(), recipeType.getType());
        return recipeType;
    }
}

