/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.registry;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.data.config.ServerConfig;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.lib.WorldGenerationAS;
import hellfirepvp.astralsorcery.common.util.block.BlockStateList;
import hellfirepvp.astralsorcery.common.world.config.FeaturePlacementConfig;
import hellfirepvp.astralsorcery.common.world.config.ReplacingFeaturePlacementConfig;
import hellfirepvp.astralsorcery.common.world.config.StructurePlacementConfig;
import hellfirepvp.astralsorcery.common.world.feature.AquamarineFeature;
import hellfirepvp.astralsorcery.common.world.feature.GlowFlowerFeature;
import hellfirepvp.astralsorcery.common.world.feature.RockCrystalFeature;
import hellfirepvp.astralsorcery.common.world.placement.RandomFlowerPlacement;
import hellfirepvp.astralsorcery.common.world.placement.RandomReplaceablePlacement;
import hellfirepvp.astralsorcery.common.world.placement.RiverbedPlacement;
import hellfirepvp.astralsorcery.common.world.placement.SimpleCountRangePlacement;
import hellfirepvp.astralsorcery.common.world.structure.AncientShrineStructure;
import hellfirepvp.astralsorcery.common.world.structure.DesertShrineStructure;
import hellfirepvp.astralsorcery.common.world.structure.SmallShrineStructure;
import hellfirepvp.astralsorcery.common.world.structure.feature.FeatureAncientShrineStructure;
import hellfirepvp.astralsorcery.common.world.structure.feature.FeatureDesertShrineStructure;
import hellfirepvp.astralsorcery.common.world.structure.feature.FeatureSmallShrineStructure;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.registries.ForgeRegistries;

public class RegistryWorldGeneration {
    private RegistryWorldGeneration() {
    }

    public static void registerFeatureConfigurations(ServerConfig cfg) {
        WorldGenerationAS.Placement.DESERT_SHRINE = cfg.addConfigEntry(new StructurePlacementConfig("struct_desert", 9, Lists.newArrayList((Object[])new BiomeDictionary.Type[]{BiomeDictionary.Type.SANDY}), Lists.newArrayList((Object[])new DimensionType[]{DimensionType.field_223227_a_}), 20, 90, 90, 12, 5));
        WorldGenerationAS.Placement.MOUNTAIN_SHRINE = cfg.addConfigEntry(new StructurePlacementConfig("struct_mountain", 19, Lists.newArrayList((Object[])new BiomeDictionary.Type[]{BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.MOUNTAIN}), Lists.newArrayList((Object[])new DimensionType[]{DimensionType.field_223227_a_}), 50, 160, 90, 12, 5));
        WorldGenerationAS.Placement.SMALL_SHRINE = cfg.addConfigEntry(new StructurePlacementConfig("struct_small", 9, Lists.newArrayList((Object[])new BiomeDictionary.Type[]{BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.FOREST}), Lists.newArrayList((Object[])new DimensionType[]{DimensionType.field_223227_a_}), 20, 200, 140, 12, 8));
        WorldGenerationAS.Placement.GLOW_FLOWER = cfg.addConfigEntry(new FeaturePlacementConfig("glow_flower", true, true, Lists.newArrayList((Object[])new BiomeDictionary.Type[]{BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.COLD}), Lists.newArrayList((Object[])new DimensionType[]{DimensionType.field_223227_a_}), 50, 210, 12, 5));
        WorldGenerationAS.Placement.ROCK_CRYSTAL = cfg.addConfigEntry(new ReplacingFeaturePlacementConfig("rock_crystal", false, true, Lists.newArrayList(), Lists.newArrayList((Object[])new DimensionType[]{DimensionType.field_223227_a_}), 2, 8, 14, 2, new BlockStateList().add(Blocks.field_150348_b).add(Blocks.field_196654_e).add(Blocks.field_196650_c).add(Blocks.field_196656_g)));
        WorldGenerationAS.Placement.AQUAMARINE = cfg.addConfigEntry(new ReplacingFeaturePlacementConfig("aquamarine", false, true, Lists.newArrayList(), Lists.newArrayList((Object[])new DimensionType[]{DimensionType.field_223227_a_}), 52, 67, 2, 40, new BlockStateList().add(Blocks.field_150354_m)));
        WorldGenerationAS.Placement.MARBLE = cfg.addConfigEntry(new FeaturePlacementConfig("marble", false, false, Lists.newArrayList(), Lists.newArrayList(), 0, 64, 1, 8));
    }

    public static void registerFeatures() {
        WorldGenerationAS.ANCIENT_SHRINE_PIECE = (IStructurePieceType)Registry.func_218322_a((Registry)Registry.field_218362_C, (ResourceLocation)WorldGenerationAS.KEY_ANCIENT_SHRINE, AncientShrineStructure::new);
        WorldGenerationAS.DESERT_SHRINE_PIECE = (IStructurePieceType)Registry.func_218322_a((Registry)Registry.field_218362_C, (ResourceLocation)WorldGenerationAS.KEY_DESERT_SHRINE, DesertShrineStructure::new);
        WorldGenerationAS.SMALL_SHRINE_PIECE = (IStructurePieceType)Registry.func_218322_a((Registry)Registry.field_218362_C, (ResourceLocation)WorldGenerationAS.KEY_SMALL_SHRINE, SmallShrineStructure::new);
        WorldGenerationAS.STRUCTURE_ANCIENT_SHRINE = RegistryWorldGeneration.register(new FeatureAncientShrineStructure(WorldGenerationAS.Placement.MOUNTAIN_SHRINE), WorldGenerationAS.KEY_ANCIENT_SHRINE);
        WorldGenerationAS.STRUCTURE_DESERT_SHRINE = RegistryWorldGeneration.register(new FeatureDesertShrineStructure(WorldGenerationAS.Placement.DESERT_SHRINE), WorldGenerationAS.KEY_DESERT_SHRINE);
        WorldGenerationAS.STRUCTURE_SMALL_SHRINE = RegistryWorldGeneration.register(new FeatureSmallShrineStructure(WorldGenerationAS.Placement.SMALL_SHRINE), WorldGenerationAS.KEY_SMALL_SHRINE);
    }

    private static <FC extends IFeatureConfig, V extends Feature<FC>> V register(V feature, ResourceLocation key) {
        AstralSorcery.getProxy().getRegistryPrimer().register(feature.setRegistryName(key));
        return feature;
    }

    public static void addFeaturesToBiomes() {
        RegistryWorldGeneration.registerStructure(GenerationStage.Decoration.SURFACE_STRUCTURES, WorldGenerationAS.STRUCTURE_ANCIENT_SHRINE, NoFeatureConfig.field_202429_e);
        RegistryWorldGeneration.registerStructure(GenerationStage.Decoration.SURFACE_STRUCTURES, WorldGenerationAS.STRUCTURE_DESERT_SHRINE, NoFeatureConfig.field_202429_e);
        RegistryWorldGeneration.registerStructure(GenerationStage.Decoration.SURFACE_STRUCTURES, WorldGenerationAS.STRUCTURE_SMALL_SHRINE, NoFeatureConfig.field_202429_e);
        RegistryWorldGeneration.registerFeature(GenerationStage.Decoration.VEGETAL_DECORATION, new GlowFlowerFeature(), NoFeatureConfig.field_202429_e, new RandomFlowerPlacement(WorldGenerationAS.Placement.GLOW_FLOWER), WorldGenerationAS.Placement.GLOW_FLOWER);
        RegistryWorldGeneration.registerFeature(GenerationStage.Decoration.UNDERGROUND_ORES, new RockCrystalFeature(), NoFeatureConfig.field_202429_e, new RandomReplaceablePlacement(WorldGenerationAS.Placement.ROCK_CRYSTAL), WorldGenerationAS.Placement.ROCK_CRYSTAL);
        RegistryWorldGeneration.registerFeature(GenerationStage.Decoration.UNDERGROUND_ORES, new AquamarineFeature(), NoFeatureConfig.field_202429_e, new RiverbedPlacement(WorldGenerationAS.Placement.AQUAMARINE), WorldGenerationAS.Placement.AQUAMARINE);
        RegistryWorldGeneration.registerFeature(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj, new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, BlocksAS.MARBLE_RAW.func_176223_P(), 27), new SimpleCountRangePlacement(WorldGenerationAS.Placement.MARBLE), WorldGenerationAS.Placement.MARBLE);
    }

    private static <FC extends IFeatureConfig, PC extends IPlacementConfig> void registerFeature(GenerationStage.Decoration stage, Feature<FC> feature, FC featureConfig, Placement<PC> placement, PC placementConfig) {
        for (Biome b : ForgeRegistries.BIOMES) {
            b.func_203611_a(stage, feature.func_225566_b_(featureConfig).func_227228_a_(placement.func_227446_a_(placementConfig)));
        }
    }

    private static <FC extends IFeatureConfig> void registerStructure(GenerationStage.Decoration stage, Structure<FC> structure, FC featureConfig) {
        for (Biome b : ForgeRegistries.BIOMES) {
            b.func_203611_a(stage, structure.func_225566_b_(featureConfig).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
            b.func_226711_a_(structure.func_225566_b_(featureConfig));
        }
    }
}

