/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.starlight;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.data.world.LightNetworkBuffer;
import hellfirepvp.astralsorcery.common.lib.DataAS;
import hellfirepvp.astralsorcery.common.starlight.IIndependentStarlightSource;
import hellfirepvp.astralsorcery.common.starlight.IStarlightSource;
import hellfirepvp.astralsorcery.common.starlight.IStarlightTransmission;
import hellfirepvp.astralsorcery.common.starlight.network.StarlightTransmissionHandler;
import hellfirepvp.astralsorcery.common.starlight.network.TransmissionWorldHandler;
import hellfirepvp.astralsorcery.common.starlight.transmission.IPrismTransmissionNode;
import hellfirepvp.astralsorcery.common.starlight.transmission.ITransmissionSource;
import hellfirepvp.astralsorcery.common.starlight.transmission.NodeConnection;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class WorldNetworkHandler {
    private final LightNetworkBuffer buffer;
    private World world;

    public WorldNetworkHandler(LightNetworkBuffer lightNetworkBuffer, World world) {
        this.buffer = lightNetworkBuffer;
        this.world = world;
    }

    public World getWorld() {
        return this.world;
    }

    public static WorldNetworkHandler getNetworkHandler(World world) {
        return ((LightNetworkBuffer)DataAS.DOMAIN_AS.getData((IWorld)world, DataAS.KEY_STARLIGHT_NETWORK)).getNetworkHandler(world);
    }

    public void informBlockChange(BlockPos at) {
        List<LightNetworkBuffer.ChunkSectionNetworkData> relatedData = this.getAffectedChunkSections(at);
        if (relatedData.isEmpty()) {
            return;
        }
        TransmissionWorldHandler handle = StarlightTransmissionHandler.getInstance().getWorldHandler((IWorld)this.getWorld());
        for (LightNetworkBuffer.ChunkSectionNetworkData data : relatedData) {
            if (data == null) continue;
            Collection<IPrismTransmissionNode> transmissionNodes = data.getAllTransmissionNodes();
            for (IPrismTransmissionNode node : transmissionNodes) {
                if (!node.notifyBlockChange(this.getWorld(), at) || handle == null) continue;
                handle.notifyTransmissionNodeChange(node);
            }
        }
    }

    public void attemptAutoLinkTo(BlockPos at) {
        TransmissionWorldHandler handle = StarlightTransmissionHandler.getInstance().getWorldHandler((IWorld)this.world);
        for (Tuple<BlockPos, IIndependentStarlightSource> source : this.getAllSources()) {
            if (!((IIndependentStarlightSource)source.func_76340_b()).providesAutoLink() || !(((BlockPos)source.func_76341_a()).func_177951_i((Vec3i)at) <= 256.0)) continue;
            IPrismTransmissionNode node = this.getTransmissionNode((BlockPos)source.func_76341_a());
            if (node == null) {
                AstralSorcery.log.warn("Didn't find a TransmissionNode at a position that's supposed to be a source!");
                AstralSorcery.log.warn("Details: Dim=" + this.getWorld().func_201675_m().func_186058_p().func_186068_a() + " at " + source.func_76341_a());
                continue;
            }
            if (!(node instanceof ITransmissionSource)) {
                AstralSorcery.log.warn("Found TransmissionNode that isn't a source at a source position!");
                AstralSorcery.log.warn("Details: Dim=" + this.getWorld().func_201675_m().func_186058_p().func_186068_a() + " at " + source.func_76341_a());
                continue;
            }
            ITransmissionSource sourceNode = (ITransmissionSource)node;
            if (sourceNode.getLocationPos().func_177956_o() <= at.func_177956_o()) continue;
            sourceNode.notifyLink(this.getWorld(), at);
            this.markDirty(new Vec3i[]{at, (Vec3i)source.func_76341_a()});
            if (handle == null) continue;
            handle.notifyTransmissionNodeChange(sourceNode);
        }
    }

    public void removeAutoLinkTo(BlockPos at) {
        TransmissionWorldHandler handle = StarlightTransmissionHandler.getInstance().getWorldHandler((IWorld)this.world);
        for (Tuple<BlockPos, IIndependentStarlightSource> source : this.getAllSources()) {
            if (!((IIndependentStarlightSource)source.func_76340_b()).providesAutoLink() || !(((BlockPos)source.func_76341_a()).func_177951_i((Vec3i)at) <= 256.0)) continue;
            IPrismTransmissionNode node = this.getTransmissionNode((BlockPos)source.func_76341_a());
            if (node == null) {
                AstralSorcery.log.warn("Didn't find a TransmissionNode at a position that's supposed to be a source!");
                AstralSorcery.log.warn("Details: Dim=" + this.getWorld().func_201675_m().func_186058_p().func_186068_a() + " at " + source.func_76341_a());
                continue;
            }
            if (!(node instanceof ITransmissionSource)) {
                AstralSorcery.log.warn("Found TransmissionNode that isn't a source at a source position!");
                AstralSorcery.log.warn("Details: Dim=" + this.getWorld().func_201675_m().func_186058_p().func_186068_a() + " at " + source.func_76341_a());
                continue;
            }
            ITransmissionSource sourceNode = (ITransmissionSource)node;
            if (!sourceNode.notifyUnlink(this.getWorld(), at)) continue;
            this.markDirty(new Vec3i[]{at, (Vec3i)source.func_76341_a()});
            if (handle == null) continue;
            handle.notifyTransmissionNodeChange(sourceNode);
        }
    }

    @Nullable
    public IPrismTransmissionNode getTransmissionNode(@Nullable BlockPos pos) {
        if (pos == null) {
            return null;
        }
        LightNetworkBuffer.ChunkSectionNetworkData section = this.getNetworkData(pos);
        if (section != null) {
            return section.getTransmissionNode(pos);
        }
        return null;
    }

    public void markDirty(Vec3i ... positions) {
        for (Vec3i pos : positions) {
            this.buffer.markDirty(pos);
        }
    }

    @Nullable
    public IIndependentStarlightSource getSourceAt(BlockPos pos) {
        return this.buffer.getSource(pos);
    }

    public Collection<Tuple<BlockPos, IIndependentStarlightSource>> getAllSources() {
        return this.buffer.getAllSources();
    }

    public void removeSource(IStarlightSource source) {
        this.removeThisSourceFromNext(source);
        this.removeThisNextFromSources(source);
        this.buffer.removeSource(source.getTrPos());
    }

    public void removeTransmission(IStarlightTransmission transmission) {
        this.removeThisSourceFromNext(transmission);
        this.removeThisNextFromSources(transmission);
        this.buffer.removeTransmission(transmission.getTrPos());
    }

    public void addNewSourceTile(IStarlightSource source) {
        this.buffer.addSource(source, source.getTrPos());
        this.linkNextToThisSources(source);
    }

    public void addTransmissionTile(IStarlightTransmission transmission) {
        this.buffer.addTransmission(transmission, transmission.getTrPos());
        this.linkNextToThisSources(transmission);
    }

    private void removeThisNextFromSources(IStarlightTransmission tr) {
        TransmissionWorldHandler handle = StarlightTransmissionHandler.getInstance().getWorldHandler((IWorld)this.getWorld());
        if (handle == null) {
            return;
        }
        Object node = tr.getNode();
        if (node == null) {
            new Throwable().printStackTrace();
            AstralSorcery.log.warn("Could not find transmission node for Transmission tile '" + tr.getClass().getSimpleName() + "'");
            AstralSorcery.log.warn("This is an implementation error. Report it along with the steps to create this, if you come across this.");
            return;
        }
        for (BlockPos pos : node.getSources()) {
            IPrismTransmissionNode sourceNode = this.getTransmissionNode(pos);
            if (sourceNode == null) continue;
            handle.notifyTransmissionNodeChange(sourceNode);
        }
    }

    private void removeThisSourceFromNext(IStarlightTransmission tr) {
        Object node = tr.getNode();
        if (node == null) {
            AstralSorcery.log.warn("Could not find transmission node for Transmission tile '" + tr.getClass().getSimpleName() + "'");
            AstralSorcery.log.warn("This is an implementation error. Report it along with the steps to create this, if you come across this.");
            return;
        }
        TransmissionWorldHandler handle = StarlightTransmissionHandler.getInstance().getWorldHandler((IWorld)this.getWorld());
        if (handle != null) {
            handle.notifyTransmissionNodeChange((IPrismTransmissionNode)node);
        }
        BlockPos thisPos = tr.getTrPos();
        List<NodeConnection<IPrismTransmissionNode>> nodeConnections = node.queryNext(this);
        for (NodeConnection<IPrismTransmissionNode> connection : nodeConnections) {
            if (connection.getNode() == null) continue;
            connection.getNode().notifySourceUnlink(this.getWorld(), thisPos);
            if (handle == null) continue;
            handle.notifyTransmissionNodeChange(connection.getNode());
        }
    }

    private void linkNextToThisSources(IStarlightTransmission tr) {
        Object node = tr.getNode();
        if (node == null) {
            AstralSorcery.log.warn("Previously added Transmission tile '" + tr.getClass().getSimpleName() + "' didn't create a Transmission node!");
            AstralSorcery.log.warn("This is an implementation error. Report it along with the steps to create this, if you come across this.");
            return;
        }
        BlockPos thisPos = tr.getTrPos();
        TransmissionWorldHandler handle = StarlightTransmissionHandler.getInstance().getWorldHandler((IWorld)this.getWorld());
        List<LightNetworkBuffer.ChunkSectionNetworkData> dataList = this.getAffectedChunkSections(tr.getTrPos());
        for (LightNetworkBuffer.ChunkSectionNetworkData data : dataList) {
            if (data == null) continue;
            for (IPrismTransmissionNode otherNode : data.getAllTransmissionNodes()) {
                List<NodeConnection<IPrismTransmissionNode>> nodeConnections = otherNode.queryNext(this);
                for (NodeConnection<IPrismTransmissionNode> connection : nodeConnections) {
                    if (!connection.getTo().equals((Object)thisPos)) continue;
                    node.notifySourceLink(this.getWorld(), otherNode.getLocationPos());
                    if (handle == null) continue;
                    handle.notifyTransmissionNodeChange(otherNode);
                }
            }
        }
    }

    private List<LightNetworkBuffer.ChunkSectionNetworkData> getAffectedChunkSections(BlockPos centralPos) {
        LinkedList<LightNetworkBuffer.ChunkSectionNetworkData> dataList = new LinkedList<LightNetworkBuffer.ChunkSectionNetworkData>();
        ChunkPos central = new ChunkPos(centralPos);
        int posYLevel = MathHelper.func_76125_a((int)centralPos.func_177956_o(), (int)0, (int)255);
        for (int xx = -1; xx <= 1; ++xx) {
            for (int zz = -1; zz <= 1; ++zz) {
                for (int yy = -1; yy <= 1; ++yy) {
                    BlockPos pos = central.func_206849_h();
                    pos = pos.func_177982_a(xx * 16, MathHelper.func_76125_a((int)(posYLevel + yy * 16), (int)0, (int)255), zz * 16);
                    this.queryData(pos, dataList);
                }
            }
        }
        return dataList;
    }

    private void queryData(BlockPos pos, List<LightNetworkBuffer.ChunkSectionNetworkData> out) {
        LightNetworkBuffer.ChunkSectionNetworkData data = this.buffer.getSectionData(pos);
        if (data != null && !data.isEmpty()) {
            out.add(data);
        }
    }

    @Nullable
    private LightNetworkBuffer.ChunkSectionNetworkData getNetworkData(BlockPos at) {
        LightNetworkBuffer.ChunkSectionNetworkData data = this.buffer.getSectionData(at);
        if (data != null && !data.isEmpty()) {
            return data;
        }
        return null;
    }
}

