/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.starlight.network.handler;

import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.function.VFXAlphaFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXColorFunction;
import hellfirepvp.astralsorcery.client.effect.handler.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.vfx.FXFacingParticle;
import hellfirepvp.astralsorcery.client.lib.EffectTemplatesAS;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.crafting.recipe.BlockTransmutation;
import hellfirepvp.astralsorcery.common.crafting.recipe.BlockTransmutationContext;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.lib.ColorsAS;
import hellfirepvp.astralsorcery.common.lib.RecipeTypesAS;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.play.server.PktPlayEffect;
import hellfirepvp.astralsorcery.common.starlight.network.StarlightNetworkRegistry;
import hellfirepvp.astralsorcery.common.util.block.WorldBlockPos;
import hellfirepvp.astralsorcery.common.util.data.ByteBufUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.item.ItemUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockTransmutationHandler
implements StarlightNetworkRegistry.IStarlightBlockHandler {
    private static Map<WorldBlockPos, ActiveTransmutation> runningTransmutations = new HashMap<WorldBlockPos, ActiveTransmutation>();

    @Override
    public boolean isApplicable(World world, BlockPos pos, BlockState state, IWeakConstellation starlightType) {
        return RecipeTypesAS.TYPE_BLOCK_TRANSMUTATION.findRecipe(new BlockTransmutationContext((IWorld)world, pos, state, starlightType)) != null;
    }

    @Override
    public void receiveStarlight(World world, Random rand, BlockPos pos, BlockState state, IWeakConstellation starlightType, double amount) {
        BlockTransmutation recipe = RecipeTypesAS.TYPE_BLOCK_TRANSMUTATION.findRecipe(new BlockTransmutationContext((IWorld)world, pos, state, starlightType));
        if (recipe == null) {
            return;
        }
        WorldBlockPos at = WorldBlockPos.wrapServer(world, pos);
        ActiveTransmutation activeRecipe = runningTransmutations.get((Object)at);
        if (activeRecipe == null || !activeRecipe.recipe.equals(recipe)) {
            activeRecipe = new ActiveTransmutation(recipe);
            runningTransmutations.put(at, activeRecipe);
        }
        activeRecipe.acceptStarlight(amount);
        PktPlayEffect pkt = new PktPlayEffect(PktPlayEffect.Type.BLOCK_TRANSMUTATION_TICK).addData(buf -> ByteBufUtils.writePos(buf, pos));
        PacketChannel.CHANNEL.sendToAllAround(pkt, PacketChannel.pointFromPos((IWorld)world, (Vec3i)pos, 24.0));
        if (activeRecipe.isFinished() && activeRecipe.finish((IWorld)world, pos)) {
            runningTransmutations.remove((Object)at);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void playTransmutation(PktPlayEffect effect) {
        Random rand = new Random();
        BlockPos pos = ByteBufUtils.readPos(effect.getExtraData());
        ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(new Vector3((Vec3i)pos).add(rand.nextFloat(), rand.nextFloat(), rand.nextFloat()))).setAlphaMultiplier(1.0f)).alpha(VFXAlphaFunction.FADE_OUT)).color(VFXColorFunction.constant(ColorsAS.ROCK_CRYSTAL))).setScaleMultiplier(0.2f + rand.nextFloat() * 0.15f)).setGravityStrength(-0.0014f)).setMaxAge(40 + rand.nextInt(20));
    }

    private static class ActiveTransmutation {
        private static final int MS_THRESHOLD = 15000;
        private final BlockTransmutation recipe;
        private long lastMillisecondStarlightReceived = System.currentTimeMillis();
        private double accumulatedStarlight = 0.0;

        private ActiveTransmutation(BlockTransmutation recipe) {
            this.recipe = recipe;
        }

        private void acceptStarlight(double amount) {
            long msReceived = System.currentTimeMillis();
            long receiveDiff = msReceived - this.lastMillisecondStarlightReceived;
            if (receiveDiff >= 15000L) {
                this.accumulatedStarlight = 0.0;
            }
            this.accumulatedStarlight += amount;
            this.lastMillisecondStarlightReceived = msReceived;
        }

        private boolean isFinished() {
            return this.accumulatedStarlight >= this.recipe.getStarlightRequired();
        }

        private boolean finish(IWorld world, BlockPos pos) {
            BlockState out = this.recipe.getOutput();
            if (world.func_180501_a(pos, out, 11)) {
                ItemStack stack = ItemUtils.createBlockStack(out);
                if (!stack.func_190926_b()) {
                    world.func_217369_A().stream().filter(player -> player.func_70092_e((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()) <= 144.0).forEach(player -> ResearchManager.informCrafted(player, stack));
                }
                return true;
            }
            this.accumulatedStarlight *= (double)0.9f;
            return false;
        }
    }
}

