/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.starlight.transmission.base;

import hellfirepvp.astralsorcery.common.starlight.WorldNetworkHandler;
import hellfirepvp.astralsorcery.common.starlight.network.StarlightTransmissionHandler;
import hellfirepvp.astralsorcery.common.starlight.network.TransmissionWorldHandler;
import hellfirepvp.astralsorcery.common.starlight.transmission.IPrismTransmissionNode;
import hellfirepvp.astralsorcery.common.starlight.transmission.ITransmissionNode;
import hellfirepvp.astralsorcery.common.starlight.transmission.NodeConnection;
import hellfirepvp.astralsorcery.common.starlight.transmission.registry.TransmissionProvider;
import hellfirepvp.astralsorcery.common.util.RaytraceAssist;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class SimpleTransmissionNode
implements ITransmissionNode {
    private boolean ignoreBlockCollision = false;
    private boolean nextReachable = false;
    private BlockPos nextPos = null;
    private double dstToNextSq = 0.0;
    private RaytraceAssist assistNext = null;
    private BlockPos thisPos;
    private Set<BlockPos> sourcesToThis = new HashSet<BlockPos>();

    public SimpleTransmissionNode(BlockPos thisPos) {
        this.thisPos = thisPos;
    }

    @Override
    public BlockPos getLocationPos() {
        return this.thisPos;
    }

    public void updateIgnoreBlockCollisionState(World world, boolean ignoreBlockCollision) {
        this.ignoreBlockCollision = ignoreBlockCollision;
        TransmissionWorldHandler handle = StarlightTransmissionHandler.getInstance().getWorldHandler((IWorld)world);
        if (this.assistNext != null && handle != null) {
            boolean oldState = this.nextReachable;
            boolean bl = this.nextReachable = ignoreBlockCollision || this.assistNext.isClear(world);
            if (this.nextReachable != oldState) {
                handle.notifyTransmissionNodeChange(this);
            }
        }
    }

    public boolean ignoresBlockCollision() {
        return this.ignoreBlockCollision;
    }

    @Override
    public boolean notifyUnlink(World world, BlockPos to) {
        if (to.equals((Object)this.nextPos)) {
            this.nextPos = null;
            this.assistNext = null;
            this.dstToNextSq = 0.0;
            this.nextReachable = false;
            return true;
        }
        return false;
    }

    @Override
    public void notifyLink(World world, BlockPos pos) {
        this.addLink(world, pos, true, false);
    }

    private void addLink(World world, BlockPos pos, boolean doRayTest, boolean oldRayState) {
        this.nextPos = pos;
        this.assistNext = new RaytraceAssist(this.thisPos, this.nextPos);
        this.nextReachable = doRayTest ? this.ignoreBlockCollision || this.assistNext.isClear(world) : oldRayState;
        this.dstToNextSq = pos.func_177951_i((Vec3i)this.thisPos);
    }

    @Override
    public boolean notifyBlockChange(World world, BlockPos at) {
        if (this.nextPos == null) {
            return false;
        }
        double dstStart = this.thisPos.func_177951_i((Vec3i)at);
        double dstEnd = this.nextPos.func_177951_i((Vec3i)at);
        if (dstStart > this.dstToNextSq || dstEnd > this.dstToNextSq) {
            return false;
        }
        boolean oldState = this.nextReachable;
        this.nextReachable = this.ignoreBlockCollision || this.assistNext.isClear(world);
        return this.nextReachable != oldState;
    }

    @Override
    public void notifySourceLink(World world, BlockPos source) {
        this.sourcesToThis.add(source);
    }

    @Override
    public void notifySourceUnlink(World world, BlockPos source) {
        this.sourcesToThis.remove(source);
    }

    @Override
    public NodeConnection<IPrismTransmissionNode> queryNextNode(WorldNetworkHandler handler) {
        if (this.nextPos == null) {
            return null;
        }
        return new NodeConnection<IPrismTransmissionNode>(handler.getTransmissionNode(this.nextPos), this.nextPos, this.nextReachable);
    }

    @Override
    public List<BlockPos> getSources() {
        return new ArrayList<BlockPos>(this.sourcesToThis);
    }

    @Override
    public TransmissionProvider getProvider() {
        return new Provider();
    }

    @Override
    public void readFromNBT(CompoundNBT compound) {
        this.thisPos = NBTHelper.readBlockPosFromNBT(compound);
        this.sourcesToThis.clear();
        this.ignoreBlockCollision = compound.func_74767_n("ignoreBlockCollision");
        ListNBT list = compound.func_150295_c("sources", 10);
        for (int i = 0; i < list.size(); ++i) {
            this.sourcesToThis.add(NBTHelper.readBlockPosFromNBT(list.func_150305_b(i)));
        }
        if (compound.func_74764_b("nextPos")) {
            CompoundNBT tag = compound.func_74775_l("nextPos");
            BlockPos next = NBTHelper.readBlockPosFromNBT(tag);
            boolean oldRay = tag.func_74767_n("rayState");
            this.addLink(null, next, false, oldRay);
        }
    }

    @Override
    public void writeToNBT(CompoundNBT compound) {
        NBTHelper.writeBlockPosToNBT(this.thisPos, compound);
        compound.func_74757_a("ignoreBlockCollision", this.ignoreBlockCollision);
        ListNBT sources = new ListNBT();
        for (BlockPos source : this.sourcesToThis) {
            CompoundNBT comp = new CompoundNBT();
            NBTHelper.writeBlockPosToNBT(source, comp);
            sources.add((Object)comp);
        }
        compound.func_218657_a("sources", (INBT)sources);
        if (this.nextPos != null) {
            CompoundNBT pos = new CompoundNBT();
            NBTHelper.writeBlockPosToNBT(this.nextPos, pos);
            pos.func_74757_a("rayState", this.nextReachable);
            compound.func_218657_a("nextPos", (INBT)pos);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleTransmissionNode that = (SimpleTransmissionNode)o;
        return Objects.equals(this.thisPos, that.thisPos);
    }

    public int hashCode() {
        return this.thisPos != null ? this.thisPos.hashCode() : 0;
    }

    public static class Provider
    extends TransmissionProvider {
        @Override
        public IPrismTransmissionNode get() {
            return new SimpleTransmissionNode(null);
        }
    }
}

