/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.starlight.transmission.base;

import hellfirepvp.astralsorcery.common.starlight.transmission.ITransmissionReceiver;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public abstract class SimpleTransmissionReceiver
implements ITransmissionReceiver {
    private BlockPos thisPos;
    private Set<BlockPos> sourcesToThis = new HashSet<BlockPos>();

    public SimpleTransmissionReceiver(BlockPos thisPos) {
        this.thisPos = thisPos;
    }

    @Override
    public BlockPos getLocationPos() {
        return this.thisPos;
    }

    @Override
    public void notifySourceLink(World world, BlockPos source) {
        this.sourcesToThis.add(source);
    }

    @Override
    public void notifySourceUnlink(World world, BlockPos source) {
        this.sourcesToThis.remove(source);
    }

    @Override
    public boolean notifyBlockChange(World world, BlockPos changed) {
        return false;
    }

    @Override
    public List<BlockPos> getSources() {
        return new LinkedList<BlockPos>(this.sourcesToThis);
    }

    @Nullable
    public <T extends TileEntity> T getTileAtPos(World world, Class<T> tileClass) {
        return (T)((TileEntity)MiscUtils.getTileAt((IBlockReader)world, this.getLocationPos(), tileClass, false));
    }

    @Override
    public void readFromNBT(CompoundNBT compound) {
        this.thisPos = NBTHelper.readBlockPosFromNBT(compound);
        this.sourcesToThis.clear();
        ListNBT list = compound.func_150295_c("sources", 10);
        for (int i = 0; i < list.size(); ++i) {
            this.sourcesToThis.add(NBTHelper.readBlockPosFromNBT(list.func_150305_b(i)));
        }
    }

    @Override
    public void writeToNBT(CompoundNBT compound) {
        NBTHelper.writeBlockPosToNBT(this.thisPos, compound);
        ListNBT sources = new ListNBT();
        for (BlockPos source : this.sourcesToThis) {
            CompoundNBT comp = new CompoundNBT();
            NBTHelper.writeBlockPosToNBT(source, comp);
            sources.add((Object)comp);
        }
        compound.func_218657_a("sources", (INBT)sources);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleTransmissionReceiver that = (SimpleTransmissionReceiver)o;
        return Objects.equals(this.thisPos, that.thisPos);
    }
}

