/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.tile;

import hellfirepvp.astralsorcery.common.lib.TileEntityTypesAS;
import hellfirepvp.astralsorcery.common.tile.base.TileEntityTick;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.tile.FluidTankAccess;
import hellfirepvp.astralsorcery.common.util.tile.SimpleSingleFluidTank;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileChalice
extends TileEntityTick {
    private static final int TANK_SIZE = 64000;
    private SimpleSingleFluidTank tank;
    private FluidTankAccess access;
    private Vector3 rotation = new Vector3();
    private Vector3 prevRotation = new Vector3();
    private Vector3 rotationVec = null;

    public TileChalice() {
        super(TileEntityTypesAS.CHALICE);
        this.tank = new SimpleSingleFluidTank(64000);
        this.tank.setOnUpdate(this::markForUpdate);
        this.access = new FluidTankAccess();
        this.access.putTank(0, (IFluidTank)this.tank, Direction.DOWN);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.func_145831_w().func_201670_d()) {
            if (this.rotationVec == null) {
                this.rotationVec = Vector3.random().normalize().multiply(1.5f);
            }
            this.prevRotation = this.rotation.clone();
            this.rotation.add(this.rotationVec);
        }
    }

    @Nonnull
    public SimpleSingleFluidTank getTank() {
        return this.tank;
    }

    @Nonnull
    public IFluidHandler getTankAccess() {
        return (IFluidHandler)this.access.getCapability(Direction.DOWN).orElse(null);
    }

    @Nonnull
    public Vector3 getRotation() {
        return this.rotation;
    }

    @Nonnull
    public Vector3 getPrevRotation() {
        return this.prevRotation;
    }

    @Override
    public void readCustomNBT(CompoundNBT compound) {
        super.readCustomNBT(compound);
        this.tank.readNBT(compound.func_74775_l("tank"));
    }

    @Override
    public void writeCustomNBT(CompoundNBT compound) {
        super.writeCustomNBT(compound);
        compound.func_218657_a("tank", (INBT)this.tank.writeNBT());
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (this.access.hasCapability(cap, side)) {
            return this.access.getCapability(side).cast();
        }
        return super.getCapability(cap, side);
    }
}

