/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.tile;

import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.function.VFXColorFunction;
import hellfirepvp.astralsorcery.client.effect.handler.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.vfx.FXFacingParticle;
import hellfirepvp.astralsorcery.client.lib.EffectTemplatesAS;
import hellfirepvp.astralsorcery.common.block.tile.BlockGemCrystalCluster;
import hellfirepvp.astralsorcery.common.constellation.world.DayTimeHelper;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.lib.TileEntityTypesAS;
import hellfirepvp.astralsorcery.common.tile.base.TileEntityTick;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import net.minecraft.block.BlockState;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TileGemCrystals
extends TileEntityTick {
    public static final int TICK_GROWTH_CHANCE = 20000;

    public TileGemCrystals() {
        super(TileEntityTypesAS.GEM_CRYSTAL_CLUSTER);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.func_145831_w().func_201670_d()) {
            if (this.getGrowth().getGrowthStage() < 2 && this.doesSeeSky()) {
                this.tryGrowWithChance(20000);
            } else if (this.getGrowth().getGrowthStage() == 2 && rand.nextInt(2400) == 0) {
                this.setGrowth(this.getGrowth().shrink());
            }
        } else if (this.getGrowth().getGrowthStage() == 2) {
            this.playHarvestEffects();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void playHarvestEffects() {
        Vector3 pos = new Vector3(this).add(0.5, 0.5, 0.5).add(this.func_195044_w().func_191059_e((IBlockReader)this.func_145831_w(), this.func_174877_v()));
        MiscUtils.applyRandomOffset(pos, rand, 0.5f);
        ((EntityComplexFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(pos)).color(VFXColorFunction.constant(this.getGrowth().getDisplayColor()))).setScaleMultiplier(0.1f + rand.nextFloat() * 0.05f)).setMaxAge(15 + rand.nextInt(5));
    }

    public void tryGrowWithChance(int growthChance) {
        float distribution = DayTimeHelper.getCurrentDaytimeDistribution(this.func_145831_w());
        growthChance = (int)((float)growthChance * (1.0f - 0.2f * distribution));
        this.grow(growthChance);
    }

    public void grow(int chance) {
        if (rand.nextInt(Math.max(chance, 1)) == 0) {
            this.setGrowth(this.getGrowth().grow(this.func_145831_w()));
        }
    }

    public BlockGemCrystalCluster.GrowthStageType getGrowth() {
        BlockState current = this.func_145831_w().func_180495_p(this.func_174877_v());
        return (BlockGemCrystalCluster.GrowthStageType)((Object)current.func_177229_b(BlockGemCrystalCluster.STAGE));
    }

    public void setGrowth(BlockGemCrystalCluster.GrowthStageType stage) {
        BlockState next = (BlockState)BlocksAS.GEM_CRYSTAL_CLUSTER.func_176223_P().func_206870_a(BlockGemCrystalCluster.STAGE, (Comparable)((Object)stage));
        this.func_145831_w().func_175656_a(this.func_174877_v(), next);
    }
}

