/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.tile;

import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.function.VFXColorFunction;
import hellfirepvp.astralsorcery.client.effect.handler.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.vfx.FXFacingParticle;
import hellfirepvp.astralsorcery.client.effect.vfx.FXLightbeam;
import hellfirepvp.astralsorcery.client.lib.EffectTemplatesAS;
import hellfirepvp.astralsorcery.common.block.tile.BlockLens;
import hellfirepvp.astralsorcery.common.crystal.CrystalAttributeTile;
import hellfirepvp.astralsorcery.common.crystal.CrystalAttributes;
import hellfirepvp.astralsorcery.common.item.lens.LensColorType;
import hellfirepvp.astralsorcery.common.lib.TileEntityTypesAS;
import hellfirepvp.astralsorcery.common.starlight.transmission.IPrismTransmissionNode;
import hellfirepvp.astralsorcery.common.tile.base.network.TileTransmissionBase;
import hellfirepvp.astralsorcery.common.tile.network.StarlightTransmissionLens;
import hellfirepvp.astralsorcery.common.util.RaytraceAssist;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.awt.Color;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TileLens
extends TileTransmissionBase<IPrismTransmissionNode>
implements CrystalAttributeTile {
    private CrystalAttributes attributes = null;
    private LensColorType colorType = null;
    private int lensEffectTimeout = 0;
    private List<BlockPos> occupiedConnections = new LinkedList<BlockPos>();

    protected TileLens(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public TileLens() {
        super(TileEntityTypesAS.LENS);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.colorType != null) {
            if (this.field_145850_b.func_201670_d()) {
                this.playColorEffects();
            } else {
                this.doColorEffects();
            }
        }
    }

    public void transmissionTick() {
        this.lensEffectTimeout = 5;
    }

    private void doColorEffects() {
        if (this.getTicksExisted() % 4 != 0) {
            return;
        }
        if (!this.occupiedConnections.isEmpty()) {
            this.occupiedConnections.clear();
            this.markForUpdate();
        }
        if (this.lensEffectTimeout > 0) {
            --this.lensEffectTimeout;
        } else {
            return;
        }
        Vector3 thisVec = new Vector3(this).add(0.5, 0.5, 0.5);
        List<BlockPos> linked = this.getLinkedPositions();
        float str = 1.0f / (float)linked.size() * 0.7f;
        for (BlockPos linkedTo : linked) {
            Vector3 to = new Vector3((Vec3i)linkedTo).add(0.5, 0.5, 0.5);
            RaytraceAssist rta = new RaytraceAssist(thisVec, to).includeEndPoint();
            if (this.colorType.getType() == LensColorType.TargetType.BLOCK || this.colorType.getType() == LensColorType.TargetType.ANY) {
                boolean clear = rta.isClear(this.field_145850_b);
                if (!clear && rta.positionHit() != null) {
                    BlockPos posHit = rta.positionHit();
                    BlockState stateHit = this.field_145850_b.func_180495_p(posHit);
                    this.colorType.blockInBeam((IWorld)this.field_145850_b, posHit, stateHit, str);
                    this.occupiedConnections.add(posHit);
                } else {
                    this.occupiedConnections.add(linkedTo);
                }
            }
            if (this.colorType.getType() != LensColorType.TargetType.ENTITY && this.colorType.getType() != LensColorType.TargetType.ANY) continue;
            rta.setCollectEntities(0.5);
            rta.isClear(this.field_145850_b);
            List<Entity> found = rta.collectedEntities(this.field_145850_b);
            found.forEach(e -> this.colorType.entityInBeam(thisVec, to, (Entity)e, str));
            for (Entity entity : found) {
                this.colorType.entityInBeam(thisVec, to, entity, str);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void playColorEffects() {
        Vector3 at = new Vector3(this).add(0.5, 0.5, 0.5);
        Color lensColor = this.colorType.getColor();
        ((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(new Vector3(this).add(0.2, 0.2, 0.2).add((double)rand.nextFloat() * 0.6, (double)rand.nextFloat() * 0.6, (double)rand.nextFloat() * 0.6))).color(VFXColorFunction.constant(lensColor))).setScaleMultiplier(0.1f + rand.nextFloat() * 0.15f);
        if (this.getTicksExisted() % 40 == 0) {
            for (BlockPos connected : this.occupiedConnections) {
                Vector3 to = new Vector3((Vec3i)connected).add(0.5, 0.5, 0.5);
                ((FXLightbeam)EffectHelper.of(EffectTemplatesAS.LIGHTBEAM).spawn(at)).setup(to, 0.6, 0.6).color(VFXColorFunction.constant(lensColor));
            }
        }
    }

    public LensColorType setColorType(@Nullable LensColorType colorType) {
        if (this.getColorType() == colorType) {
            return colorType;
        }
        LensColorType prev = this.getColorType();
        this.colorType = colorType;
        this.markForUpdate();
        return prev;
    }

    @Nullable
    public LensColorType getColorType() {
        return this.colorType;
    }

    public Direction getPlacedAgainst() {
        BlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (!(state.func_177230_c() instanceof BlockLens)) {
            return Direction.DOWN;
        }
        return (Direction)state.func_177229_b(BlockLens.PLACED_AGAINST);
    }

    @Override
    public boolean isSingleLink() {
        return true;
    }

    @Override
    @Nullable
    public CrystalAttributes getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(@Nullable CrystalAttributes attributes) {
        this.attributes = attributes;
    }

    @Override
    public void readCustomNBT(CompoundNBT compound) {
        super.readCustomNBT(compound);
        this.attributes = CrystalAttributes.getCrystalAttributes(compound);
        this.colorType = compound.func_74764_b("colorType") ? LensColorType.byName(new ResourceLocation(compound.func_74779_i("colorType"))) : null;
        this.occupiedConnections = NBTHelper.readList(compound, "occupiedConnections", 10, nbt -> NBTHelper.readBlockPosFromNBT((CompoundNBT)nbt));
    }

    @Override
    public void writeCustomNBT(CompoundNBT compound) {
        super.writeCustomNBT(compound);
        if (this.attributes != null) {
            this.attributes.store(compound);
        }
        if (this.colorType != null) {
            compound.func_74778_a("colorType", this.colorType.getName().toString());
        }
        NBTHelper.writeList(compound, "occupiedConnections", this.occupiedConnections, pos -> NBTHelper.writeBlockPosToNBT(pos, new CompoundNBT()));
    }

    @Override
    @Nonnull
    public IPrismTransmissionNode provideTransmissionNode(BlockPos at) {
        return new StarlightTransmissionLens(at, this.attributes);
    }
}

