/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.tile;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.function.VFXColorFunction;
import hellfirepvp.astralsorcery.client.effect.handler.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.vfx.FXFacingParticle;
import hellfirepvp.astralsorcery.client.lib.EffectTemplatesAS;
import hellfirepvp.astralsorcery.common.auxiliary.link.LinkableTileEntity;
import hellfirepvp.astralsorcery.common.lib.TileEntityTypesAS;
import hellfirepvp.astralsorcery.common.tile.base.TileEntityTick;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TileRitualLink
extends TileEntityTick
implements LinkableTileEntity {
    private BlockPos linkedTo = null;

    public TileRitualLink() {
        super(TileEntityTypesAS.RITUAL_LINK);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.func_145831_w().func_201670_d()) {
            this.playClientEffects();
        } else if (this.linkedTo != null) {
            MiscUtils.executeWithChunk((IWorldReader)this.func_145831_w(), this.linkedTo, () -> {
                TileRitualLink link = MiscUtils.getTileAt((IBlockReader)this.func_145831_w(), this.linkedTo, TileRitualLink.class, true);
                if (link == null) {
                    this.linkedTo = null;
                    this.markForUpdate();
                }
            });
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void playClientEffects() {
        if (this.linkedTo != null) {
            if (this.ticksExisted % 4 == 0) {
                List<Vector3> positions = MiscUtils.getCirclePositions(new Vector3(this).add(0.5, 0.5, 0.5), Vector3.RotAxis.Y_AXIS, 0.4f - rand.nextFloat() * 0.1f, 10 + rand.nextInt(10));
                for (Vector3 v : positions) {
                    FXFacingParticle particle = (FXFacingParticle)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(v)).setScaleMultiplier(0.15f)).setMotion(new Vector3(0.0, (double)((float)(rand.nextBoolean() ? 1 : -1) * rand.nextFloat()) * 0.01, 0.0));
                    if (!rand.nextBoolean()) continue;
                    particle.color(VFXColorFunction.WHITE);
                }
            }
            ((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(new Vector3(this).add(0.5, 0.5, 0.5))).setScaleMultiplier(0.3f)).setMotion(new Vector3(0.0, (double)((float)(rand.nextBoolean() ? 1 : -1) * rand.nextFloat()) * 0.015, 0.0))).color(VFXColorFunction.random());
        }
    }

    @Nullable
    public BlockPos getLinkedTo() {
        return this.linkedTo;
    }

    @Override
    public void readCustomNBT(CompoundNBT compound) {
        super.readCustomNBT(compound);
        this.linkedTo = NBTHelper.readFromSubTag(compound, "posLink", NBTHelper::readBlockPosFromNBT);
    }

    @Override
    public void writeCustomNBT(CompoundNBT compound) {
        super.writeCustomNBT(compound);
        if (this.linkedTo != null) {
            NBTHelper.setAsSubTag(compound, "posLink", nbt -> NBTHelper.writeBlockPosToNBT(this.linkedTo, nbt));
        }
    }

    @Override
    public void onLinkCreate(PlayerEntity player, BlockPos other) {
        this.linkedTo = other;
        TileRitualLink otherLink = MiscUtils.getTileAt((IBlockReader)player.func_130014_f_(), other, TileRitualLink.class, true);
        if (otherLink != null) {
            otherLink.linkedTo = this.func_174877_v();
            otherLink.markForUpdate();
        }
        this.markForUpdate();
    }

    @Override
    public boolean tryLink(PlayerEntity player, BlockPos other) {
        TileRitualLink otherLink = MiscUtils.getTileAt((IBlockReader)player.func_130014_f_(), other, TileRitualLink.class, true);
        return otherLink != null && otherLink.linkedTo == null && !other.equals((Object)this.func_174877_v());
    }

    @Override
    public boolean tryUnlink(PlayerEntity player, BlockPos other) {
        TileRitualLink otherLink = MiscUtils.getTileAt((IBlockReader)player.func_130014_f_(), other, TileRitualLink.class, true);
        if (otherLink == null || otherLink.linkedTo == null) {
            return false;
        }
        if (otherLink.linkedTo.equals((Object)this.func_174877_v())) {
            this.linkedTo = null;
            otherLink.linkedTo = null;
            otherLink.markForUpdate();
            this.markForUpdate();
            return true;
        }
        return false;
    }

    @Override
    public List<BlockPos> getLinkedPositions() {
        return this.linkedTo != null ? Lists.newArrayList((Object[])new BlockPos[]{this.linkedTo}) : Lists.newArrayList();
    }
}

