/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.tile;

import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.function.VFXAlphaFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXColorFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXMotionController;
import hellfirepvp.astralsorcery.client.effect.handler.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.vfx.FXFacingParticle;
import hellfirepvp.astralsorcery.client.lib.EffectTemplatesAS;
import hellfirepvp.astralsorcery.common.constellation.world.DayTimeHelper;
import hellfirepvp.astralsorcery.common.item.ItemGlassLens;
import hellfirepvp.astralsorcery.common.lib.StructureTypesAS;
import hellfirepvp.astralsorcery.common.lib.TileEntityTypesAS;
import hellfirepvp.astralsorcery.common.structure.types.StructureType;
import hellfirepvp.astralsorcery.common.tile.TileAltar;
import hellfirepvp.astralsorcery.common.tile.base.TileEntitySynchronized;
import hellfirepvp.astralsorcery.common.tile.base.TileEntityTick;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.block.BlockDiscoverer;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.item.ItemUtils;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import hellfirepvp.astralsorcery.common.util.tile.TileInventory;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class TileSpectralRelay
extends TileEntityTick {
    private TileInventory inventory = new TileInventory((TileEntitySynchronized)this, () -> 1, new Direction[0]);
    private BlockPos altarPos;

    public TileSpectralRelay() {
        super(TileEntityTypesAS.SPECTRAL_RELAY);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.func_145831_w().func_201670_d()) {
            ItemStack in;
            if (!this.func_145831_w().func_175623_d(this.func_174877_v().func_177984_a()) && !(in = this.getInventory().getStackInSlot(0)).func_190926_b()) {
                ItemStack out = ItemUtils.copyStackWithSize(in, in.func_190916_E());
                ItemUtils.dropItem(this.func_145831_w(), this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p(), out);
                this.getInventory().setStackInSlot(0, ItemStack.field_190927_a);
            }
            if (this.hasMultiblock() && this.hasGlassLens() && this.altarPos != null) {
                MiscUtils.executeWithChunk((IWorldReader)this.func_145831_w(), this.altarPos, () -> {
                    TileAltar ta = MiscUtils.getTileAt((IBlockReader)this.func_145831_w(), this.altarPos, TileAltar.class, true);
                    if (ta == null) {
                        this.updateAltarLinkState();
                    } else {
                        this.provideStarlight(ta);
                    }
                });
            }
        } else if (this.hasMultiblock() && this.hasGlassLens()) {
            this.playStructureParticles();
            if (this.altarPos != null && this.doesSeeSky()) {
                this.playAltarParticles();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void playAltarParticles() {
        Vector3 pos = new Vector3(this).add(0.5, 0.35, 0.5);
        Vector3 target = new Vector3((Vec3i)this.altarPos).add(0.5, 0.5, 0.5);
        int maxAge = 30;
        maxAge = (int)((double)maxAge * Math.max(pos.distance(target) / 3.0, 1.0));
        EntityVisualFX vfx = (EntityVisualFX)((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(pos)).alpha(VFXAlphaFunction.proximity(target::clone, 2.0f).andThen(VFXAlphaFunction.FADE_OUT))).motion(VFXMotionController.target(target::clone, 0.08f))).setMotion(Vector3.random().normalize().multiply(0.1f + rand.nextFloat() * 0.05f))).setScaleMultiplier(0.15f + rand.nextFloat() * 0.05f)).setMaxAge(maxAge);
        if (rand.nextBoolean()) {
            vfx.color(VFXColorFunction.WHITE);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void playStructureParticles() {
        if (rand.nextBoolean()) {
            Vector3 pos = new Vector3(this).add(0.5, 0.0, 0.5);
            Vector3 offset = new Vector3(0, 0, 0);
            MiscUtils.applyRandomOffset(offset, rand, 1.25f);
            pos.add(offset.getX(), 0.0, offset.getZ());
            EntityVisualFX vfx = (EntityVisualFX)((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(pos)).alpha(VFXAlphaFunction.FADE_OUT)).setScaleMultiplier(0.15f + rand.nextFloat() * 0.1f)).setGravityStrength(-0.001f)).setMaxAge(30 + rand.nextInt(20));
            if (rand.nextBoolean()) {
                vfx.color(VFXColorFunction.WHITE);
            }
        }
    }

    private void provideStarlight(TileAltar ta) {
        if (this.doesSeeSky()) {
            double starlight = 0.5;
            starlight *= (double)Math.max((float)(this.func_174877_v().func_177956_o() - 40) / 100.0f, 0.0f);
            if ((starlight *= 0.3 + 0.7 * (double)DayTimeHelper.getCurrentDaytimeDistribution(this.func_145831_w())) > 1.0E-4) {
                ta.receiveStarlight(starlight);
            }
        }
    }

    @Override
    @Nullable
    public StructureType getRequiredStructureType() {
        if (this.hasGlassLens()) {
            return StructureTypesAS.PTYPE_SPECTRAL_RELAY;
        }
        return null;
    }

    @Override
    protected void notifyMultiblockStateUpdate(boolean hadMultiblockPrev, boolean hasMultiblockNow) {
        if (!hasMultiblockNow && this.altarPos != null) {
            this.altarPos = null;
        }
        if (hasMultiblockNow && this.hasGlassLens()) {
            this.updateAltarPos();
        }
    }

    public void updateAltarLinkState() {
        if (!this.hasGlassLens() || !this.hasMultiblock()) {
            this.altarPos = null;
            this.markForUpdate();
            return;
        }
        this.updateAltarPos();
    }

    private void updateAltarPos() {
        Set<BlockPos> altarPositions = BlockDiscoverer.searchForTileEntitiesAround(this.func_145831_w(), this.func_174877_v(), 16, tile -> tile instanceof TileAltar);
        BlockPos closestAltar = null;
        for (BlockPos other : altarPositions) {
            if (closestAltar != null && !(other.func_177951_i((Vec3i)this.func_174877_v()) < closestAltar.func_177951_i((Vec3i)this.func_174877_v()))) continue;
            closestAltar = other;
        }
        this.altarPos = closestAltar;
        this.markForUpdate();
    }

    public boolean hasGlassLens() {
        return this.getInventory().getStackInSlot(0).func_77973_b() instanceof ItemGlassLens;
    }

    @Nonnull
    public TileInventory getInventory() {
        return this.inventory;
    }

    @Override
    public void readCustomNBT(CompoundNBT compound) {
        super.readCustomNBT(compound);
        this.inventory = this.inventory.deserialize(compound.func_74775_l("inventory"));
        this.altarPos = compound.func_74764_b("altarPos") ? NBTHelper.readBlockPosFromNBT(compound.func_74775_l("altarPos")) : null;
    }

    @Override
    public void writeCustomNBT(CompoundNBT compound) {
        super.writeCustomNBT(compound);
        compound.func_218657_a("inventory", (INBT)this.inventory.serialize());
        if (this.altarPos != null) {
            compound.func_218657_a("altarPos", (INBT)NBTHelper.writeBlockPosToNBT(this.altarPos, new CompoundNBT()));
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (this.inventory.hasCapability(cap, side)) {
            return this.inventory.getCapability().cast();
        }
        return super.getCapability(cap, side);
    }
}

