/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.tile;

import hellfirepvp.astralsorcery.common.lib.TileEntityTypesAS;
import hellfirepvp.astralsorcery.common.tile.base.TileEntityTick;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;

public class TileTranslucentBlock
extends TileEntityTick {
    private BlockState fakedState = Blocks.field_150350_a.func_176223_P();
    private DyeColor overlayColor = DyeColor.WHITE;
    private UUID playerUUID = null;
    private Predicate<TileTranslucentBlock> persistenceFunction = tile -> true;

    public TileTranslucentBlock() {
        super(TileEntityTypesAS.TRANSLUCENT_BLOCK);
    }

    public boolean hasFastRenderer() {
        return true;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.persistenceFunction.test(this)) {
            this.func_145831_w().func_180501_a(this.func_174877_v(), this.getFakedState(), 11);
        }
    }

    @Nonnull
    public BlockState getFakedState() {
        return this.fakedState;
    }

    @Nonnull
    public DyeColor getOverlayColor() {
        return this.overlayColor;
    }

    @Nullable
    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public void setFakedState(BlockState fakedState) {
        this.fakedState = fakedState == null ? Blocks.field_150350_a.func_176223_P() : fakedState;
        this.markForUpdate();
    }

    public void setOverlayColor(DyeColor overlayColor) {
        this.overlayColor = overlayColor == null ? DyeColor.WHITE : overlayColor;
        this.markForUpdate();
    }

    public void setPlayerUUID(UUID playerUUID) {
        this.playerUUID = playerUUID;
        this.markForUpdate();
    }

    public void setPersistenceFunction(Predicate<TileTranslucentBlock> persistenceFunction) {
        if (persistenceFunction != null) {
            this.persistenceFunction = persistenceFunction;
        }
    }

    @Override
    public void readCustomNBT(CompoundNBT compound) {
        super.readCustomNBT(compound);
        this.fakedState = NBTHelper.getBlockStateFromTag(compound.func_74775_l("fakedState"), Blocks.field_150350_a.func_176223_P());
        this.overlayColor = DyeColor.func_196056_a((int)compound.func_74762_e("overlayColor"));
        this.playerUUID = compound.func_186855_b("playerUUID") ? compound.func_186857_a("playerUUID") : null;
    }

    @Override
    public void writeCustomNBT(CompoundNBT compound) {
        super.writeCustomNBT(compound);
        NBTHelper.setBlockState(compound, "fakedState", this.fakedState);
        compound.func_74768_a("overlayColor", this.overlayColor.func_196059_a());
        if (this.playerUUID != null) {
            compound.func_186854_a("playerUUID", this.playerUUID);
        }
    }
}

