/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.tile.base;

import hellfirepvp.astralsorcery.common.starlight.WorldNetworkHandler;
import hellfirepvp.astralsorcery.common.starlight.transmission.IPrismTransmissionNode;
import hellfirepvp.astralsorcery.common.starlight.transmission.TransmissionNetworkHelper;
import hellfirepvp.astralsorcery.common.tile.base.TileEntityTick;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;

public abstract class TileNetwork<T extends IPrismTransmissionNode>
extends TileEntityTick {
    protected static final Random rand = new Random();
    private boolean isNetworkInformed = false;
    private T cachedNetworkNode = null;
    private boolean needsNetworkSync = false;

    protected TileNetwork(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    @Nullable
    public T getNetworkNode() {
        if (this.cachedNetworkNode != null && !this.cachedNetworkNode.getLocationPos().equals((Object)this.func_174877_v())) {
            this.cachedNetworkNode = null;
        }
        if (this.cachedNetworkNode == null) {
            this.cachedNetworkNode = this.resolveNode();
        }
        return this.cachedNetworkNode;
    }

    @Nullable
    private T resolveNode() {
        IPrismTransmissionNode node = WorldNetworkHandler.getNetworkHandler(this.func_145831_w()).getTransmissionNode(this.func_174877_v());
        if (node == null) {
            return null;
        }
        return (T)node;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.func_145831_w().func_201670_d()) {
            if (!this.isNetworkInformed) {
                if (!TransmissionNetworkHelper.isTileInNetwork(this)) {
                    TransmissionNetworkHelper.informNetworkTilePlacement(this);
                }
                this.isNetworkInformed = true;
            }
            if (this.needsNetworkSync) {
                this.doNetworkSync();
            }
        }
    }

    protected void doNetworkSync() {
        TileNetwork networkNode = this.getNetworkNode();
        if (networkNode != null && networkNode.updateFromTileEntity((TileNetwork)this)) {
            this.needsNetworkSync = false;
            this.markForUpdate();
            this.preventNetworkSync();
        }
    }

    @Override
    public void markForUpdate() {
        super.markForUpdate();
        this.needsNetworkSync = true;
    }

    protected void preventNetworkSync() {
        this.needsNetworkSync = false;
    }

    public void onBreak() {
        if (this.func_145831_w().func_201670_d()) {
            return;
        }
        TransmissionNetworkHelper.informNetworkTileRemoval(this);
        this.isNetworkInformed = false;
    }

    @Override
    public void writeSaveNBT(CompoundNBT compound) {
        super.writeSaveNBT(compound);
        compound.func_74757_a("needsNetworkSync", this.needsNetworkSync);
    }

    @Override
    public void readSaveNBT(CompoundNBT compound) {
        super.readSaveNBT(compound);
        this.needsNetworkSync = compound.func_74767_n("needsNetworkSync");
    }
}

