/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.tile.network;

import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.IMinorConstellation;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.constellation.SkyHandler;
import hellfirepvp.astralsorcery.common.constellation.effect.ConstellationEffect;
import hellfirepvp.astralsorcery.common.constellation.effect.ConstellationEffectProperties;
import hellfirepvp.astralsorcery.common.constellation.effect.ConstellationEffectRegistry;
import hellfirepvp.astralsorcery.common.constellation.effect.ConstellationEffectStatus;
import hellfirepvp.astralsorcery.common.constellation.world.DayTimeHelper;
import hellfirepvp.astralsorcery.common.constellation.world.WorldContext;
import hellfirepvp.astralsorcery.common.crystal.CrystalAttributes;
import hellfirepvp.astralsorcery.common.crystal.CrystalCalculations;
import hellfirepvp.astralsorcery.common.starlight.WorldNetworkHandler;
import hellfirepvp.astralsorcery.common.starlight.transmission.IPrismTransmissionNode;
import hellfirepvp.astralsorcery.common.starlight.transmission.NodeConnection;
import hellfirepvp.astralsorcery.common.starlight.transmission.base.SimpleTransmissionReceiver;
import hellfirepvp.astralsorcery.common.starlight.transmission.registry.TransmissionProvider;
import hellfirepvp.astralsorcery.common.tile.TileRitualPedestal;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.RaytraceAssist;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import hellfirepvp.astralsorcery.common.util.world.SkyCollectionHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.LogicalSide;

public class StarlightReceiverRitualPedestal
extends SimpleTransmissionReceiver {
    private static final Random rand = new Random();
    private Map<BlockPos, Boolean> offsetMirrors = new HashMap<BlockPos, Boolean>();
    private List<CrystalAttributes> fracturedCrystalStats = new ArrayList<CrystalAttributes>();
    private boolean doesSeeSky = false;
    private boolean hasMultiblock = false;
    private IWeakConstellation channelingType = null;
    private IMinorConstellation channelingTrait = null;
    private CrystalAttributes attributes = null;
    private BlockPos ritualLinkPos = null;
    private int ticksExisted = 0;
    private ConstellationEffect effect = null;
    private double collectedStarlight = 0.0;
    private boolean needsTileSync = false;
    private float noiseDistribution = -1.0f;

    public StarlightReceiverRitualPedestal(BlockPos thisPos) {
        super(thisPos);
    }

    @Override
    public void update(World world) {
        ++this.ticksExisted;
        if (this.needsTileSync && this.syncData(world)) {
            this.needsTileSync = false;
            this.markDirty(world);
        }
        if (!this.hasMultiblock || this.channelingType == null || this.attributes == null) {
            return;
        }
        if (this.ticksExisted % 20 == 0) {
            this.validateMirrorPositions(world);
        }
        if (this.doesSeeSky) {
            this.collectStarlight(world);
        }
        if (this.effect != null && this.collectedStarlight > 0.0) {
            this.doRitualEffect(world);
        }
    }

    private void doRitualEffect(World world) {
        ConstellationEffectProperties properties = this.effect.createProperties(this.getMirrorCount());
        if (this.channelingTrait != null) {
            properties.modify(this.channelingTrait);
        }
        properties.multiplySize(CrystalCalculations.getRitualEffectRangeFactor(this, this.attributes));
        double maxDrain = 15.0;
        maxDrain *= CrystalCalculations.getRitualCostReductionFactor(this, this.attributes);
        this.collectedStarlight *= properties.getPotency();
        int executeTimes = MathHelper.func_76128_c((double)(this.collectedStarlight / (maxDrain /= (double)Math.max(1.0f, (float)(this.getMirrorCount() - 1) * 0.33f))));
        int nonFracturingExecutions = MathHelper.func_76128_c((double)(Math.max(1.0, Math.sqrt(CrystalCalculations.getRitualEffectCapacityFactor(this, this.attributes)) * 3.0) * properties.getFracturationLowerBoundaryMultiplier()));
        double fractureChancePer = (double)CrystalCalculations.getRitualCrystalFractureChance(executeTimes, nonFracturingExecutions) * properties.getFracturationRate();
        int fracturingTicks = Math.max(1, executeTimes - nonFracturingExecutions);
        BlockPos to = this.getLocationPos();
        if (this.ritualLinkPos != null) {
            to = this.ritualLinkPos;
        }
        if (this.effect instanceof ConstellationEffectStatus && this.collectedStarlight > 0.0) {
            this.collectedStarlight = 0.0;
            if (((Boolean)this.effect.getConfig().enabled.get()).booleanValue() && ((ConstellationEffectStatus)((Object)this.effect)).runStatusEffect(world, to, this.getMirrorCount(), properties, this.channelingTrait)) {
                for (int i = 0; i < fracturingTicks; ++i) {
                    if (!((double)rand.nextFloat() < fractureChancePer * properties.getEffectAmplifier())) continue;
                    this.fractureCrystal(world);
                }
                this.markDirty(world);
            }
            return;
        }
        executeTimes = MathHelper.func_76128_c((double)((double)executeTimes * properties.getEffectAmplifier()));
        for (int i = 0; i < executeTimes; ++i) {
            boolean didEffectExecute;
            this.collectedStarlight = this.collectedStarlight >= maxDrain ? (this.collectedStarlight -= maxDrain) : 0.0;
            if (!((Boolean)this.effect.getConfig().enabled.get()).booleanValue() || !(didEffectExecute = this.effect.needsChunkToBeLoaded() ? MiscUtils.executeWithChunk((IWorldReader)world, to, to, pos -> this.effect.playEffect(world, (BlockPos)pos, properties, this.channelingTrait), false).booleanValue() : this.effect.playEffect(world, to, properties, this.channelingTrait))) continue;
            if ((double)rand.nextFloat() < fractureChancePer * properties.getEffectAmplifier() / (double)fracturingTicks) {
                this.fractureCrystal(world);
            }
            this.markDirty(world);
        }
    }

    private void fractureCrystal(World world) {
        if (this.attributes != null && !this.attributes.isEmpty()) {
            CrystalAttributes.Builder fracBuilder = CrystalAttributes.Builder.newBuilder(true);
            for (int i = 0; i < 1 + rand.nextInt(Math.min(3, this.attributes.getTotalTierLevel())); ++i) {
                CrystalAttributes.Attribute attr = MiscUtils.getWeightedRandomEntry(this.attributes.getCrystalAttributes(), rand, CrystalAttributes.Attribute::getTier);
                if (attr == null) continue;
                fracBuilder.addProperty(attr.getProperty(), 1);
                this.attributes = this.attributes.modifyLevel(attr.getProperty(), -1);
            }
            this.fracturedCrystalStats.add(fracBuilder.build());
            if (this.attributes.isEmpty()) {
                this.attributes = null;
            }
            this.needsTileSync = true;
            this.markDirty(world);
        }
    }

    private void collectStarlight(World world) {
        WorldContext ctx = SkyHandler.getContext(world, LogicalSide.SERVER);
        if (ctx == null) {
            return;
        }
        double collected = 0.25 + 0.75 * (double)DayTimeHelper.getCurrentDaytimeDistribution(world);
        if (this.noiseDistribution == -1.0f) {
            this.noiseDistribution = SkyCollectionHelper.getSkyNoiseDistribution(world, this.getLocationPos());
        }
        collected *= (double)CrystalCalculations.getCrystalCollectionRate(this.attributes);
        collected *= (double)(0.2f + 0.8f * ctx.getDistributionHandler().getDistribution(this.channelingType));
        this.collectedStarlight += (collected *= (double)(1.0f + 0.5f * this.noiseDistribution)) / 2.0;
    }

    @Override
    public void onStarlightReceive(World world, IWeakConstellation type, double amount) {
        if (this.channelingType != null && this.hasMultiblock && this.channelingType.equals(type)) {
            this.collectedStarlight += amount;
            this.findNextMirror(world);
        }
    }

    private boolean syncData(World world) {
        TileRitualPedestal trp = this.getTileAtPos(world, TileRitualPedestal.class);
        if (trp != null) {
            trp.setReceiverData(this.effect != null, this.offsetMirrors, this.attributes, this.fracturedCrystalStats);
            this.fracturedCrystalStats.clear();
            return true;
        }
        return false;
    }

    @Override
    public <T extends TileEntity> boolean updateFromTileEntity(T tile) {
        if (!(tile instanceof TileRitualPedestal)) {
            return super.updateFromTileEntity(tile);
        }
        TileRitualPedestal trp = (TileRitualPedestal)tile;
        if (this.channelingType != trp.getRitualConstellation() || this.attributes != null && trp.getAttributes() == null || this.hasMultiblock != trp.hasMultiblock()) {
            this.effect = null;
            this.offsetMirrors.clear();
            if (trp.isWorking() || !trp.getMirrors().isEmpty()) {
                this.needsTileSync = true;
            }
        }
        this.doesSeeSky = trp.doesSeeSky();
        this.hasMultiblock = trp.hasMultiblock();
        this.channelingType = trp.getRitualConstellation();
        this.channelingTrait = trp.getRitualTrait();
        this.attributes = trp.getAttributes();
        this.ritualLinkPos = trp.getRitualLinkTo();
        if (this.channelingType != null && this.attributes != null && this.hasMultiblock && this.effect == null) {
            this.effect = ConstellationEffectRegistry.createInstance(this, this.channelingType);
            this.needsTileSync = true;
        }
        if (!this.hasMultiblock || this.effect == null) {
            this.collectedStarlight = 0.0;
        }
        this.markDirty(trp.func_145831_w());
        return super.updateFromTileEntity(tile);
    }

    private void findNextMirror(World world) {
        if (this.offsetMirrors.size() >= 5 || this.effect == null || this.channelingType == null) {
            return;
        }
        long seed = 3451968351053166105L;
        seed |= this.getLocationPos().func_218275_a() * 31L;
        Random r = new Random(seed |= (long)(this.channelingType.getConstellationName().func_150254_d().hashCode() * 31));
        for (int i = 0; i < this.getMirrorCount(); ++i) {
            r.nextInt(TileRitualPedestal.RITUAL_CIRCLE_OFFSETS.size());
        }
        BlockPos offset = null;
        int c = 100;
        block1: while (offset == null && c > 0) {
            --c;
            BlockPos test = MiscUtils.getRandomEntry(TileRitualPedestal.RITUAL_CIRCLE_OFFSETS, r).func_177971_a((Vec3i)TileRitualPedestal.RITUAL_LENS_OFFSET);
            RaytraceAssist ray = new RaytraceAssist(this.getLocationPos(), this.getLocationPos().func_177971_a((Vec3i)test));
            Vector3 from = new Vector3(0.5, 0.7, 0.5);
            Vector3 newDir = new Vector3((Vec3i)test).add(0.5, 0.5, 0.5).subtract(from);
            for (BlockPos p : this.offsetMirrors.keySet()) {
                Vector3 toDir = new Vector3((Vec3i)p).add(0.5, 0.5, 0.5).subtract(from);
                if (!(Math.toDegrees(toDir.angle(newDir)) <= 30.0) && !(test.func_177951_i((Vec3i)p) <= 3.0)) continue;
                continue block1;
            }
            if (!ray.isClear(world)) continue;
            offset = test;
        }
        if (offset != null) {
            this.offsetMirrors.put(offset, false);
            this.markDirty(world);
            this.needsTileSync = true;
        }
    }

    private void validateMirrorPositions(World world) {
        WorldNetworkHandler handle = WorldNetworkHandler.getNetworkHandler(world);
        List<BlockPos> srcLinkingToThis = this.getSources();
        boolean needsUpdate = false;
        for (BlockPos pos : new ArrayList<BlockPos>(this.offsetMirrors.keySet())) {
            BlockPos actualPos = this.getLocationPos().func_177971_a((Vec3i)pos);
            boolean existingFlag = this.offsetMirrors.get(pos);
            if (!srcLinkingToThis.contains(actualPos)) {
                this.offsetMirrors.put(pos, false);
                if (!existingFlag) continue;
                needsUpdate = true;
                continue;
            }
            IPrismTransmissionNode other = handle.getTransmissionNode(actualPos);
            if (other == null) continue;
            boolean foundLink = false;
            for (NodeConnection<IPrismTransmissionNode> n : other.queryNext(handle)) {
                if (!n.getTo().equals((Object)this.getLocationPos())) continue;
                boolean connect = n.canConnect();
                this.offsetMirrors.put(pos, connect);
                if (connect != existingFlag) {
                    needsUpdate = true;
                }
                foundLink = true;
                break;
            }
            if (foundLink) continue;
            this.offsetMirrors.put(pos, false);
            if (!existingFlag) continue;
            needsUpdate = true;
        }
        if (needsUpdate) {
            this.needsTileSync = true;
        }
    }

    private int getMirrorCount() {
        return (int)this.offsetMirrors.values().stream().filter(b -> b).count();
    }

    @Nullable
    public IWeakConstellation getChannelingType() {
        return this.channelingType;
    }

    @Nullable
    public IMinorConstellation getChannelingTrait() {
        return this.channelingTrait;
    }

    @Override
    public boolean needsUpdate() {
        return true;
    }

    @Override
    public TransmissionProvider getProvider() {
        return new Provider();
    }

    @Override
    public void readFromNBT(CompoundNBT compound) {
        super.readFromNBT(compound);
        this.needsTileSync = compound.func_74767_n("needsTileSync");
        this.doesSeeSky = compound.func_74767_n("doesSeeSky");
        this.hasMultiblock = compound.func_74767_n("hasMultiblock");
        this.ticksExisted = compound.func_74762_e("ticksExisted");
        this.collectedStarlight = compound.func_74769_h("collectedStarlight");
        IConstellation channeling = IConstellation.readFromNBT(compound, "channelingType");
        this.channelingType = channeling instanceof IWeakConstellation ? (IWeakConstellation)channeling : null;
        IConstellation trait = IConstellation.readFromNBT(compound, "channelingTrait");
        this.channelingTrait = trait instanceof IMinorConstellation ? (IMinorConstellation)trait : null;
        this.attributes = CrystalAttributes.getCrystalAttributes(compound);
        this.ritualLinkPos = compound.func_74764_b("ritualLinkPos") ? NBTHelper.readBlockPosFromNBT(compound.func_74775_l("ritualLinkPos")) : null;
        this.fracturedCrystalStats = NBTHelper.readList(compound, "fracturedCrystalStats", 10, CrystalAttributes::deserialize);
        this.offsetMirrors.clear();
        ListNBT tagList = compound.func_150295_c("mirrors", 10);
        for (INBT nbt : tagList) {
            CompoundNBT tag = (CompoundNBT)nbt;
            this.offsetMirrors.put(NBTHelper.readBlockPosFromNBT(tag), tag.func_74767_n("connect"));
        }
        if (this.channelingType != null) {
            this.effect = ConstellationEffectRegistry.createInstance(this, this.channelingType);
            if (this.effect != null && compound.func_74764_b("effect")) {
                this.effect.readFromNBT(compound.func_74775_l("effect"));
            }
        }
    }

    @Override
    public void writeToNBT(CompoundNBT compound) {
        super.writeToNBT(compound);
        compound.func_74757_a("needsTileSync", this.needsTileSync);
        compound.func_74757_a("doesSeeSky", this.doesSeeSky);
        compound.func_74757_a("hasMultiblock", this.hasMultiblock);
        compound.func_74768_a("ticksExisted", this.ticksExisted);
        compound.func_74780_a("collectedStarlight", this.collectedStarlight);
        if (this.channelingType != null) {
            this.channelingType.writeToNBT(compound, "channelingType");
        }
        if (this.channelingTrait != null) {
            this.channelingTrait.writeToNBT(compound, "channelingTrait");
        }
        if (this.attributes != null) {
            this.attributes.store(compound);
        }
        if (this.ritualLinkPos != null) {
            compound.func_218657_a("ritualLinkPos", (INBT)NBTHelper.writeBlockPosToNBT(this.ritualLinkPos, new CompoundNBT()));
        }
        NBTHelper.writeList(compound, "fracturedCrystalStats", this.fracturedCrystalStats, CrystalAttributes::serialize);
        ListNBT listPositions = new ListNBT();
        for (Map.Entry<BlockPos, Boolean> posEntry : this.offsetMirrors.entrySet()) {
            CompoundNBT cmp = new CompoundNBT();
            NBTHelper.writeBlockPosToNBT(posEntry.getKey(), cmp);
            cmp.func_74757_a("connect", posEntry.getValue().booleanValue());
            listPositions.add((Object)cmp);
        }
        compound.func_218657_a("mirrors", (INBT)listPositions);
        if (this.channelingType != null && this.effect != null) {
            NBTHelper.setAsSubTag(compound, "effect", this.effect::writeToNBT);
        }
    }

    public static class Provider
    extends TransmissionProvider {
        @Override
        public IPrismTransmissionNode get() {
            return new StarlightReceiverRitualPedestal(null);
        }
    }
}

