/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util;

import hellfirepvp.astralsorcery.common.constellation.SkyHandler;
import hellfirepvp.astralsorcery.common.constellation.mantle.effect.MantleEffectOctans;
import hellfirepvp.astralsorcery.common.constellation.mantle.effect.MantleEffectVicio;
import hellfirepvp.astralsorcery.common.constellation.world.WorldContext;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.enchantment.dynamic.DynamicEnchantmentHelper;
import hellfirepvp.astralsorcery.common.event.AttributeEvent;
import hellfirepvp.astralsorcery.common.event.CooldownSetEvent;
import hellfirepvp.astralsorcery.common.event.PotionApplyEvent;
import hellfirepvp.astralsorcery.common.perk.DynamicModifierHelper;
import hellfirepvp.astralsorcery.common.perk.node.key.KeyEntityReach;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AbstractAttributeMap;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.ListNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.CooldownTracker;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ServerCooldownTracker;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.LogicalSide;

public class ASMHookEndpoint {
    public static Map<Enchantment, Integer> applyNewEnchantmentLevels(Map<Enchantment, Integer> enchantments, ItemStack stack) {
        return DynamicEnchantmentHelper.addNewLevels(enchantments, stack);
    }

    public static int getNewEnchantmentLevel(int current, Enchantment enchantment, ItemStack stack) {
        return DynamicEnchantmentHelper.getNewEnchantmentLevel(current, enchantment, stack, null);
    }

    public static ListNBT addNewEnchantmentLevelsTag(ListNBT list, ItemStack stack) {
        return DynamicEnchantmentHelper.modifyEnchantmentTags(list, stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addTooltipPreEnchantments(ItemStack stack, List<ITextComponent> tooltip) {
        ArrayList<ITextComponent> addition = new ArrayList<ITextComponent>();
        try {
            Map enchantments;
            DynamicModifierHelper.addModifierTooltip(stack, addition);
            if (!stack.func_77942_o() && !(enchantments = EnchantmentHelper.func_82781_a((ItemStack)stack)).isEmpty()) {
                for (Enchantment e : enchantments.keySet()) {
                    addition.add(e.func_200305_d(((Integer)enchantments.get(e)).intValue()));
                }
            }
        }
        catch (Exception exc) {
            addition.clear();
            tooltip.add(new TranslationTextComponent("astralsorcery.misc.tooltipError", new Object[0]).func_211708_a(TextFormatting.GRAY));
        }
        tooltip.addAll(addition);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static float overrideSunBrightnessClient(float prevBrightness, World world) {
        WorldContext ctx = SkyHandler.getContext(world, LogicalSide.CLIENT);
        if (ctx != null && ctx.getCelestialHandler().isSolarEclipseActive()) {
            float perc = ctx.getCelestialHandler().getSolarEclipsePercent();
            perc = 0.05f + perc * 0.95f;
            return prevBrightness * perc;
        }
        return prevBrightness;
    }

    public static int overrideSunBrightnessServer(int prevSkyLight, World world) {
        WorldContext ctx = SkyHandler.getContext(world);
        if (ctx != null && ctx.getCelestialHandler().isSolarEclipseActive()) {
            return 11 - Math.round(ctx.getCelestialHandler().getSolarEclipsePercent() * 11.0f);
        }
        return prevSkyLight;
    }

    public static ItemStack transformElytraItem(ItemStack elytraStack, LivingEntity wearingEntity) {
        if (!elytraStack.func_190926_b() && wearingEntity instanceof PlayerEntity && MantleEffectVicio.isUsableElytra(elytraStack, (PlayerEntity)wearingEntity)) {
            elytraStack = new ItemStack((IItemProvider)Items.field_185160_cR);
        }
        return elytraStack;
    }

    public static void fireNewPotionEffectEvent(LivingEntity entity, EffectInstance newEffect) {
        MinecraftForge.EVENT_BUS.post((Event)new PotionApplyEvent.New(entity, newEffect));
    }

    public static void fireChangedPotionEffectEvent(LivingEntity entity, EffectInstance previous, EffectInstance newCombinedEffect) {
        MinecraftForge.EVENT_BUS.post((Event)new PotionApplyEvent.Changed(entity, previous, newCombinedEffect));
    }

    public static int fireCooldownEvent(CooldownTracker tracker, Item item, int ticks) {
        if (tracker instanceof ServerCooldownTracker) {
            CooldownSetEvent event = new CooldownSetEvent((PlayerEntity)((ServerCooldownTracker)tracker).field_185149_a, item, ticks);
            MinecraftForge.EVENT_BUS.post((Event)event);
            ticks = Math.max(event.getResultCooldown(), 1);
        }
        return ticks;
    }

    public static float getLivingEntityWaterSlowDown(float slowDownIn, LivingEntity entity) {
        if (!entity.func_184582_a(EquipmentSlotType.CHEST).func_190926_b() && MantleEffectOctans.shouldPreventWaterSlowdown(entity.func_184582_a(EquipmentSlotType.CHEST), entity)) {
            return 0.92f;
        }
        return slowDownIn;
    }

    public static AbstractAttributeMap markPlayer(AbstractAttributeMap map, LivingEntity entity) {
        AttributeEvent.setEntity(map, entity);
        return map;
    }

    public static double postProcessVanilla(double value, ModifiableAttributeInstance attributeInstance) {
        return AttributeEvent.postProcessVanilla(value, attributeInstance);
    }

    public static double getOverriddenSeenEntityReachMaximum(PlayerEntity player) {
        PlayerProgress prog = ResearchHelper.getProgress(player, player.func_130014_f_().func_201670_d() ? LogicalSide.CLIENT : LogicalSide.SERVER);
        if (prog.isValid() && prog.hasPerkEffect(perk -> perk instanceof KeyEntityReach)) {
            return 9.99999999E8;
        }
        return 36.0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static double getOverriddenCreativeEntityReach(double blockReach) {
        PlayerProgress prog = ResearchHelper.getProgress((PlayerEntity)Minecraft.func_71410_x().field_71439_g, LogicalSide.CLIENT);
        if (prog.isValid() && prog.hasPerkEffect(perk -> perk instanceof KeyEntityReach)) {
            return blockReach;
        }
        return 6.0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean doesOverrideDistanceRuling() {
        PlayerProgress prog = ResearchHelper.getProgress((PlayerEntity)Minecraft.func_71410_x().field_71439_g, LogicalSide.CLIENT);
        return !prog.isValid() || !prog.hasPerkEffect(perk -> perk instanceof KeyEntityReach);
    }
}

