/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util;

import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.block.BlockPredicate;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.object.ObjectReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class RaytraceAssist {
    private static final List<BlockPredicate> passable = new ArrayList<BlockPredicate>();
    private static final double STEP_WIDTH = 0.1;
    private static final Vector3 CENTRALIZE = new Vector3(0.5, 0.5, 0.5);
    private final Vector3 start;
    private final Vector3 target;
    private final BlockPos startPos;
    private final BlockPos targetPos;
    private boolean collectEntities = false;
    private Set<Integer> collected = new HashSet<Integer>();
    private AxisAlignedBB collectBox = null;
    private boolean includeEnd = false;
    private boolean hitBlocks = true;
    private boolean hitFluids = true;
    private double stepWidth = 0.1;
    private BlockPos posHit = null;

    public RaytraceAssist(BlockPos start, BlockPos target) {
        this(new Vector3((Vec3i)start).add(CENTRALIZE), new Vector3((Vec3i)target).add(CENTRALIZE));
    }

    public RaytraceAssist(Vector3 start, Vector3 target) {
        this.start = start.clone();
        this.target = target.clone();
        this.startPos = this.start.toBlockPos();
        this.targetPos = this.target.toBlockPos();
    }

    public RaytraceAssist includeEndPoint() {
        this.includeEnd = true;
        return this;
    }

    public RaytraceAssist hitBlock(boolean hitBlocks) {
        this.hitBlocks = hitBlocks;
        return this;
    }

    public RaytraceAssist hitFluidsBeforeBlocks(boolean hitFluids) {
        this.hitFluids = hitFluids;
        return this;
    }

    public RaytraceAssist stepWith(double stepWidth) {
        this.stepWidth = stepWidth;
        return this;
    }

    public void setCollectEntities(double additionalCollectRadius) {
        this.collectEntities = true;
        this.collectBox = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        this.collectBox = this.collectBox.func_186662_g(additionalCollectRadius);
    }

    public boolean isClear(World world) {
        return this.forEachBlockPos(at -> {
            if (this.collectEntities) {
                List entities = world.func_217357_a(Entity.class, this.collectBox.func_186670_a(at));
                for (Entity b : entities) {
                    this.collected.add(b.func_145782_y());
                }
            }
            return MiscUtils.executeWithChunk((IWorldReader)world, at, () -> {
                if (!this.isStartEnd((BlockPos)at) && !world.func_175623_d(at)) {
                    if (this.hitFluids && !world.func_204610_c(at).func_206888_e()) {
                        this.posHit = at;
                        return false;
                    }
                    if ((this.hitBlocks || this.hitFluids) && !this.isAllowed(world, (BlockPos)at, world.func_180495_p(at))) {
                        this.posHit = at;
                        return false;
                    }
                }
                return true;
            }, false);
        });
    }

    public boolean forEachStep(Predicate<Vector3> raystepFn) {
        Vector3 aim = this.start.vectorFromHereTo(this.target);
        Vector3 stepAim = aim.clone().normalize().multiply(this.stepWidth);
        double distance = aim.length();
        Vector3 prevVec = this.start.clone();
        for (double distancePart = this.stepWidth; distancePart <= distance; distancePart += this.stepWidth) {
            Vector3 stepVec = prevVec.clone().add(stepAim);
            if (!raystepFn.test(stepVec.clone())) {
                return false;
            }
            prevVec = stepVec;
        }
        return true;
    }

    public boolean forEachBlockPos(Predicate<BlockPos> raystepFn) {
        ObjectReference lastPos = new ObjectReference();
        return this.forEachStep(vec -> {
            BlockPos at = vec.toBlockPos();
            if (lastPos.get() == null || !((BlockPos)lastPos.get()).equals((Object)at)) {
                lastPos.set(at);
                return raystepFn.test(at);
            }
            return true;
        });
    }

    public BlockPos positionHit() {
        return this.posHit;
    }

    public List<Entity> collectedEntities(World world) {
        LinkedList<Entity> entities = new LinkedList<Entity>();
        for (Integer id : this.collected) {
            Entity e = world.func_73045_a(id.intValue());
            if (e == null || !e.func_70089_S()) continue;
            entities.add(e);
        }
        return entities;
    }

    private boolean isAllowed(World world, BlockPos at, BlockState state) {
        return MiscUtils.contains(passable, predicate -> predicate.test(world, at, state));
    }

    private boolean isStartEnd(BlockPos hit) {
        return hit.equals((Object)this.startPos) || !this.includeEnd && hit.equals((Object)this.targetPos);
    }

    public static void addPassable(BlockPredicate predicate) {
        passable.add(predicate);
    }

    static {
        RaytraceAssist.addPassable((world, pos, state) -> state.func_204520_s().func_206888_e() && state.func_185904_a().equals(Material.field_151592_s));
    }
}

