/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util.block;

import com.google.common.base.Splitter;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.block.AirBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.IProperty;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockStateHelper {
    private static final Splitter PROP_SPLITTER = Splitter.on((char)',');
    private static final Splitter PROP_ELEMENT_SPLITTER = Splitter.on((char)'=');

    @Nonnull
    public static String serialize(@Nonnull Block block) {
        return block.getRegistryName().toString();
    }

    @Nonnull
    public static <V extends Comparable<V>> String serialize(@Nonnull BlockState state) {
        StringBuilder name = new StringBuilder(state.func_177230_c().getRegistryName().toString());
        ArrayList props = new ArrayList(state.func_206869_a());
        if (!props.isEmpty()) {
            name.append('[');
            for (int i = 0; i < props.size(); ++i) {
                IProperty prop = (IProperty)props.get(i);
                if (i > 0) {
                    name.append(',');
                }
                name.append(prop.func_177701_a());
                name.append('=');
                name.append(prop.func_177702_a(state.func_177229_b(prop)));
            }
            name.append(']');
        }
        return name.toString();
    }

    @Nonnull
    public static <V extends Comparable<V>> JsonObject serializeObject(BlockState state, boolean serializeProperties) {
        JsonObject object = new JsonObject();
        object.addProperty("block", state.func_177230_c().getRegistryName().toString());
        if (serializeProperties && !state.func_206869_a().isEmpty()) {
            JsonArray properties = new JsonArray();
            Iterator iterator = state.func_206869_a().iterator();
            while (iterator.hasNext()) {
                IProperty property;
                IProperty prop = property = (IProperty)iterator.next();
                JsonObject objProperty = new JsonObject();
                objProperty.addProperty("name", prop.func_177701_a());
                objProperty.addProperty("value", prop.func_177702_a(state.func_177229_b(prop)));
                properties.add((JsonElement)objProperty);
            }
            object.add("properties", (JsonElement)properties);
        }
        return object;
    }

    @Nonnull
    public static Block deserializeBlock(@Nonnull String serialized) {
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(serialized));
        return block == null ? Blocks.field_150350_a : block;
    }

    @Nonnull
    public static <T extends Comparable<T>> BlockState deserialize(@Nonnull String serialized) {
        int propIndex = serialized.indexOf(91);
        boolean hasProperties = BlockStateHelper.isMissingStateInformation(serialized);
        ResourceLocation key = hasProperties ? new ResourceLocation(serialized.substring(0, propIndex).toLowerCase()) : new ResourceLocation(serialized.toLowerCase());
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(key);
        BlockState state = block.func_176223_P();
        if (!block.equals(Blocks.field_150350_a) && hasProperties) {
            List strProps = PROP_SPLITTER.splitToList((CharSequence)serialized.substring(propIndex, serialized.length() - 1));
            for (String serializedProperty : strProps) {
                Optional value;
                List propertyValues = PROP_ELEMENT_SPLITTER.splitToList((CharSequence)serializedProperty);
                String name = (String)propertyValues.get(0);
                String strValue = (String)propertyValues.get(1);
                IProperty property = MiscUtils.iterativeSearch(state.func_206869_a(), prop -> prop.func_177701_a().equalsIgnoreCase(name));
                if (property == null || !(value = property.func_185929_b(strValue)).isPresent()) continue;
                state = (BlockState)state.func_206870_a(property, (Comparable)value.get());
            }
        }
        return state;
    }

    @Nonnull
    public static <T extends Comparable<T>> BlockState deserializeObject(JsonObject object) {
        String key = JSONUtils.func_151200_h((JsonObject)object, (String)"block");
        Block b = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(key));
        if (b == null || b instanceof AirBlock) {
            return Blocks.field_150350_a.func_176223_P();
        }
        BlockState state = b.func_176223_P();
        if (BlockStateHelper.isMissingStateInformation(object)) {
            return state;
        }
        if (JSONUtils.func_151204_g((JsonObject)object, (String)"properties")) {
            JsonArray properties = JSONUtils.func_151214_t((JsonObject)object, (String)"properties");
            for (JsonElement elemProperty : properties) {
                String propValue;
                Optional value;
                JsonObject objProperty = JSONUtils.func_151210_l((JsonElement)elemProperty, (String)"properties[?]");
                String propName = JSONUtils.func_151200_h((JsonObject)objProperty, (String)"name");
                IProperty property = MiscUtils.iterativeSearch(state.func_206869_a(), prop -> prop.func_177701_a().equalsIgnoreCase(propName));
                if (property == null || !(value = property.func_185929_b(propValue = JSONUtils.func_151200_h((JsonObject)objProperty, (String)"value"))).isPresent()) continue;
                state = (BlockState)state.func_206870_a(property, (Comparable)value.get());
            }
        }
        return state;
    }

    public static boolean isMissingStateInformation(@Nonnull JsonObject serialized) {
        return serialized.has("properties");
    }

    public static boolean isMissingStateInformation(@Nonnull String serialized) {
        return serialized.indexOf(91) == -1;
    }
}

