/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util.block;

import hellfirepvp.astralsorcery.common.data.config.base.ConfiguredBlockStateList;
import hellfirepvp.astralsorcery.common.util.block.BlockPredicate;
import hellfirepvp.astralsorcery.common.util.block.SimpleBlockPredicate;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeConfigSpec;

public class BlockStateList
implements BlockPredicate,
Predicate<BlockState> {
    private List<SimpleBlockPredicate> configuredMatches = new ArrayList<SimpleBlockPredicate>();

    public BlockStateList add(BlockState ... states) {
        this.configuredMatches.add(new SimpleBlockPredicate(states));
        return this;
    }

    public BlockStateList add(Block block) {
        this.configuredMatches.add(new SimpleBlockPredicate(block));
        return this;
    }

    public ConfiguredBlockStateList getAsConfig(ForgeConfigSpec.Builder cfgBuilder, String key, String translationKey, String comment) {
        ArrayList out = new ArrayList();
        this.configuredMatches.stream().map(SimpleBlockPredicate::getAsConfigList).forEach(out::addAll);
        return new ConfiguredBlockStateList((ForgeConfigSpec.ConfigValue<List<String>>)cfgBuilder.comment(comment).translation(translationKey).define(key, out));
    }

    public static BlockStateList fromConfig(List<String> serializedBlockPredicates) {
        BlockStateList list = new BlockStateList();
        for (String str : serializedBlockPredicates) {
            SimpleBlockPredicate predicate = SimpleBlockPredicate.fromConfig(str);
            if (predicate == null) continue;
            list.configuredMatches.add(predicate);
        }
        return list;
    }

    @Override
    public boolean test(BlockState state) {
        return this.configuredMatches.stream().anyMatch(predicate -> predicate.test(state));
    }

    @Override
    public boolean test(World world, BlockPos pos, BlockState state) {
        return this.configuredMatches.stream().anyMatch(predicate -> predicate.test(world, pos, state));
    }
}

