/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util.block.iterator;

import hellfirepvp.astralsorcery.common.util.block.BlockGeometry;
import hellfirepvp.astralsorcery.common.util.block.iterator.BlockPositionGenerator;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;

public class BlockLayerPositionGenerator
extends BlockPositionGenerator {
    private int layer = 0;
    private LinkedList<BlockPos> currentPositions = new LinkedList();

    @Override
    protected BlockPos genNext(BlockPos offset, double radius) {
        int size = MathHelper.func_76128_c((double)radius);
        while (this.currentPositions.isEmpty()) {
            this.generatePositions(size);
        }
        return null;
    }

    private void generatePositions(int maxLayers) {
        if (maxLayers <= 0) {
            this.currentPositions.add(BlockPos.field_177992_a);
            return;
        }
        ++this.layer;
        if (this.layer > maxLayers) {
            this.layer = -maxLayers;
        }
        List<BlockPos> positions = BlockGeometry.getPlane(Direction.UP, maxLayers);
        positions.forEach(pos -> this.currentPositions.add(pos.func_177982_a(0, this.layer, 0)));
        Collections.shuffle(this.currentPositions, new Random(-785629396144587751L));
    }

    @Override
    public void writeToNBT(CompoundNBT nbt) {
        nbt.func_74768_a("layer", this.layer);
    }

    @Override
    public void readFromNBT(CompoundNBT nbt) {
        this.layer = nbt.func_74762_e("layer");
    }
}

