/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util.block.iterator;

import hellfirepvp.astralsorcery.common.util.block.BlockGeometry;
import hellfirepvp.astralsorcery.common.util.block.iterator.BlockPositionGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class BlockSpherePositionGenerator
extends BlockPositionGenerator {
    private int currentRadius = 0;
    private List<BlockPos> currentPositions = new ArrayList<BlockPos>();

    @Override
    public BlockPos genNext(BlockPos offset, double radius) {
        if ((double)this.currentRadius > radius) {
            this.currentPositions.clear();
        }
        while (this.currentPositions.isEmpty()) {
            this.generatePositions(radius);
        }
        return this.currentPositions.remove(0).func_177971_a((Vec3i)offset);
    }

    private void generatePositions(double maxRadius) {
        if (maxRadius <= 0.0) {
            this.currentPositions.add(BlockPos.field_177992_a);
            return;
        }
        if ((double)this.currentRadius >= maxRadius || this.currentRadius < 0) {
            this.currentRadius = 0;
        }
        ++this.currentRadius;
        this.currentPositions.addAll(BlockGeometry.getHollowSphere(this.currentRadius, this.currentRadius - 1));
        Collections.shuffle(this.currentPositions, new Random(-785629396144587751L));
    }

    @Override
    public void writeToNBT(CompoundNBT nbt) {
        nbt.func_74768_a("currentRadius", this.currentRadius);
    }

    @Override
    public void readFromNBT(CompoundNBT nbt) {
        this.currentRadius = nbt.func_74762_e("currentRadius");
    }
}

