/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util.data;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.network.PacketBuffer;
import net.minecraft.state.IProperty;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryManager;

public class ByteBufUtils {
    @Nullable
    public static <T> T readOptional(PacketBuffer buf, Function<PacketBuffer, T> readFct) {
        if (buf.readBoolean()) {
            return readFct.apply(buf);
        }
        return null;
    }

    public static <T> void writeOptional(PacketBuffer buf, @Nullable T object, BiConsumer<PacketBuffer, T> applyFct) {
        ByteBufUtils.writeOptional(buf, object, Function.identity(), applyFct);
    }

    public static <T, R> void writeOptional(PacketBuffer buf, @Nullable T object, Function<T, R> converter, BiConsumer<PacketBuffer, R> applyFct) {
        buf.writeBoolean(object != null);
        if (object != null) {
            applyFct.accept(buf, converter.apply(object));
        }
    }

    public static void writeUUID(PacketBuffer buf, UUID uuid) {
        buf.writeLong(uuid.getMostSignificantBits());
        buf.writeLong(uuid.getLeastSignificantBits());
    }

    public static UUID readUUID(PacketBuffer buf) {
        return new UUID(buf.readLong(), buf.readLong());
    }

    public static <T> void writeList(PacketBuffer buf, @Nullable Collection<T> list, BiConsumer<PacketBuffer, T> iterationFct) {
        if (list != null) {
            buf.writeInt(list.size());
            list.forEach(e -> iterationFct.accept(buf, e));
        } else {
            buf.writeInt(-1);
        }
    }

    @Nullable
    public static <T> List<T> readList(PacketBuffer buf, Function<PacketBuffer, T> readFct) {
        int size = buf.readInt();
        if (size == -1) {
            return null;
        }
        ArrayList<T> list = new ArrayList<T>(size);
        for (int i = 0; i < size; ++i) {
            list.add(readFct.apply(buf));
        }
        return list;
    }

    public static <K, V> void writeMap(PacketBuffer buf, @Nullable Map<K, V> map, BiConsumer<PacketBuffer, K> keySerializer, BiConsumer<PacketBuffer, V> valueSerializer) {
        if (map != null) {
            buf.writeInt(map.size());
            for (Map.Entry<K, V> entry : map.entrySet()) {
                keySerializer.accept(buf, entry.getKey());
                valueSerializer.accept(buf, entry.getValue());
            }
        } else {
            buf.writeInt(-1);
        }
    }

    @Nullable
    public static <K, V> Map<K, V> readMap(PacketBuffer buf, Function<PacketBuffer, K> readKey, Function<PacketBuffer, V> readValue) {
        int size = buf.readInt();
        if (size == -1) {
            return null;
        }
        HashMap<K, V> map = new HashMap<K, V>(size);
        for (int i = 0; i < size; ++i) {
            map.put(readKey.apply(buf), readValue.apply(buf));
        }
        return map;
    }

    public static void writeString(PacketBuffer buf, String toWrite) {
        byte[] str = toWrite.getBytes(Charset.forName("UTF-8"));
        buf.writeInt(str.length);
        buf.writeBytes(str);
    }

    public static String readString(PacketBuffer buf) {
        int length = buf.readInt();
        byte[] strBytes = new byte[length];
        buf.readBytes(strBytes, 0, length);
        return new String(strBytes, Charset.forName("UTF-8"));
    }

    public static <T> void writeRegistryEntry(PacketBuffer buf, IForgeRegistryEntry<T> entry) {
        if (entry instanceof DimensionType) {
            buf.writeInt(1);
            ByteBufUtils.writeResourceLocation(buf, DimensionType.func_212678_a((DimensionType)((DimensionType)entry)));
        } else {
            buf.writeInt(0);
            ByteBufUtils.writeResourceLocation(buf, entry.getRegistryName());
            ByteBufUtils.writeResourceLocation(buf, RegistryManager.ACTIVE.getRegistry(entry.getRegistryType()).getRegistryName());
        }
    }

    public static <T> T readRegistryEntry(PacketBuffer buf) {
        int type = buf.readInt();
        if (type == 1) {
            ResourceLocation entryName = ByteBufUtils.readResourceLocation(buf);
            return (T)DimensionType.func_193417_a((ResourceLocation)entryName);
        }
        ResourceLocation entryName = ByteBufUtils.readResourceLocation(buf);
        ResourceLocation registryName = ByteBufUtils.readResourceLocation(buf);
        return (T)RegistryManager.ACTIVE.getRegistry(registryName).getValue(entryName);
    }

    public static void writeResourceLocation(PacketBuffer buf, ResourceLocation key) {
        ByteBufUtils.writeString(buf, key.toString());
    }

    public static ResourceLocation readResourceLocation(PacketBuffer buf) {
        return new ResourceLocation(ByteBufUtils.readString(buf));
    }

    public static void writeNumber(PacketBuffer buf, Number nbr) {
        long sNumber = nbr.longValue();
        if (nbr instanceof Float) {
            sNumber = Float.floatToRawIntBits(nbr.floatValue());
        } else if (nbr instanceof Double) {
            sNumber = Double.doubleToRawLongBits(nbr.doubleValue());
        }
        buf.writeLong(sNumber);
    }

    public static long readNumber(PacketBuffer buf) {
        return buf.readLong();
    }

    public static <T extends Enum<T>> void writeEnumValue(PacketBuffer buf, T value) {
        buf.writeInt(value.ordinal());
    }

    public static <T extends Enum<T>> T readEnumValue(PacketBuffer buf, Class<T> enumClazz) {
        if (!enumClazz.isEnum()) {
            throw new IllegalArgumentException("Passed class is not an enum!");
        }
        return (T)((Enum[])enumClazz.getEnumConstants())[buf.readInt()];
    }

    public static void writeJsonObject(PacketBuffer buf, JsonObject object) {
        ByteBufUtils.writeString(buf, object.toString());
    }

    public static JsonObject readJsonObject(PacketBuffer buf) {
        return new JsonParser().parse(ByteBufUtils.readString(buf)).getAsJsonObject();
    }

    public static void writePos(PacketBuffer buf, BlockPos pos) {
        buf.writeInt(pos.func_177958_n());
        buf.writeInt(pos.func_177956_o());
        buf.writeInt(pos.func_177952_p());
    }

    public static BlockPos readPos(PacketBuffer buf) {
        int x = buf.readInt();
        int y = buf.readInt();
        int z = buf.readInt();
        return new BlockPos(x, y, z);
    }

    public static void writeVector(PacketBuffer buf, Vector3 vec) {
        buf.writeDouble(vec.getX());
        buf.writeDouble(vec.getY());
        buf.writeDouble(vec.getZ());
    }

    public static Vector3 readVector(PacketBuffer buf) {
        double x = buf.readDouble();
        double y = buf.readDouble();
        double z = buf.readDouble();
        return new Vector3(x, y, z);
    }

    public static void writeItemStack(PacketBuffer byteBuf, @Nonnull ItemStack stack) {
        boolean defined = !stack.func_190926_b();
        byteBuf.writeBoolean(defined);
        if (defined) {
            CompoundNBT tag = new CompoundNBT();
            stack.func_77955_b(tag);
            ByteBufUtils.writeNBTTag(byteBuf, tag);
        }
    }

    @Nonnull
    public static ItemStack readItemStack(PacketBuffer byteBuf) {
        boolean defined = byteBuf.readBoolean();
        if (defined) {
            return ItemStack.func_199557_a((CompoundNBT)ByteBufUtils.readNBTTag(byteBuf));
        }
        return ItemStack.field_190927_a;
    }

    public static void writeBlockState(PacketBuffer byteBuf, @Nonnull BlockState state) {
        ByteBufUtils.writeRegistryEntry(byteBuf, state.func_177230_c());
        Collection properties = state.func_206869_a();
        byteBuf.writeInt(properties.size());
        for (IProperty prop : properties) {
            ByteBufUtils.writeString(byteBuf, prop.func_177701_a());
            ByteBufUtils.writeString(byteBuf, prop.func_177702_a(state.func_177229_b(prop)));
        }
    }

    public static <T extends Comparable<T>> BlockState readBlockState(PacketBuffer byteBuf) {
        Block block = (Block)ByteBufUtils.readRegistryEntry(byteBuf);
        BlockState state = block.func_176223_P();
        int properties = byteBuf.readInt();
        for (int i = 0; i < properties; ++i) {
            Optional value;
            String propName = ByteBufUtils.readString(byteBuf);
            String valueStr = ByteBufUtils.readString(byteBuf);
            IProperty property = MiscUtils.iterativeSearch(state.func_206869_a(), prop -> prop.func_177701_a().equalsIgnoreCase(propName));
            if (property == null || !(value = property.func_185929_b(valueStr)).isPresent()) continue;
            state = (BlockState)state.func_206870_a(property, (Comparable)value.get());
        }
        return state;
    }

    public static void writeFluidStack(PacketBuffer byteBuf, @Nonnull FluidStack stack) {
        stack.writeToPacket(byteBuf);
    }

    @Nonnull
    public static FluidStack readFluidStack(PacketBuffer byteBuf) {
        return FluidStack.readFromPacket((PacketBuffer)byteBuf);
    }

    public static void writeNBTTag(PacketBuffer byteBuf, @Nonnull CompoundNBT tag) {
        try (DataOutputStream dos = new DataOutputStream((OutputStream)new ByteBufOutputStream((ByteBuf)byteBuf));){
            CompressedStreamTools.func_74800_a((CompoundNBT)tag, (DataOutput)dos);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    public static CompoundNBT readNBTTag(PacketBuffer byteBuf) {
        try (DataInputStream dis = new DataInputStream((InputStream)new ByteBufInputStream((ByteBuf)byteBuf));){
            CompoundNBT compoundNBT = CompressedStreamTools.func_74794_a((DataInputStream)dis);
            return compoundNBT;
        }
        catch (Exception exception) {
            throw new IllegalStateException("Could not load NBT Tag from incoming byte buffer!");
        }
    }
}

