/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util.entity;

import com.google.common.base.Predicate;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.WorldEntitySpawner;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameterSets;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;

public class EntityUtils {
    private static final Random rand = new Random();

    public static void applyVortexMotion(Supplier<Vector3> positionSupplier, Consumer<Vector3> addMotion, Vector3 to, double vortexRange, double multiplier) {
        double diffZ;
        double diffY;
        Vector3 pos = positionSupplier.get();
        double diffX = (to.getX() - pos.getX()) / vortexRange;
        double dist = Math.sqrt(diffX * diffX + (diffY = (to.getY() - pos.getY()) / vortexRange) * diffY + (diffZ = (to.getZ() - pos.getZ()) / vortexRange) * diffZ);
        if (1.0 - dist > 0.0) {
            double dstFactorSq = (1.0 - dist) * (1.0 - dist);
            Vector3 toAdd = new Vector3();
            toAdd.setX(diffX / dist * dstFactorSq * 0.15 * multiplier);
            toAdd.setY(diffY / dist * dstFactorSq * 0.15 * multiplier);
            toAdd.setZ(diffZ / dist * dstFactorSq * 0.15 * multiplier);
            addMotion.accept(toAdd);
        }
    }

    @Nullable
    public static LivingEntity performWorldSpawningAt(ServerWorld world, BlockPos pos, EntityClassification category, SpawnReason reason, boolean ignoreWeighting) {
        List spawnList = world.func_72863_F().func_201711_g().func_177458_a(EntityClassification.MONSTER, pos);
        spawnList = ForgeEventFactory.getPotentialSpawns((IWorld)world, (EntityClassification)category, (BlockPos)pos, (List)spawnList);
        spawnList.removeIf(s -> !s.field_200702_b.func_200720_b());
        Biome.SpawnListEntry entry = ignoreWeighting ? (Biome.SpawnListEntry)MiscUtils.getRandomEntry(spawnList, rand) : MiscUtils.getWeightedRandomEntry(spawnList, rand, ee -> ee.field_76292_a);
        if (entry != null && WorldEntitySpawner.func_222266_a((IBlockReader)world, (BlockPos)pos, (BlockState)world.func_180495_p(pos), (IFluidState)world.func_204610_c(pos))) {
            float x = (float)pos.func_177958_n() + 0.5f;
            float y = pos.func_177956_o();
            float z = (float)pos.func_177952_p() + 0.5f;
            if (EntityUtils.isSpawnableAt((World)world, pos)) {
                MobEntity entity;
                try {
                    entity = (MobEntity)entry.field_200702_b.func_200721_a((World)world);
                }
                catch (Exception exception) {
                    return null;
                }
                if (entity == null) {
                    return null;
                }
                entity.func_70012_b((double)x, (double)y, (double)z, rand.nextFloat() * 360.0f, 0.0f);
                int result = ForgeHooks.canEntitySpawn((MobEntity)entity, (IWorld)world, (double)x, (double)y, (double)z, null, (SpawnReason)reason);
                if (result == -1) {
                    return null;
                }
                if (!ForgeEventFactory.doSpecialSpawn((MobEntity)entity, (World)world, (float)x, (float)y, (float)z, null, (SpawnReason)reason)) {
                    entity.func_213386_a((IWorld)world, world.func_175649_E(pos), reason, null, null);
                }
                if (world.func_217376_c((Entity)entity)) {
                    return entity;
                }
            }
        }
        return null;
    }

    private static boolean isSpawnableAt(World world, BlockPos pos) {
        BlockPos up = pos.func_177984_a();
        return WorldEntitySpawner.func_222266_a((IBlockReader)world, (BlockPos)pos, (BlockState)world.func_180495_p(pos), (IFluidState)world.func_204610_c(pos)) && WorldEntitySpawner.func_222266_a((IBlockReader)world, (BlockPos)up, (BlockState)world.func_180495_p(up), (IFluidState)world.func_204610_c(up));
    }

    public static boolean canEntitySpawnHere(World world, BlockPos at, EntityType<? extends Entity> type, SpawnReason spawnReason, @Nullable Consumer<Entity> preCheckEntity) {
        EntitySpawnPlacementRegistry.PlacementType placementType = EntitySpawnPlacementRegistry.func_209344_a(type);
        if (!world.func_175723_af().func_177746_a(at) || !placementType.canSpawnAt((IWorldReader)world, at, type)) {
            return false;
        }
        if (!EntitySpawnPlacementRegistry.func_223515_a(type, (IWorld)world, (SpawnReason)spawnReason, (BlockPos)at, (Random)world.field_73012_v)) {
            return false;
        }
        if (world.func_226664_a_(type.func_220328_a((double)at.func_177958_n() + 0.5, (double)at.func_177956_o(), (double)at.func_177952_p() + 0.5))) {
            return false;
        }
        Entity entity = type.func_200721_a(world);
        if (entity == null) {
            return false;
        }
        entity.func_70012_b((double)at.func_177958_n() + 0.5, (double)at.func_177956_o() + 0.5, (double)at.func_177952_p() + 0.5, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
        if (preCheckEntity != null) {
            preCheckEntity.accept(entity);
        }
        if (entity instanceof LivingEntity && entity instanceof MobEntity) {
            MobEntity mobEntity = (MobEntity)entity;
            Event.Result canSpawn = ForgeEventFactory.canEntitySpawn((MobEntity)mobEntity, (IWorld)world, (double)entity.func_226277_ct_(), (double)entity.func_226278_cu_(), (double)entity.func_226281_cx_(), null, (SpawnReason)spawnReason);
            if (canSpawn == Event.Result.DENY) {
                return false;
            }
            if (!(canSpawn != Event.Result.DEFAULT || mobEntity.func_213380_a((IWorld)world, spawnReason) && mobEntity.func_205019_a((IWorldReader)world))) {
                return false;
            }
        }
        return true;
    }

    @Nonnull
    public static List<ItemStack> generateLoot(LivingEntity entity, Random rand, DamageSource srcDeath, @Nullable LivingEntity lastAttacker) {
        MinecraftServer srv = (MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
        ServerWorld sw = (ServerWorld)entity.func_130014_f_();
        if (!sw.func_82736_K().func_223586_b(GameRules.field_223602_e)) {
            return Collections.emptyList();
        }
        ResourceLocation lootTableKey = entity.func_213346_cF();
        LootTable table = srv.func_200249_aQ().func_186521_a(lootTableKey);
        LootContext.Builder builder = new LootContext.Builder(sw).func_216023_a(rand).func_216015_a(LootParameters.field_216281_a, (Object)entity).func_216015_a(LootParameters.field_216286_f, (Object)new BlockPos((Entity)entity)).func_216015_a(LootParameters.field_216283_c, (Object)srcDeath).func_216021_b(LootParameters.field_216284_d, (Object)srcDeath.func_76346_g()).func_216021_b(LootParameters.field_216285_e, (Object)srcDeath.func_76364_f());
        if (lastAttacker != null && lastAttacker instanceof PlayerEntity) {
            builder.func_216015_a(LootParameters.field_216282_b, (Object)((PlayerEntity)lastAttacker)).func_186469_a(((PlayerEntity)lastAttacker).func_184817_da());
        }
        return table.func_216113_a(builder.func_216022_a(LootParameterSets.field_216263_d));
    }

    @Nullable
    public static <T extends Entity> T getClosestEntity(IWorld world, Class<T> type, AxisAlignedBB box, Vector3 closestTo) {
        List entities = world.func_175647_a(type, box, Entity::func_70089_S);
        return (T)EntityUtils.selectClosest(entities, closestTo::distanceSquared);
    }

    public static Predicate<? super Entity> selectEntities(Class<? extends Entity> ... entities) {
        return entity -> {
            if (entity == null || !entity.func_70089_S()) {
                return false;
            }
            Class<?> clazz = entity.getClass();
            for (Class test : entities) {
                if (!test.isAssignableFrom(clazz)) continue;
                return true;
            }
            return false;
        };
    }

    public static Predicate<? super Entity> selectItemClassInstaceof(Class<?> itemClass) {
        return entity -> {
            if (entity == null || !entity.func_70089_S()) {
                return false;
            }
            if (!(entity instanceof ItemEntity)) {
                return false;
            }
            ItemStack i = ((ItemEntity)entity).func_92059_d();
            if (i.func_190926_b()) {
                return false;
            }
            return itemClass.isAssignableFrom(i.func_77973_b().getClass());
        };
    }

    public static Predicate<? super Entity> selectItem(Item item) {
        return entity -> {
            if (entity == null || !entity.func_70089_S()) {
                return false;
            }
            if (!(entity instanceof ItemEntity)) {
                return false;
            }
            ItemStack i = ((ItemEntity)entity).func_92059_d();
            if (i.func_190926_b()) {
                return false;
            }
            return i.func_77973_b().equals(item);
        };
    }

    public static Predicate<? super Entity> selectItemStack(Function<ItemStack, Boolean> acceptor) {
        return entity -> {
            if (entity == null || !entity.func_70089_S()) {
                return false;
            }
            if (!(entity instanceof ItemEntity)) {
                return false;
            }
            ItemStack i = ((ItemEntity)entity).func_92059_d();
            if (i.func_190926_b()) {
                return false;
            }
            return (Boolean)acceptor.apply(i);
        };
    }

    @Nullable
    public static <T> T selectClosest(Collection<T> elements, Function<T, Double> dstFunc) {
        if (elements.isEmpty()) {
            return null;
        }
        double dstClosest = Double.MAX_VALUE;
        T closestElement = null;
        for (T element : elements) {
            double dst = dstFunc.apply(element);
            if (!(dst < dstClosest)) continue;
            closestElement = element;
            dstClosest = dst;
        }
        return closestElement;
    }
}

