/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util.order;

import com.google.common.collect.Lists;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import hellfirepvp.astralsorcery.common.util.order.OrderSortable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraftforge.fml.loading.toposort.TopologicalSort;

public class DependencySorter<T> {
    private final MutableGraph<T> graph = GraphBuilder.directed().build();

    private DependencySorter(Collection<T> itemsToSort) {
        itemsToSort.forEach(arg_0 -> this.graph.addNode(arg_0));
    }

    public static <T extends OrderSortable> List<T> getSorted(Collection<T> itemsToSort) {
        return DependencySorter.getSorted(itemsToSort, OrderSortable::isBefore, OrderSortable::isAfter);
    }

    public static <T> List<T> getSorted(Collection<T> itemsToSort, BiPredicate<T, Object> isBefore, BiPredicate<T, Object> isAfter) {
        DependencySorter<T> sorter = new DependencySorter<T>(itemsToSort);
        for (T item : itemsToSort) {
            ArrayList before = Lists.newArrayList();
            ArrayList after = Lists.newArrayList();
            for (T otherItem : itemsToSort) {
                if (item == otherItem) continue;
                if (isBefore.test(item, otherItem)) {
                    before.add(otherItem);
                }
                if (!isAfter.test(item, otherItem)) continue;
                after.add(otherItem);
            }
            super.setOrdering(item, before, after);
        }
        return super.getSorted();
    }

    private void setOrdering(T node, Collection<T> before, Collection<T> after) {
        before.forEach(n -> this.graph.putEdge(node, n));
        after.forEach(n -> this.graph.putEdge(n, node));
    }

    private List<T> getSorted() {
        return TopologicalSort.topologicalSort(this.graph, null);
    }
}

