/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util.tile;

import hellfirepvp.astralsorcery.common.util.MiscUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidTankAccess {
    private Set<AccessibleTank> tanks = new HashSet<AccessibleTank>();

    public void putTank(int tankId, IFluidTank tank, Direction ... sides) {
        this.tanks.add(new AccessibleTank(tankId, tank, sides));
    }

    public void putTank(int tankId, IFluidTank tank, Predicate<Direction> accessibleSides) {
        this.tanks.add(new AccessibleTank(tankId, tank, accessibleSides));
    }

    private boolean hasTanksForSide(Direction dir) {
        return dir == null || MiscUtils.contains(this.tanks, tank -> ((AccessibleTank)tank).accessibleSides.test(dir));
    }

    public boolean hasCapability(Capability<?> capability, @Nullable Direction facing) {
        return CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY == capability && this.hasTanksForSide(facing);
    }

    public LazyOptional<IFluidHandler> getCapability(@Nullable Direction facing) {
        Set<AccessibleTank> available = facing == null ? this.tanks : this.tanks.stream().filter(t -> ((AccessibleTank)t).isAccessible(facing)).collect(Collectors.toSet());
        return available.isEmpty() ? LazyOptional.empty() : LazyOptional.of(() -> new SidedAccess(available));
    }

    private static class AccessibleTank {
        private final int id;
        private final IFluidTank tank;
        private final Predicate<Direction> accessibleSides;

        private AccessibleTank(int id, IFluidTank tank, Direction ... sides) {
            this(id, tank, (Direction side) -> Arrays.asList(sides).contains(side));
        }

        private AccessibleTank(int id, IFluidTank tank, Predicate<Direction> accessibleSides) {
            this.id = id;
            this.tank = tank;
            this.accessibleSides = accessibleSides;
        }

        private IFluidTank getTank() {
            return this.tank;
        }

        private int getId() {
            return this.id;
        }

        private boolean isAccessible(Direction side) {
            return this.accessibleSides.test(side);
        }
    }

    private static class SidedAccess
    implements IFluidHandler {
        private final Set<AccessibleTank> tanks;

        private SidedAccess(Set<AccessibleTank> accessibleTanks) {
            this.tanks = accessibleTanks;
        }

        private Optional<AccessibleTank> getTank(int id) {
            return this.tanks.stream().filter(tank -> ((AccessibleTank)tank).getId() == id).findFirst();
        }

        public int getTanks() {
            return this.tanks.size();
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return this.getTank(tank).map(t -> ((AccessibleTank)t).getTank().getFluid()).orElse(FluidStack.EMPTY);
        }

        public int getTankCapacity(int tank) {
            return this.getTank(tank).map(t -> ((AccessibleTank)t).getTank().getCapacity()).orElse(0);
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return this.getTank(tank).map(t -> ((AccessibleTank)t).getTank().isFluidValid(stack)).orElse(false);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            for (AccessibleTank tank : this.tanks) {
                int filled = tank.getTank().fill(resource, action);
                if (filled <= 0) continue;
                return filled;
            }
            return 0;
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            for (AccessibleTank tank : this.tanks) {
                FluidStack drained = tank.getTank().drain(resource, action);
                if (drained.isEmpty()) continue;
                return drained;
            }
            return FluidStack.EMPTY;
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            for (AccessibleTank tank : this.tanks) {
                FluidStack drained = tank.getTank().drain(maxDrain, action);
                if (drained.isEmpty()) continue;
                return drained;
            }
            return FluidStack.EMPTY;
        }
    }
}

