/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util.time;

import hellfirepvp.astralsorcery.common.data.sync.SyncDataHolder;
import hellfirepvp.astralsorcery.common.data.sync.server.DataTimeFreezeEffects;
import hellfirepvp.astralsorcery.common.lib.EffectsAS;
import hellfirepvp.astralsorcery.common.util.time.TimeStopEffectHelper;
import hellfirepvp.astralsorcery.common.util.time.TimeStopZone;
import hellfirepvp.observerlib.common.util.tick.ITickHandler;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.boss.dragon.phase.PhaseType;
import net.minecraft.potion.Effect;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.event.TickEvent;

public class TimeStopController
implements ITickHandler {
    private static Map<DimensionType, List<TimeStopZone>> activeTimeStopZones = new HashMap<DimensionType, List<TimeStopZone>>();
    public static final TimeStopController INSTANCE = new TimeStopController();

    private TimeStopController() {
    }

    @Nullable
    public static TimeStopZone tryGetZoneAt(World world, BlockPos pos) {
        if (world.field_72995_K) {
            return null;
        }
        DimensionType dimType = world.func_201675_m().func_186058_p();
        List zones = activeTimeStopZones.getOrDefault(dimType, Collections.emptyList());
        for (TimeStopZone zone : zones) {
            if (!zone.offset.equals((Object)pos)) continue;
            return zone;
        }
        return null;
    }

    @Nonnull
    public static TimeStopZone freezeWorldAt(@Nonnull TimeStopZone.EntityTargetController controller, @Nonnull World world, @Nonnull BlockPos offset, float range, int maxAge) {
        TimeStopZone stopZone = new TimeStopZone(controller, range, offset, world, maxAge);
        DimensionType type = world.func_201675_m().func_186058_p();
        List zones = activeTimeStopZones.computeIfAbsent(type, id -> new LinkedList());
        zones.add(stopZone);
        SyncDataHolder.executeServer(SyncDataHolder.DATA_TIME_FREEZE_EFFECTS, DataTimeFreezeEffects.class, data -> data.addNewEffect(type, TimeStopEffectHelper.fromZone(stopZone)));
        return stopZone;
    }

    public static void onWorldUnload(IWorld world) {
        if (world.func_201670_d()) {
            return;
        }
        DimensionType type = world.func_201675_m().func_186058_p();
        for (TimeStopZone stop : activeTimeStopZones.getOrDefault(type, Collections.emptyList())) {
            stop.stopEffect();
        }
        activeTimeStopZones.remove(type);
    }

    public static boolean skipLivingTick(LivingEntity e) {
        DimensionType type;
        List<TimeStopZone> freezeAreas;
        if (e.func_70644_a((Effect)EffectsAS.EFFECT_TIME_FREEZE)) {
            boolean shouldFreeze = true;
            if (!e.func_70089_S() || e.func_110143_aJ() <= 0.0f) {
                shouldFreeze = false;
            }
            if (e instanceof EnderDragonEntity && ((EnderDragonEntity)e).func_184670_cT().func_188756_a().func_188652_i() == PhaseType.field_188750_j) {
                shouldFreeze = false;
            }
            if (shouldFreeze) {
                if (e.field_70170_p.func_201670_d() && e.field_70170_p.field_73012_v.nextInt(5) == 0) {
                    TimeStopEffectHelper.playEntityParticles(e);
                }
                TimeStopZone.handleImportantEntityTicks(e);
                return true;
            }
        }
        if ((freezeAreas = activeTimeStopZones.get(type = e.func_130014_f_().func_201675_m().func_186058_p())) != null && !freezeAreas.isEmpty()) {
            for (TimeStopZone stop : freezeAreas) {
                if (!stop.interceptEntityTick(e)) continue;
                TimeStopZone.handleImportantEntityTicks(e);
                return true;
            }
        }
        return false;
    }

    public void tick(TickEvent.Type type, Object ... context) {
        for (Map.Entry<DimensionType, List<TimeStopZone>> zoneMap : activeTimeStopZones.entrySet()) {
            Iterator<TimeStopZone> iterator = zoneMap.getValue().iterator();
            while (iterator.hasNext()) {
                TimeStopZone zone = iterator.next();
                if (zone.shouldDespawn()) {
                    zone.stopEffect();
                    SyncDataHolder.executeServer(SyncDataHolder.DATA_TIME_FREEZE_EFFECTS, DataTimeFreezeEffects.class, data -> data.removeEffect((DimensionType)zoneMap.getKey(), TimeStopEffectHelper.fromZone(zone)));
                    iterator.remove();
                    continue;
                }
                zone.onServerTick();
                if (!zone.shouldDespawn()) continue;
                zone.stopEffect();
                SyncDataHolder.executeServer(SyncDataHolder.DATA_TIME_FREEZE_EFFECTS, DataTimeFreezeEffects.class, data -> data.removeEffect((DimensionType)zoneMap.getKey(), TimeStopEffectHelper.fromZone(zone)));
                iterator.remove();
            }
        }
    }

    public EnumSet<TickEvent.Type> getHandledTypes() {
        return EnumSet.of(TickEvent.Type.SERVER);
    }

    public boolean canFire(TickEvent.Phase phase) {
        return phase.equals((Object)TickEvent.Phase.START);
    }

    public String getName() {
        return "TimeStop Controller";
    }
}

