/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.world.config;

import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import hellfirepvp.astralsorcery.common.data.config.base.ConfigEntry;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.IBiomeMagnifier;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.ForgeConfigSpec;

public class FeaturePlacementConfig
extends ConfigEntry
implements IPlacementConfig {
    private final boolean defaultWhitelistBiomeSpecification;
    private final boolean defaultWhitelistDimensionSpecification;
    private final List<BiomeDictionary.Type> defaultApplicableBiomeTypes;
    private final List<DimensionType> defaultApplicableDimensionTypes;
    private final int defaultMinY;
    private final int defaultMaxY;
    private final int defaultGenerationChance;
    private final int defaultGenerationAmount;
    private ForgeConfigSpec.BooleanValue configEnabled;
    private ForgeConfigSpec.IntValue configMinY;
    private ForgeConfigSpec.IntValue configMaxY;
    private ForgeConfigSpec.IntValue configGenerationChance;
    private ForgeConfigSpec.IntValue configGenerationAmount;
    private ForgeConfigSpec.BooleanValue configWhitelistBiomeCfg;
    private ForgeConfigSpec.BooleanValue configWhitelistDimensionCfg;
    private ForgeConfigSpec.ConfigValue<List<String>> configBiomeTypes;
    private ForgeConfigSpec.ConfigValue<List<String>> configDimensionTypes;
    private List<BiomeDictionary.Type> convertedBiomeTypes = null;
    private List<DimensionType> convertedDimensionTypes = null;

    public FeaturePlacementConfig(String featureName, boolean defaultWhitelistBiomeSpecification, boolean defaultWhitelistDimensionSpecification, List<BiomeDictionary.Type> defaultApplicableBiomeTypes, List<DimensionType> defaultApplicableDimensionTypes, int defaultMinY, int defaultMaxY, int defaultGenerationChance, int defaultGenerationAmount) {
        super(String.format("world.generation.%s", featureName.toLowerCase()));
        this.defaultWhitelistBiomeSpecification = defaultWhitelistBiomeSpecification;
        this.defaultWhitelistDimensionSpecification = defaultWhitelistDimensionSpecification;
        this.defaultApplicableBiomeTypes = defaultApplicableBiomeTypes;
        this.defaultApplicableDimensionTypes = defaultApplicableDimensionTypes;
        this.defaultMinY = defaultMinY;
        this.defaultMaxY = defaultMaxY;
        this.defaultGenerationChance = defaultGenerationChance;
        this.defaultGenerationAmount = defaultGenerationAmount;
    }

    public boolean canGenerateAtAll() {
        return (Boolean)this.configEnabled.get();
    }

    public int getRandomY(Random rand) {
        int minY = Math.min((Integer)this.configMinY.get(), (Integer)this.configMaxY.get());
        int maxY = Math.max((Integer)this.configMinY.get(), (Integer)this.configMaxY.get());
        return minY + rand.nextInt(Math.max(maxY - minY, 1));
    }

    public boolean generatesInWorld(DimensionType dimType) {
        if (this.convertedDimensionTypes == null) {
            this.convertedDimensionTypes = this.convertDimensionTypeNames();
        }
        if (((Boolean)this.configWhitelistDimensionCfg.get()).booleanValue()) {
            return this.convertedDimensionTypes.contains(dimType);
        }
        return !this.convertedDimensionTypes.contains(dimType);
    }

    public boolean generatesInBiome(Biome biome) {
        if (this.convertedBiomeTypes == null) {
            this.convertedBiomeTypes = this.convertBiomeTypeNames();
        }
        if (((Boolean)this.configWhitelistBiomeCfg.get()).booleanValue()) {
            for (BiomeDictionary.Type type : this.convertedBiomeTypes) {
                if (!BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)type)) continue;
                return true;
            }
            return false;
        }
        for (BiomeDictionary.Type type : this.convertedBiomeTypes) {
            if (!BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)type)) continue;
            return false;
        }
        return true;
    }

    public boolean canPlace(IWorld iWorld, BiomeProvider biomeProvider, BlockPos pos, Random rand) {
        int rMaxY;
        if (!this.canGenerateAtAll()) {
            return false;
        }
        if (!this.generatesInWorld(iWorld.func_201675_m().func_186058_p())) {
            return false;
        }
        long hashedSeed = WorldInfo.func_227498_c_((long)iWorld.func_72905_C());
        IBiomeMagnifier biomeZoom = iWorld.func_201675_m().func_186058_p().func_227176_e_();
        Biome biome = biomeZoom.func_225532_a_(hashedSeed, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), (arg_0, arg_1, arg_2) -> ((IWorld)iWorld).func_225604_a_(arg_0, arg_1, arg_2));
        if (!this.generatesInBiome(biome)) {
            return false;
        }
        int rMinY = (Integer)this.configMinY.get();
        return rMinY <= (rMaxY = ((Integer)this.configMaxY.get()).intValue()) && pos.func_177956_o() >= rMinY && pos.func_177956_o() <= rMaxY;
    }

    private List<BiomeDictionary.Type> convertBiomeTypeNames() {
        return ((List)this.configBiomeTypes.get()).stream().filter(name -> BiomeDictionary.Type.getType((String)name, (BiomeDictionary.Type[])new BiomeDictionary.Type[0]) != null).map(name -> BiomeDictionary.Type.getType((String)name, (BiomeDictionary.Type[])new BiomeDictionary.Type[0])).collect(Collectors.toList());
    }

    private List<DimensionType> convertDimensionTypeNames() {
        return ((List)this.configDimensionTypes.get()).stream().filter(name -> DimensionType.func_193417_a((ResourceLocation)new ResourceLocation(name)) != null).map(name -> DimensionType.func_193417_a((ResourceLocation)new ResourceLocation(name))).collect(Collectors.toList());
    }

    public int getGenerationChance() {
        return (Integer)this.configGenerationChance.get();
    }

    public int getGenerationAmount() {
        return (Integer)this.configGenerationAmount.get();
    }

    public <T> Dynamic<T> func_214719_a(DynamicOps<T> dynamicOps) {
        return new Dynamic(dynamicOps, dynamicOps.emptyMap());
    }

    @Override
    public void createEntries(ForgeConfigSpec.Builder cfgBuilder) {
        this.configEnabled = cfgBuilder.comment("Set this to false to disable this feature from generation.").translation(this.translationKey("enabled")).define("enabled", true);
        this.configMinY = cfgBuilder.comment("Set this to the lowest possible Y-level this feature should be able to generate at. Should be lower than 'maxY'").translation(this.translationKey("miny")).defineInRange("minY", this.defaultMinY, 1, 216);
        this.configMaxY = cfgBuilder.comment("Set this to the highest possible Y-level this feature should be able to generate at. Should be higher than 'minY'").translation(this.translationKey("maxy")).defineInRange("maxY", this.defaultMaxY, 2, 217);
        this.configGenerationChance = cfgBuilder.comment("Set this to set the overall chance for this feature to generate. The higher, the rarer.").translation(this.translationKey("generationchance")).defineInRange("generationChance", this.defaultGenerationChance, 1, 200000);
        this.configGenerationAmount = cfgBuilder.comment("Set the amount this feature tries to generate per chunk").translation(this.translationKey("generationamount")).defineInRange("generationAmount", this.defaultGenerationAmount, 1, 128);
        this.configWhitelistBiomeCfg = cfgBuilder.comment("Set this to true to make the biome-type restrictions a whitelist, false for blacklist").translation(this.translationKey("whitelistbiomespecification")).define("whitelistBiomeConfigurations", this.defaultWhitelistBiomeSpecification);
        this.configWhitelistDimensionCfg = cfgBuilder.comment("Set this to true to make the dimension-id restrictions a whitelist, false for blacklist").translation("whitelistdimensionspecification").define("whitelistDimensionConfigurations", this.defaultWhitelistDimensionSpecification);
        this.configDimensionTypes = cfgBuilder.comment("List all dimensionIds here that this feature should spawn in").translation(this.translationKey("dimensions")).define("dimensionids", this.defaultApplicableDimensionTypes.stream().map(dimType -> dimType.getRegistryName().toString()).collect(Collectors.toList()));
        this.configBiomeTypes = cfgBuilder.comment("List all biome types here that this feature should be able to spawn in").translation(this.translationKey("biometypes")).define("biomeTypes", this.defaultApplicableBiomeTypes.stream().map(BiomeDictionary.Type::getName).collect(Collectors.toList()));
    }
}

