/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.world.config;

import hellfirepvp.astralsorcery.common.world.config.FeaturePlacementConfig;
import java.util.List;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.ForgeConfigSpec;

public class StructurePlacementConfig
extends FeaturePlacementConfig {
    private final int defaultStructureSize;
    private final int defaultStructureDistance;
    private final int defaultStructureSeparation;
    private ForgeConfigSpec.IntValue configStructureSize;
    private ForgeConfigSpec.IntValue configStructureDistance;
    private ForgeConfigSpec.IntValue configStructureSeparation;

    public StructurePlacementConfig(String featureName, int structureSize, List<BiomeDictionary.Type> applicableBiomeTypes, List<DimensionType> applicableDimensions, int minY, int maxY, int generationChance, int defaultStructureDistance, int defaultStructureSeparation) {
        super(featureName, true, true, applicableBiomeTypes, applicableDimensions, minY, maxY, generationChance, 1);
        this.defaultStructureSize = structureSize;
        this.defaultStructureDistance = defaultStructureDistance;
        this.defaultStructureSeparation = defaultStructureSeparation;
    }

    public int getStructureSize() {
        return (Integer)this.configStructureSize.get();
    }

    public int getStructureDistance() {
        return (Integer)this.configStructureDistance.get();
    }

    public int getStructureSeparation() {
        return (Integer)this.configStructureSeparation.get();
    }

    @Override
    public void createEntries(ForgeConfigSpec.Builder cfgBuilder) {
        super.createEntries(cfgBuilder);
        this.configStructureSize = cfgBuilder.comment("Set this to the estimated structure size to be generated. Should match the structure's bigger width/length.").translation(this.translationKey("structuresize")).defineInRange("structureSize", this.defaultStructureSize, 1, 10000);
        this.configStructureDistance = cfgBuilder.comment("Defines the average structure distance between two structures of this type").translation(this.translationKey("structuredistance")).defineInRange("structuredistance", this.defaultStructureDistance, 1, 150);
        this.configStructureSeparation = cfgBuilder.comment("Defines the average structure separation/position-shift between two structures of this type").translation(this.translationKey("structureseparation")).defineInRange("structureseparation", this.defaultStructureSeparation, 1, 100);
    }
}

