/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.world.placement;

import com.mojang.datafixers.Dynamic;
import hellfirepvp.astralsorcery.common.world.config.ReplacingFeaturePlacementConfig;
import java.util.ArrayList;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.placement.Placement;

public class RandomReplaceablePlacement
extends Placement<ReplacingFeaturePlacementConfig> {
    public RandomReplaceablePlacement(Function<Dynamic<?>, ? extends ReplacingFeaturePlacementConfig> cfgSupplier) {
        super(cfgSupplier);
    }

    public RandomReplaceablePlacement(ReplacingFeaturePlacementConfig config) {
        super(dyn -> config);
    }

    public Stream<BlockPos> getPositions(IWorld worldIn, ChunkGenerator<? extends GenerationSettings> generatorIn, Random random, ReplacingFeaturePlacementConfig configIn, BlockPos pos) {
        if (!configIn.canGenerateAtAll() || random.nextInt(Math.max(configIn.getGenerationChance(), 1)) != 0) {
            return Stream.empty();
        }
        if (!configIn.generatesInBiome(worldIn.func_226691_t_(pos))) {
            return Stream.empty();
        }
        ArrayList<BlockPos> result = new ArrayList<BlockPos>();
        BlockPos at = pos.func_177982_a(random.nextInt(16), 0, random.nextInt(16));
        at = new BlockPos(at.func_177958_n(), configIn.getRandomY(random), at.func_177952_p());
        if (configIn.canPlace(worldIn, generatorIn.func_202090_b(), at, random)) {
            result.add(at);
        }
        for (int amt = configIn.getGenerationAmount(); amt > 0; --amt) {
            BlockPos offset = at.func_177982_a(-1 + random.nextInt(3), -1 + random.nextInt(3), -1 + random.nextInt(3));
            if (offset.equals((Object)at) || !worldIn.func_217354_b(offset.func_177958_n() >> 4, offset.func_177952_p() >> 4) || !configIn.canPlace(worldIn, generatorIn.func_202090_b(), offset, random)) continue;
            result.add(offset);
        }
        return result.stream();
    }
}

