/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.datagen.assets;

import com.google.common.collect.Iterables;
import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.block.blackmarble.BlockBlackMarblePillar;
import hellfirepvp.astralsorcery.common.block.infusedwood.BlockInfusedWoodColumn;
import hellfirepvp.astralsorcery.common.block.marble.BlockMarblePillar;
import hellfirepvp.astralsorcery.common.block.tile.BlockLens;
import hellfirepvp.astralsorcery.common.block.tile.BlockPrism;
import hellfirepvp.astralsorcery.common.block.tile.BlockStructural;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.util.NameUtil;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ExistingFileHelper;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.ArrayUtils;

public class AstralBlockStateMappingProvider
extends BlockStateProvider {
    public AstralBlockStateMappingProvider(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, "astralsorcery", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.simpleBlockState((Block)BlocksAS.FLUID_LIQUID_STARLIGHT);
        this.simpleBlockState(BlocksAS.MARBLE_ARCH);
        this.simpleBlockState(BlocksAS.MARBLE_BRICKS);
        this.simpleBlockState(BlocksAS.MARBLE_CHISELED);
        this.simpleBlockState(BlocksAS.MARBLE_ENGRAVED);
        this.pillarModel(BlocksAS.MARBLE_PILLAR, (IProperty)BlockMarblePillar.PILLAR_TYPE, (Comparable)((Object)BlockMarblePillar.PillarType.MIDDLE), (Comparable)((Object)BlockMarblePillar.PillarType.TOP), (Comparable)((Object)BlockMarblePillar.PillarType.BOTTOM));
        this.simpleBlockState(BlocksAS.MARBLE_RAW);
        this.simpleBlockState(BlocksAS.MARBLE_RUNED);
        this.simpleSlabs(BlocksAS.MARBLE_SLAB, this.model((IForgeRegistryEntry<?>)BlocksAS.MARBLE_BRICKS));
        this.simpleStairs(BlocksAS.MARBLE_STAIRS);
        this.simpleBlockState(BlocksAS.BLACK_MARBLE_ARCH);
        this.simpleBlockState(BlocksAS.BLACK_MARBLE_BRICKS);
        this.simpleBlockState(BlocksAS.BLACK_MARBLE_CHISELED);
        this.simpleBlockState(BlocksAS.BLACK_MARBLE_ENGRAVED);
        this.pillarModel(BlocksAS.BLACK_MARBLE_PILLAR, (IProperty)BlockBlackMarblePillar.PILLAR_TYPE, (Comparable)((Object)BlockBlackMarblePillar.PillarType.MIDDLE), (Comparable)((Object)BlockBlackMarblePillar.PillarType.TOP), (Comparable)((Object)BlockBlackMarblePillar.PillarType.BOTTOM));
        this.simpleBlockState(BlocksAS.BLACK_MARBLE_RAW);
        this.simpleBlockState(BlocksAS.BLACK_MARBLE_RUNED);
        this.simpleSlabs(BlocksAS.BLACK_MARBLE_SLAB, this.model((IForgeRegistryEntry<?>)BlocksAS.BLACK_MARBLE_BRICKS));
        this.simpleStairs(BlocksAS.BLACK_MARBLE_STAIRS);
        this.simpleBlockState(BlocksAS.INFUSED_WOOD);
        this.simpleBlockState(BlocksAS.INFUSED_WOOD_ARCH);
        this.pillarModel(BlocksAS.INFUSED_WOOD_COLUMN, (IProperty)BlockInfusedWoodColumn.PILLAR_TYPE, (Comparable)((Object)BlockInfusedWoodColumn.PillarType.MIDDLE), (Comparable)((Object)BlockInfusedWoodColumn.PillarType.TOP), (Comparable)((Object)BlockInfusedWoodColumn.PillarType.BOTTOM));
        this.simpleBlockState(BlocksAS.INFUSED_WOOD_ENGRAVED);
        this.simpleBlockState(BlocksAS.INFUSED_WOOD_ENRICHED);
        this.simpleBlockState(BlocksAS.INFUSED_WOOD_INFUSED);
        this.simpleBlockState(BlocksAS.INFUSED_WOOD_PLANKS);
        this.simpleSlabs(BlocksAS.INFUSED_WOOD_SLAB, this.model((IForgeRegistryEntry<?>)BlocksAS.INFUSED_WOOD_PLANKS));
        this.simpleStairs(BlocksAS.INFUSED_WOOD_STAIRS);
        this.multiLayerBlockState((Block)BlocksAS.AQUAMARINE_SAND_ORE);
        this.multiLayerBlockState(BlocksAS.ROCK_CRYSTAL_ORE);
        this.multiLayerBlockState(BlocksAS.STARMETAL_ORE);
        this.simpleBlockState((Block)BlocksAS.GLOW_FLOWER);
        this.multiLayerBlockState((Block)BlocksAS.SPECTRAL_RELAY);
        this.simpleBlockState((Block)BlocksAS.ALTAR_DISCOVERY);
        this.simpleBlockState((Block)BlocksAS.ALTAR_ATTUNEMENT);
        this.simpleBlockState((Block)BlocksAS.ALTAR_CONSTELLATION);
        this.simpleBlockState((Block)BlocksAS.ALTAR_RADIANCE);
        this.simpleBlockState((Block)BlocksAS.ATTUNEMENT_ALTAR);
        this.allStateSuffixMultiLayerModel((Block)BlocksAS.CELESTIAL_CRYSTAL_CLUSTER);
        this.allStateSuffixMultiLayerModel((Block)BlocksAS.GEM_CRYSTAL_CLUSTER);
        this.multiLayerBlockState((Block)BlocksAS.ROCK_COLLECTOR_CRYSTAL);
        this.multiLayerBlockState((Block)BlocksAS.CELESTIAL_COLLECTOR_CRYSTAL);
        this.getVariantBuilder((Block)BlocksAS.LENS).partialState().with(BlockLens.PLACED_AGAINST, (Comparable)Direction.UP).addModels(new ConfiguredModel[]{new ConfiguredModel(this.model(AstralSorcery.key("lens_base")), 180, 0, false)}).partialState().with(BlockLens.PLACED_AGAINST, (Comparable)Direction.DOWN).addModels(new ConfiguredModel[]{new ConfiguredModel(this.model(AstralSorcery.key("lens_base")), 0, 0, false)}).partialState().with(BlockLens.PLACED_AGAINST, (Comparable)Direction.NORTH).addModels(new ConfiguredModel[]{new ConfiguredModel(this.model(AstralSorcery.key("lens_base")), 90, 180, false)}).partialState().with(BlockLens.PLACED_AGAINST, (Comparable)Direction.SOUTH).addModels(new ConfiguredModel[]{new ConfiguredModel(this.model(AstralSorcery.key("lens_base")), 90, 0, false)}).partialState().with(BlockLens.PLACED_AGAINST, (Comparable)Direction.EAST).addModels(new ConfiguredModel[]{new ConfiguredModel(this.model(AstralSorcery.key("lens_base")), 90, 270, false)}).partialState().with(BlockLens.PLACED_AGAINST, (Comparable)Direction.WEST).addModels(new ConfiguredModel[]{new ConfiguredModel(this.model(AstralSorcery.key("lens_base")), 90, 90, false)});
        ResourceLocation prism = BlocksAS.PRISM.getRegistryName();
        ResourceLocation prismColored = NameUtil.suffixPath(prism, "_colored");
        ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder((Block)BlocksAS.PRISM).part().modelFile(this.multiLayerModel(prism)).rotationX(180).addModel()).condition(BlockPrism.PLACED_AGAINST, (Comparable[])new Direction[]{Direction.UP}).end().part().modelFile(this.multiLayerModel(prismColored)).rotationX(180).addModel()).condition(BlockPrism.PLACED_AGAINST, (Comparable[])new Direction[]{Direction.UP}).condition((IProperty)BlockPrism.HAS_COLORED_LENS, (Comparable[])new Boolean[]{true}).end().part().modelFile(this.multiLayerModel(prism)).addModel()).condition(BlockPrism.PLACED_AGAINST, (Comparable[])new Direction[]{Direction.DOWN}).end().part().modelFile(this.multiLayerModel(prismColored)).addModel()).condition(BlockPrism.PLACED_AGAINST, (Comparable[])new Direction[]{Direction.DOWN}).condition((IProperty)BlockPrism.HAS_COLORED_LENS, (Comparable[])new Boolean[]{true}).end().part().modelFile(this.multiLayerModel(prism)).rotationX(90).rotationY(180).addModel()).condition(BlockPrism.PLACED_AGAINST, (Comparable[])new Direction[]{Direction.NORTH}).end().part().modelFile(this.multiLayerModel(prismColored)).rotationX(90).rotationY(180).addModel()).condition(BlockPrism.PLACED_AGAINST, (Comparable[])new Direction[]{Direction.NORTH}).condition((IProperty)BlockPrism.HAS_COLORED_LENS, (Comparable[])new Boolean[]{true}).end().part().modelFile(this.multiLayerModel(prism)).rotationX(90).addModel()).condition(BlockPrism.PLACED_AGAINST, (Comparable[])new Direction[]{Direction.SOUTH}).end().part().modelFile(this.multiLayerModel(prismColored)).rotationX(90).addModel()).condition(BlockPrism.PLACED_AGAINST, (Comparable[])new Direction[]{Direction.SOUTH}).condition((IProperty)BlockPrism.HAS_COLORED_LENS, (Comparable[])new Boolean[]{true}).end().part().modelFile(this.multiLayerModel(prism)).rotationX(90).rotationY(270).addModel()).condition(BlockPrism.PLACED_AGAINST, (Comparable[])new Direction[]{Direction.EAST}).end().part().modelFile(this.multiLayerModel(prismColored)).rotationX(90).rotationY(270).addModel()).condition(BlockPrism.PLACED_AGAINST, (Comparable[])new Direction[]{Direction.EAST}).condition((IProperty)BlockPrism.HAS_COLORED_LENS, (Comparable[])new Boolean[]{true}).end().part().modelFile(this.multiLayerModel(prism)).rotationX(90).rotationY(90).addModel()).condition(BlockPrism.PLACED_AGAINST, (Comparable[])new Direction[]{Direction.WEST}).end().part().modelFile(this.multiLayerModel(prismColored)).rotationX(90).rotationY(90).addModel()).condition(BlockPrism.PLACED_AGAINST, (Comparable[])new Direction[]{Direction.WEST}).condition((IProperty)BlockPrism.HAS_COLORED_LENS, (Comparable[])new Boolean[]{true}).end();
        this.simpleBlockState((Block)BlocksAS.REFRACTION_TABLE, this.modelAS("refraction_table_particle"));
        this.multiLayerBlockState((Block)BlocksAS.RITUAL_LINK);
        this.multiLayerBlockState((Block)BlocksAS.RITUAL_PEDESTAL);
        this.multiLayerBlockState((Block)BlocksAS.ILLUMINATOR);
        this.multiLayerBlockState((Block)BlocksAS.INFUSER);
        this.simpleBlockState((Block)BlocksAS.CHALICE);
        this.simpleBlockState((Block)BlocksAS.TELESCOPE);
        this.simpleBlockState((Block)BlocksAS.OBSERVATORY);
        this.simpleBlockState((Block)BlocksAS.WELL);
        this.getVariantBuilder(BlocksAS.FLARE_LIGHT).forAllStates(state -> (ConfiguredModel[])ArrayUtils.toArray((Object[])new ConfiguredModel[]{new ConfiguredModel(this.modelNothing())}));
        this.simpleBlockState((Block)BlocksAS.TRANSLUCENT_BLOCK, this.modelNothing());
        this.simpleBlockState((Block)BlocksAS.VANISHING, this.modelNothing());
        this.getVariantBuilder(BlocksAS.STRUCTURAL).partialState().with(BlockStructural.BLOCK_TYPE, (Comparable)((Object)BlockStructural.BlockType.TELESCOPE)).addModels(new ConfiguredModel[]{new ConfiguredModel(this.model((IForgeRegistryEntry<?>)BlocksAS.TELESCOPE))}).partialState().with(BlockStructural.BLOCK_TYPE, (Comparable)((Object)BlockStructural.BlockType.DUMMY)).addModels(new ConfiguredModel[]{new ConfiguredModel(this.modelNothing())});
    }

    private <T extends Comparable<T>> void pillarModel(Block b, IProperty<T> pillarType, T middle, T top, T bottom) {
        ResourceLocation key = b.getRegistryName();
        this.getVariantBuilder(b).partialState().with(pillarType, middle).addModels(new ConfiguredModel[]{new ConfiguredModel(this.model(key))}).partialState().with(pillarType, top).addModels(new ConfiguredModel[]{new ConfiguredModel(this.model(NameUtil.suffixPath(key, "_top")))}).partialState().with(pillarType, bottom).addModels(new ConfiguredModel[]{new ConfiguredModel(this.model(NameUtil.suffixPath(key, "_bottom")))});
    }

    private <T extends Comparable<T>> void allStateSuffixModel(Block b) {
        Collection properties = b.func_176194_O().func_177623_d();
        if (properties.size() != 1) {
            throw new IllegalArgumentException("Can only make path-suffix enumeration for blockstates with exactly 1 property!");
        }
        ResourceLocation key = b.getRegistryName();
        IProperty property = (IProperty)Iterables.getFirst((Iterable)properties, null);
        VariantBlockStateBuilder builder = this.getVariantBuilder(b);
        for (Comparable value : property.func_177700_c()) {
            builder.partialState().with(property, value).addModels(new ConfiguredModel[]{new ConfiguredModel(this.model(NameUtil.suffixPath(key, "_" + value.toString())))});
        }
    }

    private <T extends Comparable<T>> void allStateSuffixMultiLayerModel(Block b) {
        Collection properties = b.func_176194_O().func_177623_d();
        if (properties.size() != 1) {
            throw new IllegalArgumentException("Can only make path-suffix enumeration for blockstates with exactly 1 property!");
        }
        ResourceLocation key = b.getRegistryName();
        IProperty property = (IProperty)Iterables.getFirst((Iterable)properties, null);
        VariantBlockStateBuilder builder = this.getVariantBuilder(b);
        for (Comparable value : property.func_177700_c()) {
            builder.partialState().with(property, value).addModels(new ConfiguredModel[]{new ConfiguredModel(this.multiLayerModel(NameUtil.suffixPath(key, "_" + value.toString())))});
        }
    }

    private void simpleSlabs(SlabBlock b, ModelFile doubleSlabModel) {
        ResourceLocation key = b.getRegistryName();
        this.slabBlock(b, this.model(key), this.model(NameUtil.suffixPath(key, "_top")), doubleSlabModel);
    }

    private void simpleStairs(StairsBlock b) {
        ResourceLocation key = b.getRegistryName();
        this.stairsBlock(b, this.model(key), this.model(NameUtil.suffixPath(key, "_inner")), this.model(NameUtil.suffixPath(key, "_outer")));
    }

    private void multiLayerBlockState(Block b) {
        this.simpleBlockState(b, this.multiLayerModel(b.getRegistryName()));
    }

    private void simpleBlockState(Block b) {
        this.simpleBlockState(b, this.model(b.getRegistryName()));
    }

    private void simpleBlockState(Block b, ModelFile targetModel) {
        this.getVariantBuilder(b).partialState().addModels(new ConfiguredModel[]{new ConfiguredModel(targetModel)});
    }

    private ModelFile modelNothing() {
        return this.modelAS("base/nothing");
    }

    private ModelFile modelAS(String name) {
        return this.model(AstralSorcery.key(name));
    }

    private ModelFile model(IForgeRegistryEntry<?> entry) {
        return this.model(entry.getRegistryName());
    }

    private ModelFile model(ResourceLocation name) {
        return new ModelFile.UncheckedModelFile(NameUtil.prefixPath(name, "block/"));
    }

    private ModelFile multiLayerModel(ResourceLocation name) {
        return new ModelFile.UncheckedModelFile(NameUtil.prefixPath(name, "block/multilayer/"));
    }
}

