/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.datagen.data.recipes.builder;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.CookingRecipeSerializer;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ResultCookingRecipeBuilder {
    private final ItemStack result;
    private final Ingredient ingredient;
    private final float experience;
    private final int cookingTime;
    private final CookingRecipeSerializer<?> recipeSerializer;

    private ResultCookingRecipeBuilder(ItemStack result, Ingredient ingredientIn, float experienceIn, int cookingTimeIn, CookingRecipeSerializer<?> serializer) {
        this.result = result.func_77946_l();
        this.ingredient = ingredientIn;
        this.experience = experienceIn;
        this.cookingTime = cookingTimeIn;
        this.recipeSerializer = serializer;
    }

    public static ResultCookingRecipeBuilder cookingRecipe(Ingredient ingredientIn, ItemStack result, float experienceIn, int cookingTimeIn, CookingRecipeSerializer<?> serializer) {
        return new ResultCookingRecipeBuilder(result, ingredientIn, experienceIn, cookingTimeIn, serializer);
    }

    public static ResultCookingRecipeBuilder blastingRecipe(Ingredient ingredientIn, ItemStack result, float experienceIn, int cookingTimeIn) {
        return ResultCookingRecipeBuilder.cookingRecipe(ingredientIn, result, experienceIn, cookingTimeIn, IRecipeSerializer.field_222172_p);
    }

    public static ResultCookingRecipeBuilder smeltingRecipe(Ingredient ingredientIn, ItemStack result, float experienceIn, int cookingTimeIn) {
        return ResultCookingRecipeBuilder.cookingRecipe(ingredientIn, result, experienceIn, cookingTimeIn, IRecipeSerializer.field_222171_o);
    }

    public void build(Consumer<IFinishedRecipe> consumerIn) {
        this.build(consumerIn, ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.result.func_77973_b()));
    }

    public void build(Consumer<IFinishedRecipe> consumerIn, String save) {
        ResourceLocation saveNameKey = new ResourceLocation(save);
        ResourceLocation itemKey = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.result.func_77973_b());
        if (saveNameKey.equals((Object)itemKey)) {
            throw new IllegalStateException("Recipe " + saveNameKey + " should remove its 'save' argument");
        }
        this.build(consumerIn, saveNameKey);
    }

    public void build(Consumer<IFinishedRecipe> consumerIn, ResourceLocation id) {
        id = new ResourceLocation(id.func_110624_b(), this.recipeSerializer.getRegistryName().func_110623_a() + "/" + id.func_110623_a());
        consumerIn.accept(new Result(id, this.ingredient, this.result, this.experience, this.cookingTime, (IRecipeSerializer<? extends AbstractCookingRecipe>)this.recipeSerializer));
    }

    public static class Result
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final Ingredient ingredient;
        private final ItemStack result;
        private final float experience;
        private final int cookingTime;
        private final IRecipeSerializer<? extends AbstractCookingRecipe> serializer;

        public Result(ResourceLocation idIn, Ingredient ingredientIn, ItemStack resultIn, float experienceIn, int cookingTimeIn, IRecipeSerializer<? extends AbstractCookingRecipe> serializerIn) {
            this.id = idIn;
            this.ingredient = ingredientIn;
            this.result = resultIn;
            this.experience = experienceIn;
            this.cookingTime = cookingTimeIn;
            this.serializer = serializerIn;
        }

        public void func_218610_a(JsonObject json) {
            JsonObject itemResult = new JsonObject();
            itemResult.addProperty("item", this.result.func_77973_b().getRegistryName().toString());
            itemResult.addProperty("count", (Number)this.result.func_190916_E());
            json.add("ingredient", this.ingredient.func_200304_c());
            json.add("result", (JsonElement)itemResult);
            json.addProperty("experience", (Number)Float.valueOf(this.experience));
            json.addProperty("cookingtime", (Number)this.cookingTime);
        }

        public IRecipeSerializer<?> func_218609_c() {
            return this.serializer;
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return null;
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return new ResourceLocation("");
        }
    }
}

