/*
 * Decompiled with CFR 0.152.
 */
package autoswitch;

import autoswitch.AutoSwitch;
import autoswitch.TargetableEntity;
import autoswitch.TargetableMaterial;
import autoswitch.TargetableNone;
import autoswitch.TargetableUsable;
import autoswitch.config.AutoSwitchConfig;
import autoswitch.config.ToolHandler;
import autoswitch.util.SwitchDataStorage;
import autoswitch.util.TargetableUtil;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2680;
import org.apache.commons.lang3.tuple.Pair;

@Environment(value=EnvType.CLIENT)
abstract class Targetable {
    ConcurrentHashMap<Object, CopyOnWriteArrayList<UUID>> toolTargetLists;
    Map<UUID, CopyOnWriteArrayList<Integer>> toolLists;
    ConcurrentHashMap<Integer, Double> toolRating;
    class_1657 player;
    AutoSwitchConfig cfg;
    Boolean onMP;

    public Targetable(class_1657 player, Boolean onMP) {
        this.toolTargetLists = AutoSwitch.data.toolTargetLists;
        this.toolLists = Collections.synchronizedMap(AutoSwitch.data.toolLists);
        this.toolRating = new ConcurrentHashMap();
        this.cfg = AutoSwitch.cfg;
        this.onMP = onMP != null ? onMP : false;
        this.player = player;
    }

    static Targetable of(class_1297 target, class_1657 player, Boolean onMP) {
        return new TargetableEntity(target, player, onMP);
    }

    static Targetable of(class_2680 target, class_1657 player, Boolean onMP) {
        return new TargetableMaterial(target, player, onMP);
    }

    static Targetable use(Object protoTarget, class_1657 player, Boolean onMP) {
        return new TargetableUsable(player, onMP, protoTarget);
    }

    static Targetable of(int prevSlot, class_1657 player) {
        return new TargetableNone(prevSlot, player);
    }

    public void populateToolLists(class_1657 player) {
        List hotbar = player.field_7514.field_7547.subList(0, class_1661.method_7368());
        for (int slot = 0; slot < class_1661.method_7368(); ++slot) {
            if ((!AutoSwitch.cfg.useNoDurablityItemsWhenUnspecified().booleanValue() || ((class_1799)hotbar.get(slot)).method_7936() != 0) && ((class_1799)hotbar.get(slot)).method_7936() - ((class_1799)hotbar.get(slot)).method_7919() < 3 && this.cfg.tryPreserveDamagedTools().booleanValue()) continue;
            this.populateToolSelection((class_1799)hotbar.get(slot), slot);
        }
    }

    public Optional<Boolean> changeTool() {
        return this.findSlot().map(slot -> {
            int currentSlot = this.player.field_7514.field_7545;
            if (slot == currentSlot) {
                return Optional.of(false);
            }
            for (int i = Math.abs(currentSlot - slot); i > 0; --i) {
                this.player.field_7514.method_7373((double)(currentSlot - slot));
            }
            return Optional.of(true);
        }).orElseGet(Optional::empty);
    }

    protected Boolean switchAllowed() {
        return !(this.player.method_7337() && this.cfg.switchInCreative() == false || this.switchTypeAllowed() == false || this.onMP != false && this.cfg.switchInMP() == false);
    }

    abstract void populateToolSelection(class_1799 var1, int var2);

    Optional<Integer> findSlot() {
        if (this.toolRating.isEmpty() || !this.switchAllowed().booleanValue()) {
            return Optional.empty();
        }
        AutoSwitch.logger.debug(this.toolRating);
        for (Map.Entry<UUID, CopyOnWriteArrayList<Integer>> toolList : this.toolLists.entrySet()) {
            if (toolList.getValue().isEmpty()) continue;
            for (Integer slot : toolList.getValue()) {
                if (!slot.equals(Collections.max(this.toolRating.entrySet(), Comparator.comparingDouble(Map.Entry::getValue)).getKey())) continue;
                return Optional.of(slot);
            }
        }
        return Optional.empty();
    }

    void populateToolSelectionCore(Object protoTarget, class_1799 stack, int slot) {
        class_1792 item = stack.method_7909();
        AtomicReference<Float> counter = new AtomicReference<Float>(Float.valueOf(class_1661.method_7368()));
        Object target = TargetableUtil.getTarget(protoTarget);
        if (!AutoSwitch.cfg.useNoDurablityItemsWhenUnspecified().booleanValue() && this.toolTargetLists.get(target) == null) {
            return;
        }
        this.toolTargetLists.getOrDefault(target, SwitchDataStorage.blank).forEach(uuid -> {
            class_1887 enchant;
            String tool;
            if (uuid == null) {
                return;
            }
            counter.updateAndGet(v -> Float.valueOf((float)((double)v.floatValue() - 0.25)));
            if (uuid != SwitchDataStorage.blank.get(0)) {
                Pair<String, class_1887> pair = AutoSwitch.data.enchantToolMap.get(uuid);
                tool = (String)pair.getLeft();
                enchant = (class_1887)pair.getRight();
            } else {
                tool = "blank";
                enchant = null;
            }
            if (ToolHandler.correctType(tool, item) && TargetableUtil.isRightTool(stack, protoTarget)) {
                new TargetableMapUtil().updateToolListsAndRatings(stack, (UUID)uuid, tool, enchant, slot, protoTarget, counter, false);
            }
        });
    }

    abstract Boolean switchTypeAllowed();

    class TargetableMapUtil {
        TargetableMapUtil() {
        }

        public void updateToolListsAndRatings(class_1799 stack, UUID uuid, String tool, class_1887 enchant, int slot, Object protoTarget, AtomicReference<Float> counter, boolean useAction) {
            double rating = 0.0;
            boolean stackEnchants = true;
            if (enchant == null) {
                rating += 1.0;
                stackEnchants = false;
            } else if (class_1890.method_8225((class_1887)enchant, (class_1799)stack) > 0) {
                rating += (double)class_1890.method_8225((class_1887)enchant, (class_1799)stack);
            } else {
                return;
            }
            Targetable.this.toolLists.putIfAbsent(uuid, new CopyOnWriteArrayList());
            Targetable.this.toolLists.get(uuid).add(slot);
            if (!useAction) {
                if (Targetable.this.cfg.preferMinimumViableTool().booleanValue()) {
                    rating += -1.0 * Math.log10(rating);
                }
                rating += (double)(TargetableUtil.getTargetRating(protoTarget, stack) + counter.get().floatValue());
                if (!tool.equals("blank") && stack.method_7909().method_7841() == 0) {
                    rating = 0.1;
                }
            }
            if (Targetable.this.player.field_7514.field_7545 == slot) {
                rating += 0.1;
            }
            double finalRating = rating;
            boolean finalStackEnchants = stackEnchants;
            AutoSwitch.logger.debug("Rating: {}; Slot: {}", (Object)rating, (Object)slot);
            Targetable.this.toolRating.computeIfPresent(slot, (iSlot, oldRating) -> TargetableUtil.toolRatingChange(oldRating, finalRating, stack, finalStackEnchants));
            Targetable.this.toolRating.putIfAbsent(slot, rating);
        }
    }
}

