/*
 * Decompiled with CFR 0.152.
 */
package autoswitch.config;

import autoswitch.config.Comment;
import org.aeonbits.owner.Accessible;
import org.aeonbits.owner.Config;
import org.aeonbits.owner.Reloadable;

@Config.HotReload(type=Config.HotReloadType.ASYNC, value=1L)
@Config.Sources(value={"file:${configDir}"})
public interface AutoSwitchConfig
extends Config,
Reloadable,
Accessible {
    @Config.DefaultValue(value="true")
    @Comment(value="Display toggle message above hotbar. Set to false for normal chat message.")
    public Boolean toggleMsgOverHotbar();

    @Config.DefaultValue(value="true")
    @Comment(value="Display toggle message, set to false to remove it.")
    public Boolean displayToggleMsg();

    @Config.DefaultValue(value="false")
    @Comment(value="AutoSwitch functionality in creative mode.")
    public Boolean switchInCreative();

    @Config.DefaultValue(value="true")
    @Comment(value="AutoSwitch for mining.")
    public Boolean switchForBlocks();

    @Config.DefaultValue(value="true")
    @Comment(value="AutoSwitch for attacking mobs.")
    public Boolean switchForMobs();

    @Config.DefaultValue(value="true")
    @Comment(value="Allow AutoSwitch when in multiplayer.")
    public Boolean switchInMP();

    @Config.DefaultValue(value="true")
    @Comment(value="Return to previous slot when not attacking a block.")
    public Boolean switchbackBlocks();

    @Config.DefaultValue(value="true")
    @Comment(value="Return to previous slot after attacking a mob.")
    public Boolean switchbackMobs();

    @Config.DefaultValue(value="true")
    @Comment(value="Let AutoSwitch prevent breaking a block with an empty collision box (ie. tall grass) when trying to attack a mob.")
    public Boolean controlMowingWhenFighting();

    @Config.DefaultValue(value="true")
    @Comment(value="Disable the swinging of the hand when trying to mow when fighting.")
    public Boolean disableHandSwingWhenMowing();

    @Config.Separator(value=">")
    @Config.DefaultValue(value="sword > axe > pickaxe")
    public String[] toolPriorityOrder();

    @Config.DefaultValue(value="true")
    @Config.Key(value="switchbackWaitsForCooldownWhenAttackingMobs")
    @Comment(value="Before switching back when fighting a mob, wait for the attack cooldown to finish. Fixes attacks not doing a lot of damage.")
    public Boolean switchbackWaits();

    @Config.DefaultValue(value="true")
    @Comment(value="Will ignore tools that are about to break when considering which tool to switch to.")
    public Boolean tryPreserveDamagedTools();

    @Config.DefaultValue(value="true")
    @Comment(value="Switch used tool to offhand.")
    public Boolean putUseActionToolInOffHand();

    @Config.DefaultValue(value="true")
    @Comment(value="Switch for use-action of a tool.")
    public Boolean switchUseActions();

    @Config.DefaultValue(value="true")
    @Comment(value="Prefer tool with minimum mining level.")
    public Boolean preferMinimumViableTool();

    @Config.DefaultValue(value="true")
    @Comment(value="Checks if a saddlable entity has a saddle for use action to switch. Does not allow switching to a saddle on hotbar.")
    public Boolean checkSaddlableEntitiesForSaddle();

    @Config.DefaultValue(value="true")
    @Comment(value="Enable dumb check for tool harvestablity on the targeted block.")
    public Boolean dumbMiningLevelCheck();

    @Config.DefaultValue(value="true")
    @Comment(value="Enable switching to items with no durability when no tool is found.")
    public Boolean useNoDurablityItemsWhenUnspecified();

    @Config.DefaultValue(value="true")
    @Comment(value="Enable to allow target list to stack enchantments. Disable for old behavior.")
    public Boolean toolEnchantmentsStack();

    @Config.DefaultValue(value="false")
    public Boolean disableModMenuConfig();

    @Config.DefaultValue(value="false")
    @Comment(value="Tools with enchantments that increase attack damage will be rated higher. This means an axe with sharpness can be preferred over a sword.Set to true to enable this functionality. False ignores the enchantments.")
    public Boolean weaponRatingIncludesEnchants();

    @Config.DefaultValue(value="false")
    @Comment(value="Will force use of the toggle key in order to enable switching")
    public Boolean disableSwitchingOnStartup();
}

