/*
 * Decompiled with CFR 0.152.
 */
package autoswitch.config;

import autoswitch.AutoSwitch;
import autoswitch.config.AutoSwitchConfig;
import autoswitch.config.AutoSwitchMapsGenerator;
import autoswitch.config.AutoSwitchMaterialConfig;
import autoswitch.config.AutoSwitchUsableConfig;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import org.aeonbits.owner.ConfigFactory;

public final class ConfigEstablishment {
    public ConfigEstablishment() {
        String config = FabricLoader.getInstance().getConfigDirectory().toString() + "/autoswitch.cfg";
        String configMats = FabricLoader.getInstance().getConfigDirectory().toString() + "/autoswitchMaterials.cfg";
        String configUsable = FabricLoader.getInstance().getConfigDirectory().toString() + "/autoswitchUsable.cfg";
        ConfigFactory.setProperty((String)"configDir", (String)config);
        ConfigFactory.setProperty((String)"configDirMats", (String)configMats);
        ConfigFactory.setProperty((String)"configUsable", (String)configUsable);
        AutoSwitch.cfg = (AutoSwitchConfig)ConfigFactory.create(AutoSwitchConfig.class, (Map[])new Map[0]);
        AutoSwitch.matCfg = (AutoSwitchMaterialConfig)ConfigFactory.create(AutoSwitchMaterialConfig.class, (Map[])new Map[0]);
        AutoSwitch.usableCfg = (AutoSwitchUsableConfig)ConfigFactory.create(AutoSwitchUsableConfig.class, (Map[])new Map[0]);
        try {
            AutoSwitch.cfg.store(new FileOutputStream(config), "AutoSwitch Configuration File\nSee https://github.com/dexman545/Fabric-Autoswitch/wiki/Configuration for more details\nTool priority order values must match exactly with what is in the material config, both tool and enchantment");
            AutoSwitch.matCfg.store(new FileOutputStream(configMats), "AutoSwitch Material Configuration File\nformat is a comma separated list of 'toolname[;enchantment id]', where toolname is any:\n\t any, pickaxe, shears, axe, shovel, hoe, trident, sword, or a specific item id, with same formatting rules as enchantments\nEnchant id is optional. If present, it must be separated from the tool by a semicolon (';')\nEnchant id uses '-' instead of colons. A colon can be used, but must be preceded by a backslash\nList is ordered and will effect tool selection\nYou can cadd block/mob-specific overrides by adding it's id on a new line and adding values to the right of\nthe equals sign ('=') as you would normally. Check the boat for an example.\nRemoving the values after the equals sign will disable the switch. In the case of overrides, the line may be removed.");
            AutoSwitch.usableCfg.store(new FileOutputStream(configUsable), "AutoSwitch Usable Configuration File\nThis file defines tool switching targets for the 'use' action (right clicking) on a mob or block.\nSame format as the Material Config:\nformat is a comma separated list of 'toolname[;enchantment id]', where toolname is any:\n\t specific item id, with same formatting rules as enchantments\nEnchant id is optional. If present, it must be separated from the tool by a semicolon (';')\nEnchant id uses '-' instead of colons. A colon can be used, but must be preceded by a backslash\nList is ordered and will effect tool selection\nTo add mobs or blocks you wish to target, simply enter their id on a new line, followed by an '=' and the id of the tool you want to be used.\nRRemoving the values after the equals sign will disable the switch. In case of user added targets, removing the line will also work.");
        }
        catch (IOException e) {
            AutoSwitch.logger.error("AutoSwitch failed to obtain the configs during writing!");
            AutoSwitch.logger.error((Object)e);
        }
        AutoSwitch.matCfg.addReloadListener(event -> {
            AutoSwitch.data.toolTargetLists.clear();
            AutoSwitch.data.enchantToolMap.clear();
            new AutoSwitchMapsGenerator();
        });
        AutoSwitch.cfg.addReloadListener(event -> {
            AutoSwitch.data.toolLists.clear();
            new AutoSwitchMapsGenerator();
        });
        AutoSwitch.usableCfg.addReloadListener(event -> {
            AutoSwitch.data.enchantToolMap.clear();
            AutoSwitch.data.useMap.clear();
            new AutoSwitchMapsGenerator();
        });
    }
}

