/*
 * Decompiled with CFR 0.152.
 */
package autoswitch.config;

import autoswitch.AutoSwitch;
import autoswitch.config.MaterialHandler;
import autoswitch.config.ToolHandler;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.aeonbits.owner.Accessible;

@Environment(value=EnvType.CLIENT)
public class AutoSwitchMapsGenerator {
    public AutoSwitchMapsGenerator() {
        this.populateToolTargetMaps();
        this.populateToolListMap(AutoSwitch.data.toolLists);
    }

    private void populateToolTargetMaps() {
        this.populateMap(AutoSwitch.data.toolTargetLists, AutoSwitch.matCfg);
        this.populateMap(AutoSwitch.data.useMap, AutoSwitch.usableCfg);
    }

    private void populateMap(ConcurrentHashMap<Object, ArrayList<UUID>> map, Accessible cfg) {
        for (String key : cfg.propertyNames()) {
            String raw = cfg.getProperty(key);
            String[] split = raw.split(",");
            ArrayList<UUID> list = new ArrayList<UUID>();
            for (String input : split) {
                UUID x = new ToolHandler(input).getId();
                if (x == null) continue;
                list.add(x);
            }
            if (list.isEmpty() || new MaterialHandler(key).getMat() == null) continue;
            map.put(new MaterialHandler(key).getMat(), list);
        }
    }

    private void populateToolListMap(Map<UUID, ArrayList<Integer>> toolLists) {
        if (AutoSwitch.cfg.toolPriorityOrder() == null) {
            return;
        }
        for (String type : AutoSwitch.cfg.toolPriorityOrder()) {
            toolLists.put(new ToolHandler(type).getId(), new ArrayList());
        }
    }
}

