/*
 * Decompiled with CFR 0.152.
 */
package autoswitch.config;

import autoswitch.AutoSwitch;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.tool.attribute.v1.FabricToolTags;
import net.minecraft.class_1743;
import net.minecraft.class_1792;
import net.minecraft.class_1794;
import net.minecraft.class_1810;
import net.minecraft.class_1820;
import net.minecraft.class_1821;
import net.minecraft.class_1829;
import net.minecraft.class_1835;
import net.minecraft.class_1887;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import org.apache.commons.lang3.tuple.Pair;

@Environment(value=EnvType.CLIENT)
public class ToolHandler {
    private UUID id = null;

    public ToolHandler(String input) {
        String[] cleanedInput = input.split(";");
        String tagStr = cleanedInput[0].toLowerCase().trim().replace("-", ":");
        String enchantStr = cleanedInput.length > 1 ? cleanedInput[1].toLowerCase().trim().replace("-", ":") : "";
        class_1887 enchant = null;
        class_2960 enchantID = class_2960.method_12829((String)enchantStr);
        if (this.getTool(tagStr).equals("")) {
            AutoSwitch.logger.debug("Empty Tool Entry tried to parse");
        } else {
            this.id = UUID.nameUUIDFromBytes(input.getBytes());
            if (!class_2378.field_11160.method_10250(enchantID)) {
                if (!enchantStr.equals("")) {
                    AutoSwitch.logger.warn("Enchantment not found in registry: " + enchantStr);
                }
            } else {
                enchant = (class_1887)class_2378.field_11160.method_10223(enchantID);
            }
            AutoSwitch.logger.debug("Adding item to toolmap... " + input);
            AutoSwitch.data.enchantToolMap.put(this.id, (Pair<String, class_1887>)Pair.of((Object)tagStr, (Object)enchant));
        }
    }

    public static boolean correctType(String tool, class_1792 item) {
        if (AutoSwitch.cfg.useNoDurablityItemsWhenUnspecified().booleanValue() && item.method_7841() == 0) {
            return true;
        }
        if ((tool.equals("pickaxe") || tool.equals("any")) && (FabricToolTags.PICKAXES.method_15141((Object)item) || item instanceof class_1810)) {
            return true;
        }
        if ((tool.equals("shovel") || tool.equals("any")) && (FabricToolTags.SHOVELS.method_15141((Object)item) || item instanceof class_1821)) {
            return true;
        }
        if ((tool.equals("hoe") || tool.equals("any")) && (FabricToolTags.HOES.method_15141((Object)item) || item instanceof class_1794)) {
            return true;
        }
        if ((tool.equals("shears") || tool.equals("any")) && (FabricToolTags.SHEARS.method_15141((Object)item) || item instanceof class_1820)) {
            return true;
        }
        if ((tool.equals("trident") || tool.equals("any")) && item instanceof class_1835) {
            return true;
        }
        if ((tool.equals("axe") || tool.equals("any")) && (FabricToolTags.AXES.method_15141((Object)item) || item instanceof class_1743)) {
            return true;
        }
        if ((tool.equals("sword") || tool.equals("any")) && (FabricToolTags.SWORDS.method_15141((Object)item) || item instanceof class_1829)) {
            return true;
        }
        return class_2378.field_11142.method_10221((Object)item).equals((Object)class_2960.method_12829((String)tool));
    }

    public static boolean correctUseType(String tool, class_1792 item) {
        return class_2378.field_11142.method_10221((Object)item).equals((Object)class_2960.method_12829((String)tool));
    }

    private String getTool(String t) {
        switch (t) {
            default: 
        }
        return class_2960.method_12829((String)t) != null ? t : "";
    }

    public UUID getId() {
        return this.id;
    }
}

