/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.mrcrayfish.backpacked.asm.BackpackedPlugin;
import com.mrcrayfish.backpacked.client.ClientEvents;
import com.mrcrayfish.backpacked.core.ModItems;
import com.mrcrayfish.backpacked.core.ModModels;
import com.mrcrayfish.backpacked.integration.Baubles;
import com.mrcrayfish.backpacked.inventory.ExtendedPlayerInventory;
import com.mrcrayfish.backpacked.inventory.container.ExtendedPlayerContainer;
import com.mrcrayfish.backpacked.network.PacketHandler;
import com.mrcrayfish.backpacked.network.message.MessageUpdateBackpack;
import com.mrcrayfish.backpacked.proxy.CommonProxy;
import java.io.File;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.client.FMLFileResourcePack;
import net.minecraftforge.fml.client.FMLFolderResourcePack;
import net.minecraftforge.fml.common.DummyModContainer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.LoadController;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModClassLoader;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Backpacked
extends DummyModContainer {
    public static final Logger LOGGER = LogManager.getLogger((String)"Backpacked");
    public static final ResourceLocation EMPTY_BACKPACK_SLOT = new ResourceLocation("backpacked", "items/empty_backpack_slot");
    private static boolean baublesLoaded;
    public static Backpacked instance;
    public static CommonProxy proxy;

    public Backpacked() {
        super(new ModMetadata());
        ModMetadata meta = this.getMetadata();
        meta.modId = "backpacked";
        meta.name = "Backpacked";
        meta.version = "1.4.0";
        meta.authorList = Collections.singletonList("MrCrayfish");
        meta.url = "https://mrcrayfish.com/mod?id=backpacked";
        instance = this;
    }

    public boolean registerBus(EventBus bus, LoadController controller) {
        bus.register((Object)this);
        return true;
    }

    public File getSource() {
        return BackpackedPlugin.LOCATION;
    }

    public Class<?> getCustomResourcePackClass() {
        return this.getSource().isDirectory() ? FMLFolderResourcePack.class : FMLFileResourcePack.class;
    }

    @Subscribe
    public void onModConstruct(FMLConstructionEvent event) {
        ConfigManager.sync((String)this.getModId(), (Config.Type)Config.Type.INSTANCE);
        try {
            ModClassLoader mcl = Loader.instance().getModClassLoader();
            Side side = FMLCommonHandler.instance().getEffectiveSide();
            switch (side) {
                case CLIENT: {
                    proxy = (CommonProxy)Class.forName("com.mrcrayfish.backpacked.proxy.ClientProxy", true, (ClassLoader)mcl).newInstance();
                    break;
                }
                case SERVER: {
                    proxy = (CommonProxy)Class.forName("com.mrcrayfish.backpacked.proxy.CommonProxy", true, (ClassLoader)mcl).newInstance();
                }
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
    }

    @Subscribe
    public void preInit(FMLPreInitializationEvent event) {
        baublesLoaded = Loader.isModLoaded((String)"baubles");
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new ModItems());
        if (baublesLoaded) {
            MinecraftForge.EVENT_BUS.register((Object)new Baubles());
        }
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            MinecraftForge.EVENT_BUS.register((Object)new ModModels());
            MinecraftForge.EVENT_BUS.register((Object)new ClientEvents());
        }
        ModItems.init();
    }

    @Subscribe
    public void init(FMLInitializationEvent event) {
        proxy.setupClient();
        PacketHandler.init();
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onTextureStitch(TextureStitchEvent.Pre event) {
        if (!baublesLoaded && event.getMap() == Minecraft.func_71410_x().func_147117_R()) {
            event.getMap().func_174942_a(EMPTY_BACKPACK_SLOT);
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        EntityPlayer oldPlayer = event.getOriginal();
        if (baublesLoaded) {
            Baubles.setBackpackStack(event.getEntityPlayer(), Baubles.getBackpackStack(oldPlayer));
        } else if (oldPlayer.field_71071_by instanceof ExtendedPlayerInventory && event.getEntityPlayer().field_71071_by instanceof ExtendedPlayerInventory) {
            ((ExtendedPlayerInventory)event.getEntityPlayer().field_71071_by).copyBackpack((ExtendedPlayerInventory)oldPlayer.field_71071_by);
        }
    }

    @SubscribeEvent
    public void onStartTracking(PlayerEvent.StartTracking event) {
        if (baublesLoaded) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        if (player.field_71071_by instanceof ExtendedPlayerInventory && !((ItemStack)((ExtendedPlayerInventory)player.field_71071_by).getBackpackItems().get(0)).func_190926_b()) {
            PacketHandler.INSTANCE.sendToAllTracking((IMessage)new MessageUpdateBackpack(player.func_145782_y(), true), (Entity)player);
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (baublesLoaded) {
            return;
        }
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        EntityPlayer player = event.player;
        if (!player.field_70170_p.field_72995_K && player.field_71071_by instanceof ExtendedPlayerInventory) {
            ExtendedPlayerInventory inventory = (ExtendedPlayerInventory)player.field_71071_by;
            if (!((ItemStack)inventory.backpackArray.get(0)).equals(inventory.backpackInventory.get(0))) {
                PacketHandler.INSTANCE.sendToAllTracking((IMessage)new MessageUpdateBackpack(player.func_145782_y(), true), (Entity)player);
                inventory.backpackArray.set(0, inventory.backpackInventory.get(0));
            }
        }
    }

    public static void onPlayerInit(EntityPlayer player) {
        if (baublesLoaded) {
            return;
        }
        Backpacked.patchInventory(player);
    }

    private static void patchInventory(EntityPlayer player) {
        player.field_71071_by = new ExtendedPlayerInventory(player);
        player.field_71070_bA = player.field_71069_bz = new ExtendedPlayerContainer(player.field_71071_by, !player.field_70170_p.field_72995_K, player);
    }

    @SideOnly(value=Side.CLIENT)
    public static void patchCreativeSlots(GuiContainerCreative.ContainerCreative creativeContainer) {
        if (baublesLoaded) {
            return;
        }
        creativeContainer.field_75151_b.stream().filter(slot -> slot.field_75224_c instanceof ExtendedPlayerInventory && slot.getSlotIndex() == 41).findFirst().ifPresent(slot -> {
            slot.field_75223_e = 127;
            slot.field_75221_f = 20;
        });
    }

    public static int getCreativeSlotMax(EntityPlayerMP player) {
        if (!baublesLoaded && player.field_71071_by instanceof ExtendedPlayerInventory) {
            return 46;
        }
        return 45;
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawBackgroundLayer(GuiContainer screen) {
        GuiContainerCreative guiContainerCreative;
        if (baublesLoaded) {
            return;
        }
        if (screen instanceof GuiInventory) {
            GuiInventory guiInventory = (GuiInventory)screen;
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int left = guiInventory.getGuiLeft();
            int top = guiInventory.getGuiTop();
            guiInventory.field_146297_k.func_110434_K().func_110577_a(GuiContainer.field_147001_a);
            guiInventory.func_73729_b(left + 76, top + 43, 76, 61, 18, 18);
        } else if (screen instanceof GuiContainerCreative && (guiContainerCreative = (GuiContainerCreative)screen).func_147056_g() == CreativeTabs.field_78036_m.func_78021_a()) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int left = guiContainerCreative.getGuiLeft();
            int top = guiContainerCreative.getGuiTop();
            guiContainerCreative.field_146297_k.func_110434_K().func_110577_a(GuiContainer.field_147001_a);
            guiContainerCreative.func_73729_b(left + 126, top + 19, 76, 61, 18, 18);
        }
    }

    public static ItemStack getBackpackStack(EntityPlayer player) {
        AtomicReference<ItemStack> backpack = new AtomicReference<ItemStack>(ItemStack.field_190927_a);
        if (baublesLoaded) {
            backpack.set(Baubles.getBackpackStack(player));
        } else if (player.field_71071_by instanceof ExtendedPlayerInventory) {
            ExtendedPlayerInventory inventory = (ExtendedPlayerInventory)player.field_71071_by;
            backpack.set((ItemStack)inventory.getBackpackItems().get(0));
        }
        return backpack.get();
    }

    public static boolean isBaublesLoaded() {
        return baublesLoaded;
    }
}

