/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.integration;

import com.mrcrayfish.backpacked.Config;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import top.theillusivec4.curios.api.CuriosAPI;
import top.theillusivec4.curios.api.capability.ICurio;
import top.theillusivec4.curios.common.capability.CapCurioItem;

public class Curios {
    public static ItemStack getBackpackStack(PlayerEntity player) {
        AtomicReference<ItemStack> backpack = new AtomicReference<ItemStack>(ItemStack.field_190927_a);
        LazyOptional optional = CuriosAPI.getCuriosHandler((LivingEntity)player);
        optional.ifPresent(handler -> backpack.set(handler.getStackInSlot("backpacked", 0)));
        return backpack.get();
    }

    public static ICapabilityProvider createBackpackProvider() {
        return CapCurioItem.createProvider((ICurio)new ICurio(){

            public void playEquipSound(LivingEntity entity) {
                entity.field_70170_p.func_184148_a((PlayerEntity)null, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), SoundEvents.field_187728_s, SoundCategory.PLAYERS, 1.0f, 1.0f);
            }

            public boolean canRightClickEquip() {
                return true;
            }

            public boolean shouldSyncToTracking(String identifier, LivingEntity livingEntity) {
                return true;
            }

            @Nonnull
            public ICurio.DropRule getDropRule(LivingEntity livingEntity) {
                return (Boolean)Config.COMMON.keepBackpackOnDeath.get() != false ? ICurio.DropRule.ALWAYS_KEEP : ICurio.DropRule.DEFAULT;
            }
        });
    }
}

