/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.inventory.ExtendedPlayerInventory;
import com.mrcrayfish.backpacked.inventory.container.ExtendedPlayerContainer;
import com.mrcrayfish.backpacked.network.PacketHandler;
import com.mrcrayfish.backpacked.network.message.MessageUpdateBackpack;
import com.mrcrayfish.backpacked.proxy.ClientProxy;
import com.mrcrayfish.backpacked.proxy.CommonProxy;
import java.lang.reflect.Field;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.screen.inventory.CreativeScreen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.GuiContainerEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.PacketDistributor;

@Mod(value="backpacked")
public class Backpacked {
    public static final ResourceLocation EMPTY_BACKPACK_SLOT = new ResourceLocation("backpacked", "item/empty_backpack_slot");
    public static final CommonProxy PROXY = (CommonProxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> CommonProxy::new);
    private static boolean curiosLoaded = false;
    private static Field xPosField;
    private static Field yPosField;
    private static Field inventoryField;
    private static Field containerField;

    public Backpacked() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onCommonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onClientSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onEnqueueIMC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, Config.commonSpec);
        curiosLoaded = ModList.get().isLoaded("curios");
    }

    private void onCommonSetup(FMLCommonSetupEvent event) {
        PacketHandler.init();
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        PROXY.setupClient();
    }

    private void onEnqueueIMC(InterModEnqueueEvent event) {
        if (!curiosLoaded) {
            return;
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onPlayerRenderScreen(GuiContainerEvent.DrawBackground event) {
        CreativeScreen creativeScreen;
        if (curiosLoaded) {
            return;
        }
        ContainerScreen screen = event.getGuiContainer();
        if (screen instanceof InventoryScreen) {
            InventoryScreen inventoryScreen = (InventoryScreen)screen;
            int left = inventoryScreen.getGuiLeft();
            int top = inventoryScreen.getGuiTop();
            inventoryScreen.getMinecraft().func_110434_K().func_110577_a(ContainerScreen.field_147001_a);
            Screen.func_238463_a_((MatrixStack)event.getMatrixStack(), (int)(left + 76), (int)(top + 43), (float)7.0f, (float)7.0f, (int)18, (int)18, (int)256, (int)256);
        } else if (screen instanceof CreativeScreen && (creativeScreen = (CreativeScreen)screen).func_147056_g() == ItemGroup.field_78036_m.func_78021_a()) {
            int left = creativeScreen.getGuiLeft();
            int top = creativeScreen.getGuiTop();
            creativeScreen.getMinecraft().func_110434_K().func_110577_a(ContainerScreen.field_147001_a);
            Screen.func_238463_a_((MatrixStack)event.getMatrixStack(), (int)(left + 126), (int)(top + 19), (float)7.0f, (float)7.0f, (int)18, (int)18, (int)256, (int)256);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onTextureStitch(TextureStitchEvent.Pre event) {
        if (event.getMap().func_229223_g_().equals((Object)PlayerContainer.field_226615_c_)) {
            event.addSprite(EMPTY_BACKPACK_SLOT);
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        if (curiosLoaded) {
            return;
        }
        PlayerEntity oldPlayer = event.getOriginal();
        if (oldPlayer.field_71071_by instanceof ExtendedPlayerInventory && event.getPlayer().field_71071_by instanceof ExtendedPlayerInventory) {
            ((ExtendedPlayerInventory)event.getPlayer().field_71071_by).copyBackpack((ExtendedPlayerInventory)oldPlayer.field_71071_by);
        }
    }

    @SubscribeEvent
    public void onStartTracking(PlayerEvent.StartTracking event) {
        if (curiosLoaded) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        if (player.field_71071_by instanceof ExtendedPlayerInventory && !((ItemStack)((ExtendedPlayerInventory)player.field_71071_by).getBackpackItems().get(0)).func_190926_b()) {
            PacketHandler.instance.send(PacketDistributor.TRACKING_ENTITY.with(() -> player), (Object)new MessageUpdateBackpack(player.func_145782_y(), true));
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (curiosLoaded) {
            return;
        }
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        PlayerEntity player = event.player;
        if (!player.field_70170_p.field_72995_K && player.field_71071_by instanceof ExtendedPlayerInventory) {
            ExtendedPlayerInventory inventory = (ExtendedPlayerInventory)player.field_71071_by;
            if (!((ItemStack)inventory.backpackArray.get(0)).equals(inventory.backpackInventory.get(0))) {
                PacketHandler.instance.send(PacketDistributor.TRACKING_ENTITY.with(() -> player), (Object)new MessageUpdateBackpack(player.func_145782_y(), !((ItemStack)inventory.backpackInventory.get(0)).func_190926_b()));
                inventory.backpackArray.set(0, inventory.backpackInventory.get(0));
            }
        }
    }

    public static void onPlayerInit(PlayerEntity player) {
        if (curiosLoaded) {
            return;
        }
        Backpacked.patchInventory(player);
    }

    private static void patchInventory(PlayerEntity player) {
        if (inventoryField == null) {
            inventoryField = Backpacked.getFieldAndSetAccessible(PlayerEntity.class, "field_71071_by");
        }
        if (containerField == null) {
            containerField = Backpacked.getFieldAndSetAccessible(PlayerEntity.class, "field_71069_bz");
        }
        try {
            ExtendedPlayerInventory inventory = new ExtendedPlayerInventory(player);
            inventoryField.set(player, (Object)inventory);
            ExtendedPlayerContainer container = new ExtendedPlayerContainer(inventory, !player.field_70170_p.field_72995_K, player);
            containerField.set(player, (Object)container);
            player.field_71070_bA = container;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private static Field getFieldAndSetAccessible(Class clazz, String obfName) {
        Field field = ObfuscationReflectionHelper.findField((Class)clazz, (String)obfName);
        field.setAccessible(true);
        try {
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
        return field;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void patchCreativeSlots(CreativeScreen.CreativeContainer creativeContainer) {
        if (curiosLoaded) {
            return;
        }
        creativeContainer.field_75151_b.stream().filter(slot -> slot.field_75224_c instanceof ExtendedPlayerInventory && slot.getSlotIndex() == 41).findFirst().ifPresent(slot -> Backpacked.setSlotPosition(slot, 127, 20));
    }

    public static int getCreativeSlotMax(ServerPlayerEntity player) {
        if (!curiosLoaded && player.field_71071_by instanceof ExtendedPlayerInventory) {
            return 46;
        }
        return 45;
    }

    public static boolean isCuriosLoaded() {
        return curiosLoaded;
    }

    public static ItemStack getBackpackStack(PlayerEntity player) {
        AtomicReference<ItemStack> backpack = new AtomicReference<ItemStack>(ItemStack.field_190927_a);
        if (Backpacked.isCuriosLoaded()) {
            // empty if block
        }
        if (player.field_71071_by instanceof ExtendedPlayerInventory) {
            ExtendedPlayerInventory inventory = (ExtendedPlayerInventory)player.field_71071_by;
            backpack.set((ItemStack)inventory.getBackpackItems().get(0));
        }
        return backpack.get();
    }

    private static void setSlotPosition(Slot slot, int x, int y) {
        try {
            if (xPosField == null) {
                Field xPos = ObfuscationReflectionHelper.findField(Slot.class, (String)"field_75223_e");
                xPos.setAccessible(true);
                Field xPosModifiers = Field.class.getDeclaredField("modifiers");
                xPosModifiers.setAccessible(true);
                xPosModifiers.setInt(xPos, xPos.getModifiers() & 0xFFFFFFEF);
                xPosField = xPos;
            }
            if (yPosField == null) {
                Field yPos = ObfuscationReflectionHelper.findField(Slot.class, (String)"field_75221_f");
                yPos.setAccessible(true);
                Field yPosModifiers = Field.class.getDeclaredField("modifiers");
                yPosModifiers.setAccessible(true);
                yPosModifiers.setInt(yPos, yPos.getModifiers() & 0xFFFFFFEF);
                yPosField = yPos;
            }
            xPosField.set(slot, x);
            yPosField.set(slot, y);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

