/*
 * Decompiled with CFR 0.152.
 */
package its_meow.betteranimalsplus.common.entity;

import com.google.common.base.Predicates;
import its_meow.betteranimalsplus.common.entity.EntityBear;
import its_meow.betteranimalsplus.common.entity.EntityPheasant;
import its_meow.betteranimalsplus.init.ModEntities;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityBearNeutral
extends EntityBear {
    private int warningSoundTicks;

    public EntityBearNeutral(World worldIn) {
        super(ModEntities.getEntityType(EntityBearNeutral.class), worldIn);
        this.func_70105_a(2.0f, 1.5f);
    }

    public EntityBearNeutral(EntityType<?> type, World worldIn) {
        super(type, worldIn);
        this.func_70105_a(2.0f, 1.5f);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AIMeleeAttack());
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new AIHurtByTarget());
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.5));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityChicken.class, true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityRabbit.class, true));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPheasant.class, 90, true, true, (Predicate)Predicates.alwaysTrue()));
    }

    public void func_70624_b(EntityLivingBase entitylivingbaseIn) {
        if (this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            super.func_70624_b(null);
        } else {
            super.func_70624_b(entitylivingbaseIn);
        }
    }

    public boolean getCanSpawnHere() {
        return this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL;
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        Entity entity = source.func_76346_g();
        if (entity instanceof EntityPlayer) {
            this.func_70624_b((EntityLivingBase)((EntityPlayer)entity));
            this.playWarningSound();
        }
        return super.func_70097_a(source, amount);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.warningSoundTicks > 0) {
            --this.warningSoundTicks;
        }
    }

    @Override
    protected void playWarningSound() {
        if (this.warningSoundTicks <= 0) {
            this.func_184185_a(SoundEvents.field_190031_ew, 1.0f, 1.0f);
            this.warningSoundTicks = 40;
        }
    }

    @Override
    protected SoundEvent func_184639_G() {
        return SoundEvents.field_190026_er;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_190029_eu;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_190028_et;
    }

    @Override
    protected void playStepSound(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_190030_ev, 0.15f, 1.0f);
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        return false;
    }

    @Override
    public boolean func_191990_c(EntityPlayer playerIn) {
        return this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL && this.func_70638_az() == playerIn;
    }

    public class AIMeleeAttack
    extends EntityAIAttackMelee {
        public AIMeleeAttack() {
            super((EntityCreature)EntityBearNeutral.this, 1.25, true);
        }

        protected void func_190102_a(EntityLivingBase p_190102_1_, double p_190102_2_) {
            double d0 = this.func_179512_a(p_190102_1_);
            if (p_190102_2_ <= d0 && this.field_75439_d <= 0) {
                this.field_75439_d = 20;
                this.field_75441_b.func_70652_k((Entity)p_190102_1_);
            } else if (p_190102_2_ <= d0 * 2.0) {
                if (this.field_75439_d <= 0) {
                    this.field_75439_d = 20;
                }
                if (this.field_75439_d <= 10) {
                    EntityBearNeutral.this.playWarningSound();
                }
            } else {
                this.field_75439_d = 20;
            }
        }

        public void func_75251_c() {
            super.func_75251_c();
        }

        protected double func_179512_a(EntityLivingBase attackTarget) {
            return 4.0f + attackTarget.field_70130_N;
        }
    }

    public class AIHurtByTarget
    extends EntityAIHurtByTarget {
        public AIHurtByTarget() {
            super((EntityCreature)EntityBearNeutral.this, false, new Class[0]);
        }

        public void func_75249_e() {
            super.func_75249_e();
        }

        protected void func_179446_a(EntityCreature creatureIn, EntityLivingBase entityLivingBaseIn) {
            if (creatureIn instanceof EntityBearNeutral) {
                super.func_179446_a(creatureIn, entityLivingBaseIn);
            }
        }
    }
}

