/*
 * Decompiled with CFR 0.152.
 */
package its_meow.betteranimalsplus.common.entity;

import its_meow.betteranimalsplus.common.entity.IVariantTypes;
import its_meow.betteranimalsplus.init.ModEntities;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityWaterMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityJellyfish
extends EntityWaterMob
implements IVariantTypes {
    protected static final DataParameter<Integer> TYPE_NUMBER = EntityDataManager.func_187226_a(EntityJellyfish.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Float> SIZE = EntityDataManager.func_187226_a(EntityJellyfish.class, (DataSerializer)DataSerializers.field_187193_c);
    protected int attackCooldown = 0;
    public float jellyYaw;
    public float prevJellyYaw;
    public float jellyRotation;
    public float prevJellyRotation;
    private float randomMotionSpeed;
    private float rotationVelocity;
    private float rotateSpeed;
    private float randomMotionVecX;
    private float randomMotionVecY;
    private float randomMotionVecZ;

    public EntityJellyfish(World worldIn) {
        super(ModEntities.getEntityType(EntityJellyfish.class), worldIn);
        this.func_70105_a(0.8f, 0.8f);
        this.rotationVelocity = 1.0f / (this.field_70146_Z.nextFloat() + 1.0f) * 0.2f;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.5f;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new AIMoveRandom(this));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.prevJellyYaw = this.jellyYaw;
        this.prevJellyRotation = this.jellyRotation;
        this.jellyRotation += this.rotationVelocity;
        if ((double)this.jellyRotation > Math.PI * 2) {
            if (this.field_70170_p.field_72995_K) {
                this.jellyRotation = (float)Math.PI * 2;
            } else {
                this.jellyRotation = (float)((double)this.jellyRotation - Math.PI * 2);
                if (this.field_70146_Z.nextInt(10) == 0) {
                    this.rotationVelocity = 1.0f / (this.field_70146_Z.nextFloat() + 1.0f) * 0.2f;
                }
                this.field_70170_p.func_72960_a((Entity)this, (byte)19);
            }
        }
        if (this.func_203005_aq()) {
            if (this.jellyRotation < (float)Math.PI) {
                float lvt_1_1_ = this.jellyRotation / (float)Math.PI;
                if ((double)lvt_1_1_ > 0.75) {
                    this.randomMotionSpeed = 1.0f;
                    this.rotateSpeed = 1.0f;
                } else {
                    this.rotateSpeed *= 0.8f;
                }
            } else {
                this.randomMotionSpeed *= 0.9f;
                this.rotateSpeed *= 0.99f;
            }
            if (!this.field_70170_p.field_72995_K) {
                this.field_70159_w = this.randomMotionVecX * this.randomMotionSpeed;
                this.field_70181_x = this.randomMotionVecY * this.randomMotionSpeed;
                this.field_70179_y = this.randomMotionVecZ * this.randomMotionSpeed;
            }
            float lvt_1_2_ = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70761_aq += (-((float)MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y)) * 57.295776f - this.field_70761_aq) * 0.1f;
            this.field_70177_z = this.field_70761_aq;
            this.jellyYaw = (float)((double)this.jellyYaw + Math.PI * (double)this.rotateSpeed * 1.5);
        } else if (!this.field_70170_p.field_72995_K) {
            this.field_70159_w = 0.0;
            this.field_70179_y = 0.0;
            if (this.func_70644_a(MobEffects.field_188424_y)) {
                this.field_70181_x += 0.05 * (double)(this.func_70660_b(MobEffects.field_188424_y).func_76458_c() + 1) - this.field_70181_x;
            } else if (!this.func_189652_ae()) {
                this.field_70181_x -= 0.08;
            }
            this.field_70181_x *= (double)0.98f;
        }
    }

    public void func_70100_b_(EntityPlayer entity) {
        super.func_70100_b_(entity);
        if (!entity.func_184812_l_() && this.attackCooldown == 0) {
            entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 2.0f);
            entity.func_195064_c(new PotionEffect(MobEffects.field_76436_u, 200, 0, false, false));
            entity.func_195064_c(new PotionEffect(MobEffects.field_76440_q, 90, 2, false, false));
            this.attackCooldown = 80;
        }
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187886_fs;
    }

    public void func_191986_a(float p_191986_1_, float p_191986_2_, float p_191986_3_) {
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
    }

    public boolean func_205020_a(IWorld p_205020_1_, boolean p_205020_2_) {
        return this.field_70163_u > 45.0 && this.field_70163_u < (double)p_205020_1_.func_181545_F();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte p_70103_1_) {
        if (p_70103_1_ == 19) {
            this.jellyRotation = 0.0f;
        } else {
            super.func_70103_a(p_70103_1_);
        }
    }

    public void setMovementVector(float p_175568_1_, float p_175568_2_, float p_175568_3_) {
        this.randomMotionVecX = p_175568_1_;
        this.randomMotionVecY = p_175568_2_;
        this.randomMotionVecZ = p_175568_3_;
    }

    public boolean hasMovementVector() {
        return this.randomMotionVecX != 0.0f || this.randomMotionVecY != 0.0f || this.randomMotionVecZ != 0.0f;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.registerTypeKey();
        this.field_70180_af.func_187214_a(SIZE, (Object)Float.valueOf(1.0f));
    }

    public float getSize() {
        return ((Float)this.field_70180_af.func_187225_a(SIZE)).floatValue();
    }

    public void func_70105_a(float width, float height) {
        this.field_70180_af.func_187227_b(SIZE, (Object)Float.valueOf(width));
        super.func_70105_a(width, height);
    }

    public boolean func_184198_c(NBTTagCompound compound) {
        this.writeType(compound);
        compound.func_74776_a("Size", this.getSize());
        return super.func_184198_c(compound);
    }

    public void func_70020_e(NBTTagCompound compound) {
        super.func_70020_e(compound);
        this.readType(compound);
        float size = compound.func_74760_g("Size");
        this.func_70105_a(size, size);
    }

    @Nullable
    public IEntityLivingData func_204210_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata, NBTTagCompound compound) {
        livingdata = super.func_204210_a(difficulty, livingdata, compound);
        if (!this.func_70631_g_()) {
            int i = this.field_70146_Z.nextInt(6) + 1;
            float rand = ((float)this.field_70146_Z.nextInt(30) + 1.0f) / 50.0f + 0.05f;
            if (livingdata instanceof JellyfishData) {
                i = ((JellyfishData)livingdata).typeData;
                rand = ((JellyfishData)livingdata).size;
            } else {
                livingdata = new JellyfishData(i, rand);
            }
            this.setType(i);
            this.func_70105_a(rand, rand);
        }
        this.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
        return livingdata;
    }

    @Override
    public DataParameter<Integer> getDataKey() {
        return TYPE_NUMBER;
    }

    @Override
    public int getVariantMax() {
        return 6;
    }

    @Override
    public boolean isChildI() {
        return this.func_70631_g_();
    }

    @Override
    public Random getRNGI() {
        return this.func_70681_au();
    }

    @Override
    public EntityDataManager getDataManagerI() {
        return this.func_184212_Q();
    }

    static class AIMoveRandom
    extends EntityAIBase {
        private final EntityJellyfish entity;

        public AIMoveRandom(EntityJellyfish entityIn) {
            this.entity = entityIn;
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75246_d() {
            int i = this.entity.func_70654_ax();
            if (i > 100) {
                this.entity.setMovementVector(0.0f, 0.0f, 0.0f);
            } else if (this.entity.func_70681_au().nextInt(50) == 0 || !this.entity.field_70171_ac || !this.entity.hasMovementVector()) {
                float f = this.entity.func_70681_au().nextFloat() * ((float)Math.PI * 2);
                float f1 = MathHelper.func_76134_b((float)f) * 0.2f;
                float f2 = -0.1f + this.entity.func_70681_au().nextFloat() * 0.2f;
                float f3 = MathHelper.func_76126_a((float)f) * 0.2f;
                this.entity.setMovementVector(f1 / 3.0f, f2 / 3.0f, f3 / 3.0f);
            }
        }
    }

    public static class JellyfishData
    implements IEntityLivingData {
        public int typeData;
        public float size;

        public JellyfishData(int type, float size) {
            this.typeData = type;
            this.size = size;
        }
    }
}

