/*
 * Decompiled with CFR 0.152.
 */
package its_meow.betteranimalsplus.common.entity;

import com.google.common.base.Predicate;
import its_meow.betteranimalsplus.common.entity.EntityTameableFlying;
import its_meow.betteranimalsplus.common.entity.IVariantTypes;
import its_meow.betteranimalsplus.common.entity.ai.EntityAIFollowOwnerFlying;
import its_meow.betteranimalsplus.common.entity.ai.LammerMoveHelper;
import its_meow.betteranimalsplus.init.ModEntities;
import its_meow.betteranimalsplus.init.ModLootTables;
import its_meow.betteranimalsplus.util.PolarVector3D;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.ai.EntityAISit;
import net.minecraft.entity.ai.EntityAITarget;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateFlying;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class EntityLammergeier
extends EntityTameableFlying
implements IVariantTypes {
    protected static final DataParameter<Integer> TYPE_NUMBER = EntityDataManager.func_187226_a(EntityLammergeier.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Byte> FLYING = EntityDataManager.func_187226_a(EntityLammergeier.class, (DataSerializer)DataSerializers.field_187191_a);
    protected static final DataParameter<Float> DATA_HEALTH_ID = EntityDataManager.func_187226_a(EntityLammergeier.class, (DataSerializer)DataSerializers.field_187193_c);
    public boolean landedLast = false;
    protected boolean readyToSit = false;
    private int lastTick = 0;
    public int ticksForFly = 0;
    public double lastMotionY = 0.0;

    public EntityLammergeier(World worldIn) {
        super(ModEntities.getEntityType(EntityLammergeier.class), worldIn);
        this.func_70105_a(1.0f, 1.0f);
        this.field_70765_h = new LammerMoveHelper(this);
    }

    @Override
    public boolean func_70617_f_() {
        return false;
    }

    protected ResourceLocation func_184647_J() {
        return ModLootTables.lammergeier;
    }

    public int func_70641_bl() {
        return 2;
    }

    protected PathNavigate func_175447_b(World worldIn) {
        PathNavigateFlying pathnavigateflying = new PathNavigateFlying((EntityLiving)this, worldIn);
        pathnavigateflying.func_192879_a(false);
        pathnavigateflying.func_212239_d(true);
        pathnavigateflying.func_192878_b(true);
        return pathnavigateflying;
    }

    public boolean func_70104_M() {
        return super.func_70104_M() && this.func_184188_bt().size() != 0;
    }

    protected void func_184651_r() {
        this.field_70911_d = new EntityAISit((EntityTameable)this);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.field_70911_d);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AIMeleeAttack(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIFollowOwnerFlying(this, 0.5, 10.0f, 50.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new AIRandomFly(this));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new AILookAround(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIOwnerHurtByTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIOwnerHurtTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIFindEntityNearestFlying(this, EntitySkeleton.class));
    }

    public void func_70624_b(EntityLivingBase entitylivingbaseIn) {
        if (!this.func_70906_o()) {
            super.func_70624_b(entitylivingbaseIn);
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FLYING, (Object)0);
        this.field_70180_af.func_187214_a(TYPE_NUMBER, (Object)0);
        this.field_70180_af.func_187214_a(DATA_HEALTH_ID, (Object)Float.valueOf(this.func_110143_aJ()));
    }

    protected SoundEvent func_184639_G() {
        return this.func_70909_n() && ((Float)this.field_70180_af.func_187225_a(DATA_HEALTH_ID)).floatValue() < 6.0f ? SoundEvents.field_192794_er : null;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_192793_eq;
    }

    protected float func_70647_i() {
        return 0.4f;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        Entity entity = source.func_76346_g();
        if (this.field_70911_d != null) {
            this.func_70904_g(false);
        }
        if (entity != null && !(entity instanceof EntityPlayer) && !(entity instanceof EntityArrow)) {
            amount = (amount + 1.0f) / 2.0f;
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (this.func_70909_n()) {
            if (!itemstack.func_190926_b() && itemstack.func_77973_b() instanceof ItemFood) {
                ItemFood itemfood = (ItemFood)itemstack.func_77973_b();
                if (((Float)this.field_70180_af.func_187225_a(DATA_HEALTH_ID)).floatValue() < 20.0f) {
                    if (!player.func_184812_l_()) {
                        itemstack.func_190918_g(1);
                    }
                    this.func_70691_i(itemfood.func_150905_g(itemstack));
                    return true;
                }
            }
            if (!(!this.func_152114_e((EntityLivingBase)player) || this.func_184207_aI() || this.field_70170_p.field_72995_K || this.field_70173_aa - this.lastTick <= 13 || itemstack.func_77973_b() != null && itemstack.func_77973_b() == Items.field_179561_bm)) {
                if (!this.func_70906_o()) {
                    this.func_70624_b(null);
                    this.field_70699_by.func_75499_g();
                    BlockPos landPos = this.func_180425_c();
                    for (int y = (int)this.field_70163_u; y > 0 && y < 255; --y) {
                        BlockPos curPos = new BlockPos(landPos.func_177958_n(), y, landPos.func_177952_p());
                        if (!this.field_70170_p.func_175623_d(curPos) || this.field_70170_p.func_175623_d(curPos.func_177977_b())) continue;
                        landPos = curPos;
                        y = -1;
                    }
                    this.field_70699_by.func_75484_a(this.field_70699_by.func_179680_a(landPos), 1.0);
                    this.readyToSit = true;
                } else {
                    this.func_70904_g(!this.func_70906_o());
                    this.field_70699_by.func_75499_g();
                }
                this.lastTick = this.field_70173_aa;
            }
        } else if (itemstack.func_77973_b() == Items.field_151103_aS && !this.func_70909_n()) {
            if (!player.func_184812_l_()) {
                itemstack.func_190918_g(1);
            }
            if (!this.field_70170_p.field_72995_K) {
                if (!ForgeEventFactory.onAnimalTame((EntityAnimal)this, (EntityPlayer)player)) {
                    this.func_193101_c(player);
                    this.field_70699_by.func_75499_g();
                    this.func_70624_b(null);
                    this.func_70904_g(true);
                    this.func_70606_j(20.0f);
                    this.func_70908_e(true);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                } else {
                    this.func_70908_e(false);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                }
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == Items.field_151103_aS;
    }

    public boolean func_142018_a(EntityLivingBase target, EntityLivingBase owner) {
        if (!(target instanceof EntityCreeper) && !(target instanceof EntityGhast)) {
            EntityLammergeier entitylam;
            if (target instanceof EntityLammergeier && (entitylam = (EntityLammergeier)target).func_70909_n() && entitylam.func_70902_q() == owner) {
                return false;
            }
            if (target instanceof EntityPlayer && owner instanceof EntityPlayer && !((EntityPlayer)owner).func_96122_a((EntityPlayer)target)) {
                return false;
            }
            return !(target instanceof AbstractHorse) || !((AbstractHorse)target).func_110248_bS();
        }
        return false;
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag;
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int i = 0;
        if (entityIn instanceof EntityLivingBase) {
            f += EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (CreatureAttribute)((EntityLivingBase)entityIn).func_70668_bt());
            i += EnchantmentHelper.func_77501_a((EntityLivingBase)this);
        }
        if (flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), f)) {
            int j;
            if (i > 0 && entityIn instanceof EntityLivingBase) {
                ((EntityLivingBase)entityIn).func_70653_a((Entity)this, (float)i * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            if ((j = EnchantmentHelper.func_90036_a((EntityLivingBase)this)) > 0) {
                entityIn.func_70015_d(j * 4);
            }
            if (entityIn instanceof EntityPlayer) {
                ItemStack itemstack1;
                EntityPlayer entityplayer = (EntityPlayer)entityIn;
                ItemStack itemstack = this.func_184614_ca();
                ItemStack itemStack = itemstack1 = entityplayer.func_184587_cr() ? entityplayer.func_184607_cu() : ItemStack.field_190927_a;
                if (!itemstack.func_190926_b() && !itemstack1.func_190926_b() && itemstack.func_77973_b().canDisableShield(itemstack, itemstack1, (EntityLivingBase)entityplayer, (EntityLivingBase)this) && itemstack1.func_77973_b().isShield(itemstack1, (EntityLivingBase)entityplayer)) {
                    float f1 = 0.25f + (float)EnchantmentHelper.func_185293_e((EntityLivingBase)this) * 0.05f;
                    if (this.field_70146_Z.nextFloat() < f1) {
                        entityplayer.func_184811_cZ().func_185145_a(itemstack1.func_77973_b(), 100);
                        this.field_70170_p.func_72960_a((Entity)entityplayer, (byte)30);
                    }
                }
            }
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        return flag;
    }

    protected void func_82167_n(Entity entityIn) {
        if (!this.getFlying()) {
            super.func_82167_n(entityIn);
        }
    }

    protected void func_85033_bc() {
        if (!this.getFlying()) {
            super.func_85033_bc();
        }
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        if (!this.getFlying()) {
            super.func_180430_e(distance, damageMultiplier);
        }
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
        if (!this.getFlying()) {
            super.func_184231_a(y, onGroundIn, state, pos);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.lastMotionY = this.field_70181_x;
        if (this.field_70170_p.func_175707_a(this.func_180425_c(), this.func_180425_c().func_177977_b()) && this.field_70170_p.func_175623_d(this.func_180425_c()) && !this.field_70170_p.func_175623_d(this.func_180425_c().func_177977_b()) && this.readyToSit) {
            this.readyToSit = false;
            this.func_70904_g(true);
        }
    }

    public boolean func_145773_az() {
        return !this.getFlying();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_188790_f);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_193334_e);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.func_70909_n() ? 15.0 : 6.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(50.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
        this.func_110148_a(SharedMonsterAttributes.field_188790_f).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_193334_e).func_111128_a(5.0);
    }

    public boolean getFlying() {
        return ((Byte)this.field_70180_af.func_187225_a(FLYING) & 1) != 0;
    }

    public void setFlying(boolean isFlying) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(FLYING);
        if (isFlying) {
            this.field_70180_af.func_187227_b(FLYING, (Object)((byte)(b0 | 1)));
        } else {
            this.field_70180_af.func_187227_b(FLYING, (Object)((byte)(b0 & 0xFFFFFFFE)));
        }
        this.func_189654_d(isFlying);
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        this.field_70180_af.func_187227_b(DATA_HEALTH_ID, (Object)Float.valueOf(this.func_110143_aJ()));
        BlockPos blockpos = new BlockPos((Entity)this);
        BlockPos blockpos1 = blockpos.func_177977_b();
        if (!this.getFlying()) {
            if (this.field_70170_p.func_180495_p(blockpos1).func_185915_l() && this.func_70638_az() == null) {
                this.setFlying(false);
                if (this.field_70146_Z.nextInt(100) == 0) {
                    this.setFlying(true);
                }
            } else {
                this.setFlying(true);
                this.field_70170_p.func_180498_a((EntityPlayer)null, 1025, blockpos, 0);
            }
        } else if (this.field_70146_Z.nextInt(20) == 0 && this.field_70170_p.func_180495_p(blockpos1).func_185915_l()) {
            this.setFlying(false);
        }
    }

    public BlockPos fromPolarCoordinates(PolarVector3D polar) {
        double r = polar.getR();
        double lat = polar.getThetaY();
        double lon = polar.getThetaX();
        double x = r * Math.sin(lat) * Math.cos(lon);
        double y = r * Math.sin(lat) * Math.sin(lon);
        double z = r * Math.cos(lat);
        return new BlockPos(x, y, z);
    }

    public PolarVector3D toPolarCoordinates(BlockPos pos) {
        BlockPos lPos = this.func_180425_c();
        double x = lPos.func_177958_n() - pos.func_177958_n();
        double z = lPos.func_177952_p() - pos.func_177952_p();
        double y = lPos.func_177956_o() - pos.func_177956_o();
        double rx = Math.sqrt(Math.pow(x, 2.0) + Math.pow(z, 2.0));
        double thetax = Math.atan(z / x);
        double thetay = Math.atan(y / rx);
        double ry = Math.sqrt(Math.pow(rx, 2.0) + Math.pow(y, 2.0));
        return new PolarVector3D(thetax, thetay, ry);
    }

    public PolarVector3D toPolarCoordinates(int x, int y, int z) {
        return this.toPolarCoordinates(new BlockPos(x, y, z));
    }

    public boolean func_184198_c(NBTTagCompound compound) {
        this.writeType(compound);
        compound.func_74774_a("LammerFlying", ((Byte)this.field_70180_af.func_187225_a(FLYING)).byteValue());
        return super.func_184198_c(compound);
    }

    public void func_70020_e(NBTTagCompound compound) {
        super.func_70020_e(compound);
        this.readType(compound);
        this.field_70180_af.func_187227_b(FLYING, (Object)compound.func_74771_c("LammerFlying"));
    }

    public void func_70903_f(boolean tamed) {
        super.func_70903_f(tamed);
        if (tamed) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(15.0);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(6.0);
        }
    }

    @Nullable
    public IEntityLivingData func_204210_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata, NBTTagCompound compound) {
        return this.initData(super.func_204210_a(difficulty, livingdata, compound));
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            passenger.func_70107_b(this.field_70165_t + this.field_70159_w, this.field_70163_u - (double)passenger.field_70131_O - 0.05 + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            this.field_70181_x += Math.abs(passenger.field_70181_x);
            if (passenger instanceof EntityLivingBase && (this.func_70638_az() == null || this.func_70638_az() != passenger)) {
                this.func_70624_b((EntityLivingBase)passenger);
            }
            if (this.field_70170_p.field_72995_K) {
                this.func_184190_l(passenger);
            }
        }
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return null;
    }

    @Override
    public DataParameter<Integer> getDataKey() {
        return TYPE_NUMBER;
    }

    @Override
    public int getVariantMax() {
        return 4;
    }

    @Override
    public boolean isChildI() {
        return this.func_70631_g_();
    }

    @Override
    public Random getRNGI() {
        return this.func_70681_au();
    }

    @Override
    public EntityDataManager getDataManagerI() {
        return this.func_184212_Q();
    }

    static class EntityAIFindEntityNearestFlying
    extends EntityAIBase {
        private final EntityLammergeier mob;
        private final Predicate<EntityLivingBase> predicate;
        private final EntityAINearestAttackableTarget.Sorter sorter;
        private EntityLivingBase target;
        private final Class<? extends EntityLivingBase> classToCheck;

        public EntityAIFindEntityNearestFlying(EntityLammergeier mobIn, Class<? extends EntityLivingBase> p_i45884_2_) {
            this.mob = mobIn;
            this.classToCheck = p_i45884_2_;
            this.predicate = p_apply_1_ -> {
                double d0 = this.getFollowRange();
                if (p_apply_1_.func_70093_af()) {
                    d0 *= (double)0.8f;
                }
                if (p_apply_1_.func_82150_aj()) {
                    return false;
                }
                return (double)p_apply_1_.func_70032_d((Entity)this.mob) > d0 ? false : EntityAITarget.func_179445_a((EntityLiving)this.mob, (EntityLivingBase)p_apply_1_, (boolean)false, (boolean)true);
            };
            this.sorter = new EntityAINearestAttackableTarget.Sorter((Entity)mobIn);
        }

        public boolean func_75250_a() {
            if (this.mob.func_70909_n()) {
                return false;
            }
            double d0 = this.getFollowRange();
            List list = this.mob.field_70170_p.func_175647_a(this.classToCheck, this.mob.func_174813_aQ().func_72314_b(d0, d0, d0), this.predicate);
            Collections.sort(list, this.sorter);
            if (list.isEmpty()) {
                return false;
            }
            this.target = (EntityLivingBase)list.get(0);
            return true;
        }

        public boolean func_75253_b() {
            EntityLivingBase entitylivingbase = this.mob.func_70638_az();
            if (entitylivingbase == null) {
                return false;
            }
            if (!entitylivingbase.func_70089_S()) {
                return false;
            }
            if (this.mob.func_184188_bt().size() == 0) {
                return false;
            }
            double d0 = this.getFollowRange();
            if (this.mob.func_70068_e((Entity)entitylivingbase) > d0 * d0) {
                this.mob.func_70624_b(null);
                return false;
            }
            return !(entitylivingbase instanceof EntityPlayerMP) || !((EntityPlayerMP)entitylivingbase).field_71134_c.func_73083_d();
        }

        public void func_75249_e() {
            this.mob.func_70624_b(this.target);
            super.func_75249_e();
        }

        public void func_75251_c() {
            this.mob.func_70624_b(null);
            super.func_75249_e();
        }

        protected double getFollowRange() {
            IAttributeInstance iattributeinstance = this.mob.func_110148_a(SharedMonsterAttributes.field_111265_b);
            return iattributeinstance == null ? 16.0 : iattributeinstance.func_111126_e();
        }
    }

    static class AIRandomFly
    extends EntityAIBase {
        private final EntityLammergeier parentEntity;

        public AIRandomFly(EntityLammergeier lam) {
            this.parentEntity = lam;
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            double d2;
            double d1;
            EntityMoveHelper entitymovehelper = this.parentEntity.func_70605_aq();
            if (this.parentEntity.func_70909_n()) {
                return false;
            }
            if (this.parentEntity.func_70638_az() == null) {
                return true;
            }
            double d0 = entitymovehelper.func_179917_d() - this.parentEntity.field_70165_t;
            double d3 = d0 * d0 + (d1 = entitymovehelper.func_179919_e() - this.parentEntity.field_70163_u) * d1 + (d2 = entitymovehelper.func_179918_f() - this.parentEntity.field_70161_v) * d2;
            return d3 < 1.0 || d3 > 3600.0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            Random random = this.parentEntity.func_70681_au();
            if (random.nextInt(30) != 1 && !this.parentEntity.landedLast) {
                this.parentEntity.setFlying(true);
                BlockPos rPos = this.parentEntity.fromPolarCoordinates(new PolarVector3D(this.parentEntity.field_70177_z + (float)(random.nextInt(50) - 25), random.nextInt(30) - 10, (float)(random.nextInt(50) + 1) + random.nextFloat()));
                BlockPos pos = this.parentEntity.func_180425_c();
                rPos = rPos.func_177971_a((Vec3i)pos);
                this.parentEntity.func_70605_aq().func_75642_a((double)rPos.func_177958_n(), (double)rPos.func_177956_o(), (double)rPos.func_177952_p(), 1.0);
            } else if (!this.parentEntity.landedLast && this.parentEntity.field_70163_u > 65.0 && this.parentEntity.getFlying()) {
                BlockPos rPos = this.findLandingPosition();
                this.parentEntity.landedLast = true;
                this.parentEntity.func_70605_aq().func_75642_a((double)rPos.func_177958_n(), (double)rPos.func_177956_o(), (double)rPos.func_177952_p(), 1.1);
            } else {
                ++this.parentEntity.ticksForFly;
                if (this.parentEntity.ticksForFly == 120) {
                    this.parentEntity.setFlying(false);
                    this.parentEntity.landedLast = false;
                    this.parentEntity.ticksForFly = 0;
                }
            }
        }

        private BlockPos findLandingPosition() {
            World world = this.parentEntity.field_70170_p;
            Random random = this.parentEntity.func_70681_au();
            float x = (float)((int)this.parentEntity.field_70165_t + random.nextInt(16)) - 8.0f + 0.5f;
            float z = (float)((int)this.parentEntity.field_70161_v + random.nextInt(16)) - 8.0f + 0.5f;
            float y = AIRandomFly.getTopSolidOrLiquidBlock(world, new BlockPos((double)x, 0.0, (double)z)).func_177956_o();
            BlockPos pos = new BlockPos((double)x, (double)y, (double)z);
            return pos;
        }

        private static BlockPos getTopSolidOrLiquidBlock(World world, BlockPos pos) {
            for (int i = world.func_72800_K(); i > world.func_181545_F(); --i) {
                BlockPos pos2 = new BlockPos(pos.func_177958_n(), i, pos.func_177952_p());
                IBlockState state = world.func_180495_p(pos2.func_177977_b());
                if (!world.func_175623_d(pos2) || !state.func_185896_q() || !world.func_175678_i(pos2)) continue;
                return pos2;
            }
            return new BlockPos(pos.func_177958_n(), world.func_181545_F() + 40, pos.func_177952_p());
        }
    }

    static class AILookAround
    extends EntityAIBase {
        private final EntityLammergeier parentEntity;

        public AILookAround(EntityLammergeier lam) {
            this.parentEntity = lam;
            this.func_75248_a(2);
        }

        public boolean func_75250_a() {
            return this.parentEntity.getFlying();
        }

        public void func_75246_d() {
            if (this.parentEntity.func_70638_az() == null) {
                if (!this.parentEntity.func_70909_n()) {
                    this.parentEntity.field_70761_aq = this.parentEntity.field_70177_z = -((float)MathHelper.func_181159_b((double)this.parentEntity.field_70159_w, (double)this.parentEntity.field_70179_y)) * 57.295776f;
                } else {
                    EntityLivingBase entitylivingbase = this.parentEntity.func_70902_q();
                    if (entitylivingbase != null && entitylivingbase.func_70068_e((Entity)this.parentEntity) < 4096.0) {
                        double d1 = entitylivingbase.field_70165_t - this.parentEntity.field_70165_t;
                        double d2 = entitylivingbase.field_70161_v - this.parentEntity.field_70161_v;
                        this.parentEntity.field_70761_aq = this.parentEntity.field_70177_z = -((float)MathHelper.func_181159_b((double)d1, (double)d2)) * 57.295776f;
                    }
                }
            } else {
                EntityLivingBase entitylivingbase = this.parentEntity.func_70638_az();
                if (entitylivingbase.func_70068_e((Entity)this.parentEntity) < 4096.0) {
                    double d1 = entitylivingbase.field_70165_t - this.parentEntity.field_70165_t;
                    double d2 = entitylivingbase.field_70161_v - this.parentEntity.field_70161_v;
                    this.parentEntity.field_70761_aq = this.parentEntity.field_70177_z = -((float)MathHelper.func_181159_b((double)d1, (double)d2)) * 57.295776f;
                }
            }
        }
    }

    static class AIMeleeAttack
    extends EntityAIAttackMelee {
        protected World world;
        protected EntityLammergeier field_75441_b;
        protected int field_75439_d;
        double field_75440_e;
        Path field_75438_g;
        protected final int field_188493_g = 20;
        protected double liftY = 0.0;

        public AIMeleeAttack(EntityLammergeier lam) {
            super((EntityCreature)lam, 0.5, false);
            this.field_75441_b = lam;
            this.world = lam.func_130014_f_();
            this.func_75248_a(2);
        }

        public boolean func_75250_a() {
            EntityLivingBase entitylivingbase = this.field_75441_b.func_70638_az();
            if (entitylivingbase == null) {
                return false;
            }
            return entitylivingbase.func_70089_S();
        }

        public boolean func_75253_b() {
            EntityLivingBase entitylivingbase = this.field_75441_b.func_70638_az();
            if (entitylivingbase == null) {
                return false;
            }
            if (!entitylivingbase.func_70089_S()) {
                return false;
            }
            return !(entitylivingbase instanceof EntityPlayer) || !((EntityPlayer)entitylivingbase).func_175149_v() && !((EntityPlayer)entitylivingbase).func_184812_l_();
        }

        public void func_75249_e() {
        }

        public void func_75251_c() {
            EntityLivingBase entitylivingbase = this.field_75441_b.func_70638_az();
            if (entitylivingbase instanceof EntityPlayer && (((EntityPlayer)entitylivingbase).func_175149_v() || ((EntityPlayer)entitylivingbase).func_184812_l_())) {
                this.field_75441_b.func_70624_b(null);
            }
        }

        public void func_75246_d() {
            EntityLivingBase entitylivingbase = this.field_75441_b.func_70638_az();
            double targetX = entitylivingbase.field_70165_t;
            double targetY = entitylivingbase.field_70163_u;
            double targetZ = entitylivingbase.field_70161_v;
            if (entitylivingbase.func_70068_e((Entity)this.field_75441_b) < 4096.0) {
                double d1 = entitylivingbase.field_70165_t - this.field_75441_b.field_70165_t;
                double d2 = entitylivingbase.field_70161_v - this.field_75441_b.field_70161_v;
                this.field_75441_b.field_70761_aq = this.field_75441_b.field_70177_z = -((float)MathHelper.func_181159_b((double)d1, (double)d2)) * 57.295776f;
            }
            double distanceToTarget = this.field_75441_b.func_70092_e(entitylivingbase.field_70165_t, entitylivingbase.field_70163_u, entitylivingbase.field_70161_v);
            --this.field_75439_d;
            double reachToTarget = this.func_179512_a(entitylivingbase);
            if (distanceToTarget <= reachToTarget && this.field_75439_d <= 0) {
                this.field_75439_d = 20;
                if (!this.field_75441_b.func_184215_y((Entity)entitylivingbase)) {
                    this.field_75441_b.func_70652_k((Entity)entitylivingbase);
                }
            }
            if (!this.field_75441_b.func_70605_aq().func_75640_a()) {
                if (this.field_75441_b.func_184188_bt().size() == 0) {
                    this.field_75441_b.func_70605_aq().func_75642_a(targetX, targetY, targetZ, 1.0);
                } else {
                    this.field_75441_b.func_70605_aq().func_75642_a(targetX, this.liftY + 15.0, targetZ, 5.0);
                }
            }
            if (distanceToTarget <= reachToTarget && this.field_75441_b.func_184188_bt().size() == 0 && entitylivingbase.field_70131_O <= 3.0f && this.field_75439_d == 20) {
                this.field_75441_b.func_70012_b(this.field_75441_b.field_70165_t, this.field_75441_b.field_70163_u + (double)entitylivingbase.field_70131_O + 2.0, this.field_75441_b.field_70161_v, this.field_75441_b.field_70177_z, this.field_75441_b.field_70125_A);
                entitylivingbase.func_184205_a((Entity)this.field_75441_b, true);
                this.liftY = entitylivingbase.field_70163_u;
                if (entitylivingbase instanceof EntityLiving) {
                    EntityLiving el = (EntityLiving)entitylivingbase;
                    el.func_70624_b(null);
                    el.func_70604_c(null);
                }
                this.field_75441_b.func_70605_aq().func_75642_a(targetX, this.liftY + 15.0, targetZ, 5.0);
            }
            if (this.field_75441_b.func_184188_bt().size() == 0 && this.field_75441_b.func_130014_f_().func_180495_p(this.field_75441_b.func_180425_c().func_177984_a()).func_185917_h()) {
                entitylivingbase.func_184210_p();
                this.field_75441_b.func_70624_b(null);
                Random random = this.field_75441_b.func_70681_au();
                BlockPos rPos = this.field_75441_b.fromPolarCoordinates(new PolarVector3D(this.field_75441_b.field_70177_z + (float)(random.nextInt(40) - 20), random.nextInt(40) - 20, (float)(random.nextInt(15) + 1) + random.nextFloat()));
                BlockPos pos = this.field_75441_b.func_180425_c();
                rPos = rPos.func_177971_a((Vec3i)pos);
                this.field_75441_b.func_70605_aq().func_75642_a((double)rPos.func_177958_n(), (double)rPos.func_177956_o(), (double)rPos.func_177952_p(), 1.0);
            }
            if (Math.abs(this.field_75441_b.field_70163_u - (this.liftY + 15.0)) <= 3.0 && this.field_75441_b.func_184188_bt().size() > 0) {
                entitylivingbase.func_184210_p();
            }
        }
    }
}

