/*
 * Decompiled with CFR 0.152.
 */
package its_meow.betteranimalsplus.config;

import its_meow.betteranimalsplus.BetterAnimalsPlusMod;
import its_meow.betteranimalsplus.config.BetterAnimalsPlusConfig;
import its_meow.betteranimalsplus.config.EntityConfigurationSection;
import its_meow.betteranimalsplus.init.ModEntities;
import its_meow.betteranimalsplus.util.EntityContainer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class EntityConfig {
    private HashMap<EntityContainer, EntityConfigurationSection> sections = new HashMap();
    private ForgeConfigSpec.BooleanValue coyoteHostileDaytime;

    EntityConfig(ForgeConfigSpec.Builder builder) {
        for (EntityContainer cont : ModEntities.entityList) {
            this.sections.put(cont, new EntityConfigurationSection(cont, builder));
        }
        builder.push("coyote");
        this.coyoteHostileDaytime = builder.comment("Makes coyote always hostile (removes ability to tame!)").worldRestart().define("coyoteHostileDaytime", false);
    }

    public void loadEntityData() {
        BetterAnimalsPlusConfig.coyotesHostileDaytime = (Boolean)this.coyoteHostileDaytime.get();
        for (EntityContainer container : this.sections.keySet()) {
            EntityConfigurationSection section = this.sections.get(container);
            container.maxGroup = (Integer)section.max.get();
            container.minGroup = (Integer)section.min.get();
            container.weight = (Integer)section.weight.get();
            container.doSpawning = (Boolean)section.doSpawning.get();
            ArrayList<Biome> biomesList = new ArrayList<Biome>();
            for (String biomeID : (List)section.biomesList.get()) {
                Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(biomeID));
                if (biome == null) {
                    BetterAnimalsPlusMod.logger.error("Invalid biome configuration entered for entity \"" + container.entityName + "\" (biome was mistyped or a biome mod was removed?): " + biomeID);
                    continue;
                }
                biomesList.add(biome);
            }
            Biome[] biomes = new Biome[biomesList.size()];
            for (int i = 0; i < biomesList.size(); ++i) {
                biomes[i] = (Biome)biomesList.get(i);
            }
            container.spawnBiomes = biomes;
        }
    }

    public void onWorldLoad() {
        this.loadEntityData();
        if (!ModEntities.entryMap.isEmpty()) {
            for (EntityContainer entry : ModEntities.entryMap.keySet()) {
                EntityType<? extends Entity> type = ModEntities.entryMap.get(entry);
                if (!entry.doSpawning) continue;
                if (entry.type == EnumCreatureType.WATER_CREATURE && EntitySpawnPlacementRegistry.func_209344_a(type) == null) {
                    EntitySpawnPlacementRegistry.func_209346_a(type, (EntitySpawnPlacementRegistry.SpawnPlacementType)EntitySpawnPlacementRegistry.SpawnPlacementType.IN_WATER, (Heightmap.Type)Heightmap.Type.OCEAN_FLOOR, null);
                }
                for (Biome biome : entry.spawnBiomes) {
                    Method addSpawn = ObfuscationReflectionHelper.findMethod(Biome.class, (String)"func_201866_a", (Class[])new Class[]{EnumCreatureType.class, Biome.SpawnListEntry.class});
                    try {
                        addSpawn.invoke((Object)biome, entry.type, new Biome.SpawnListEntry(type, entry.weight, entry.minGroup, entry.maxGroup));
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

