/*
 * Decompiled with CFR 0.152.
 */
package its_meow.betteranimalsplus.init;

import com.google.common.base.Preconditions;
import its_meow.betteranimalsplus.common.entity.projectile.EntityBadgerDirt;
import its_meow.betteranimalsplus.common.entity.projectile.EntityTarantulaHair;
import its_meow.betteranimalsplus.common.item.ItemBetterAnimalsPlusEgg;
import its_meow.betteranimalsplus.init.ModBlocks;
import its_meow.betteranimalsplus.init.ModEntities;
import its_meow.betteranimalsplus.init.ModItems;
import its_meow.betteranimalsplus.init.ModTileEntities;
import its_meow.betteranimalsplus.util.EntityContainer;
import its_meow.betteranimalsplus.util.HeadTypes;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="betteranimalsplus", bus=Mod.EventBusSubscriber.Bus.MOD)
public class BetterAnimalsPlusRegistrar {
    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.registerAll((IForgeRegistryEntry[])new Block[]{ModBlocks.TRILLIUM, ModBlocks.HAND_OF_FATE});
        for (HeadTypes type : HeadTypes.values()) {
            registry.registerAll((IForgeRegistryEntry[])type.getBlockSet().toArray(new Block[0]));
        }
    }

    @SubscribeEvent
    public static void registerItemBlocks(RegistryEvent.Register<Item> event) {
        ItemBlock[] items = new ItemBlock[]{ModItems.ITEMBLOCK_TRILLIUM, ModItems.ITEMBLOCK_HAND_OF_FATE};
        IForgeRegistry registry = event.getRegistry();
        for (ItemBlock itemBlock : items) {
            Block block = itemBlock.func_179223_d();
            ResourceLocation loc = itemBlock.getRegistryName();
            if (itemBlock.getRegistryName() == null) {
                loc = (ResourceLocation)Preconditions.checkNotNull((Object)block.getRegistryName(), (String)"Block %s has null registry name", (Object)block);
                itemBlock.setRegistryName(loc);
            }
            registry.register((IForgeRegistryEntry)itemBlock);
        }
        for (HeadTypes headTypes : HeadTypes.values()) {
            registry.registerAll((IForgeRegistryEntry[])headTypes.getItemSet().toArray(new Item[0]));
        }
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.registerAll((IForgeRegistryEntry[])new Item[]{ModItems.VENISON_RAW, ModItems.VENISON_COOKED, ModItems.HIRSCHGEIST_SKULL_WEARABLE, ModItems.ANTLER, ModItems.GOAT_MILK, ModItems.GOAT_CHEESE, ModItems.PHEASANT_RAW, ModItems.PHEASANT_COOKED});
        for (EntityContainer ent : ModEntities.entityList) {
            ItemBetterAnimalsPlusEgg egg = new ItemBetterAnimalsPlusEgg(ModEntities.getEntityType(ent.entityClazz), ent.eggColorSolid, ent.eggColorSpot, ent);
            egg.setRegistryName(ent.entityName.toLowerCase().toString() + "_spawn_egg");
            registry.register((IForgeRegistryEntry)egg);
            ModItems.eggs.put(egg, ent.entityClazz);
        }
    }

    @SubscribeEvent
    public static void registerTileEntities(RegistryEvent.Register<TileEntityType<?>> event) {
        IForgeRegistry reg = event.getRegistry();
        BetterAnimalsPlusRegistrar.registerTE(reg, ModTileEntities.TRILLIUM_TYPE);
        BetterAnimalsPlusRegistrar.registerTE(reg, ModTileEntities.HAND_OF_FATE_TYPE);
        BetterAnimalsPlusRegistrar.registerTE(reg, ModTileEntities.HEAD_TYPE);
    }

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register(EntityTarantulaHair.HAIR_TYPE);
        registry.register(EntityBadgerDirt.DIRT_TYPE);
        for (EntityContainer entry : ModEntities.entryMap.keySet()) {
            EntityType<? extends Entity> type = ModEntities.entryMap.get(entry);
            registry.register(type);
        }
    }

    private static void registerTE(IForgeRegistry<TileEntityType<?>> reg, TileEntityType<?> type) {
        reg.register(type);
    }
}

