/*
 * Decompiled with CFR 0.152.
 */
package mods.betterfoliage.client.texture;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import mods.betterfoliage.BetterFoliage;
import mods.betterfoliage.client.config.BlockConfig;
import mods.betterfoliage.client.config.Config;
import mods.betterfoliage.client.texture.GrassInfo;
import mods.betterfoliage.client.texture.GrassRegistry;
import mods.octarinecore.client.render.lighting.HSB;
import mods.octarinecore.client.resource.AtlasFuture;
import mods.octarinecore.client.resource.ConfigurableModelDiscovery;
import mods.octarinecore.client.resource.Utils;
import mods.octarinecore.common.config.ConfigurableBlockMatcher;
import mods.octarinecore.common.config.ModelTextureList;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.simple.SimpleLogger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0006\u0010\u0011\u001a\u00020\u0012J,\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\r2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lmods/betterfoliage/client/texture/AsyncGrassDiscovery;", "Lmods/octarinecore/client/resource/ConfigurableModelDiscovery;", "Lmods/betterfoliage/client/texture/GrassInfo;", "()V", "logger", "Lorg/apache/logging/log4j/simple/SimpleLogger;", "getLogger", "()Lorg/apache/logging/log4j/simple/SimpleLogger;", "matchClasses", "Lmods/octarinecore/common/config/ConfigurableBlockMatcher;", "getMatchClasses", "()Lmods/octarinecore/common/config/ConfigurableBlockMatcher;", "modelTextures", "", "Lmods/octarinecore/common/config/ModelTextureList;", "getModelTextures", "()Ljava/util/List;", "init", "", "processModel", "Ljava/util/concurrent/CompletableFuture;", "state", "Lnet/minecraft/block/BlockState;", "textures", "", "atlas", "Lmods/octarinecore/client/resource/AtlasFuture;", "forge-1.14.4"})
public final class AsyncGrassDiscovery
extends ConfigurableModelDiscovery<GrassInfo> {
    @NotNull
    private static final SimpleLogger logger;
    public static final AsyncGrassDiscovery INSTANCE;

    @NotNull
    public SimpleLogger getLogger() {
        return logger;
    }

    @Override
    @NotNull
    public ConfigurableBlockMatcher getMatchClasses() {
        return BlockConfig.INSTANCE.getGrassBlocks();
    }

    @Override
    @NotNull
    public List<ModelTextureList> getModelTextures() {
        return BlockConfig.INSTANCE.getGrassModels().getModelList();
    }

    @Override
    @NotNull
    public CompletableFuture<GrassInfo> processModel(@NotNull BlockState state, @NotNull List<String> textures, @NotNull AtlasFuture atlas) {
        String textureName = textures.get(0);
        CompletableFuture<TextureAtlasSprite> spriteF = atlas.sprite(new ResourceLocation(textureName));
        this.getLogger().log(Level.DEBUG, this.getLogName() + ":       texture " + textureName);
        return atlas.mapAfter((Function0)new Function0<GrassInfo>(spriteF, state, textureName){
            final /* synthetic */ CompletableFuture $spriteF;
            final /* synthetic */ BlockState $state;
            final /* synthetic */ String $textureName;

            @NotNull
            public final GrassInfo invoke() {
                Integer n;
                TextureAtlasSprite sprite2 = (TextureAtlasSprite)this.$spriteF.get();
                AsyncGrassDiscovery.INSTANCE.getLogger().log(Level.DEBUG, AsyncGrassDiscovery.INSTANCE.getLogName() + ": block state " + this.$state);
                AsyncGrassDiscovery.INSTANCE.getLogger().log(Level.DEBUG, AsyncGrassDiscovery.INSTANCE.getLogName() + ":       texture " + this.$textureName);
                HSB hsb = HSB.Companion.fromColor(Utils.getAverageColor(sprite2));
                if ((double)hsb.getSaturation() >= Config.shortGrass.INSTANCE.getSaturationThreshold()) {
                    AsyncGrassDiscovery.INSTANCE.getLogger().log(Level.DEBUG, AsyncGrassDiscovery.INSTANCE.getLogName() + ":         brightness " + hsb.getBrightness());
                    AsyncGrassDiscovery.INSTANCE.getLogger().log(Level.DEBUG, AsyncGrassDiscovery.INSTANCE.getLogName() + ":         saturation " + hsb.getSaturation() + " >= " + Config.shortGrass.INSTANCE.getSaturationThreshold() + ", using texture color");
                    n = HSB.copy$default(hsb, 0.0f, 0.0f, Math.min(0.9f, hsb.getBrightness() * 2.0f), 3, null).getAsColor();
                } else {
                    AsyncGrassDiscovery.INSTANCE.getLogger().log(Level.DEBUG, AsyncGrassDiscovery.INSTANCE.getLogName() + ":         saturation " + hsb.getSaturation() + " < " + Config.shortGrass.INSTANCE.getSaturationThreshold() + ", using block color");
                    n = null;
                }
                Integer overrideColor = n;
                return new GrassInfo(sprite2, overrideColor);
            }
            {
                this.$spriteF = completableFuture;
                this.$state = blockState;
                this.$textureName = string;
                super(0);
            }
        });
    }

    public final void init() {
        GrassRegistry.INSTANCE.getRegistries().add(this);
        BetterFoliage.INSTANCE.getBlockSprites().getProviders().add(this);
    }

    private AsyncGrassDiscovery() {
    }

    static {
        AsyncGrassDiscovery asyncGrassDiscovery;
        INSTANCE = asyncGrassDiscovery = new AsyncGrassDiscovery();
        logger = BetterFoliage.INSTANCE.getLogDetail();
    }
}

