/*
 * Decompiled with CFR 0.152.
 */
package mods.octarinecore.client.render.lighting;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import mods.octarinecore.client.render.lighting.CornerLightData;
import mods.octarinecore.client.render.lighting.LightingCtx;
import mods.octarinecore.client.render.lighting.ModelLighter;
import mods.octarinecore.client.render.lighting.RenderVertex;
import mods.octarinecore.client.render.lighting.VertexKt;
import mods.octarinecore.common.GeometryKt;
import mods.octarinecore.common.Int3;
import mods.octarinecore.common.Rotation;
import net.minecraft.util.Direction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\t\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\fR\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\f\u00a8\u0006 "}, d2={"Lmods/octarinecore/client/render/lighting/CornerInterpolateDimming;", "Lmods/octarinecore/client/render/lighting/ModelLighter;", "face1", "Lnet/minecraft/util/Direction;", "face2", "edgeDir", "weight", "", "dimming", "fallbackDimming", "(Lnet/minecraft/util/Direction;Lnet/minecraft/util/Direction;Lnet/minecraft/util/Direction;FFF)V", "getDimming", "()F", "getEdgeDir", "()Lnet/minecraft/util/Direction;", "getFace1", "getFace2", "getFallbackDimming", "offset", "Lmods/octarinecore/common/Int3;", "getOffset", "()Lmods/octarinecore/common/Int3;", "getWeight", "rotate", "rot", "Lmods/octarinecore/common/Rotation;", "shade", "", "context", "Lmods/octarinecore/client/render/lighting/LightingCtx;", "vertex", "Lmods/octarinecore/client/render/lighting/RenderVertex;", "forge-1.14.4"})
public final class CornerInterpolateDimming
implements ModelLighter {
    @NotNull
    private final Int3 offset;
    @NotNull
    private final Direction face1;
    @NotNull
    private final Direction face2;
    @NotNull
    private final Direction edgeDir;
    private final float weight;
    private final float dimming;
    private final float fallbackDimming;

    @NotNull
    public final Int3 getOffset() {
        return this.offset;
    }

    @Override
    public void shade(@NotNull LightingCtx context, @NotNull RenderVertex vertex) {
        CornerLightData shading1 = context.lighting(this.face1, this.edgeDir, this.face2);
        CornerLightData shading2 = context.lighting(this.face2, this.edgeDir, this.face1);
        float weight1 = this.weight;
        float weight2 = 1.0f - this.weight;
        if (!shading1.getValid() && !shading2.getValid()) {
            this.shade(vertex, VertexKt.brMul(context.brightness(this.offset), this.fallbackDimming), VertexKt.colorMul(context.color(this.offset), this.fallbackDimming));
            return;
        }
        if (!shading1.getValid()) {
            shading1 = shading2;
            weight1 *= this.dimming;
        }
        if (!shading2.getValid()) {
            shading2 = shading1;
            weight2 *= this.dimming;
        }
        this.shade(vertex, shading1, shading2, weight1, weight2);
    }

    @Override
    @NotNull
    public CornerInterpolateDimming rotate(@NotNull Rotation rot) {
        return new CornerInterpolateDimming(GeometryKt.rotate(this.face1, rot), GeometryKt.rotate(this.face2, rot), GeometryKt.rotate(this.edgeDir, rot), this.weight, this.dimming, this.fallbackDimming);
    }

    @NotNull
    public final Direction getFace1() {
        return this.face1;
    }

    @NotNull
    public final Direction getFace2() {
        return this.face2;
    }

    @NotNull
    public final Direction getEdgeDir() {
        return this.edgeDir;
    }

    public final float getWeight() {
        return this.weight;
    }

    public final float getDimming() {
        return this.dimming;
    }

    public final float getFallbackDimming() {
        return this.fallbackDimming;
    }

    public CornerInterpolateDimming(@NotNull Direction face1, @NotNull Direction face2, @NotNull Direction edgeDir2, float weight, float dimming, float fallbackDimming) {
        this.face1 = face1;
        this.face2 = face2;
        this.edgeDir = edgeDir2;
        this.weight = weight;
        this.dimming = dimming;
        this.fallbackDimming = fallbackDimming;
        this.offset = new Int3(this.edgeDir);
    }

    public /* synthetic */ CornerInterpolateDimming(Direction direction, Direction direction2, Direction direction3, float f, float f2, float f3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            f3 = 0.5f;
        }
        this(direction, direction2, direction3, f, f2, f3);
    }

    @Override
    public void shade(@NotNull RenderVertex $this$shade, @NotNull CornerLightData shading) {
        ModelLighter.DefaultImpls.shade(this, $this$shade, shading);
    }

    @Override
    public void shade(@NotNull RenderVertex $this$shade, @NotNull CornerLightData shading1, @NotNull CornerLightData shading2, float weight1, float weight2) {
        ModelLighter.DefaultImpls.shade(this, $this$shade, shading1, shading2, weight1, weight2);
    }

    @Override
    public void shade(@NotNull RenderVertex $this$shade, int brightness, int color) {
        ModelLighter.DefaultImpls.shade(this, $this$shade, brightness, color);
    }
}

