/*
 * Decompiled with CFR 0.152.
 */
package mods.octarinecore.client.resource;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import mods.octarinecore.client.render.lighting.HSB;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.SimpleReloadableResourceManager;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000n\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018\u001a\u001e\u0010\u0019\u001a\u00020\u001a*\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u00160\u001b2\u0006\u0010\u001d\u001a\u00020\u0016\u001a\u001d\u0010\u001e\u001a\u00020\u000e*\u00020\n2\u0006\u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u000eH\u0086\u0002\u001a\u0017\u0010\u001e\u001a\u0004\u0018\u00010\u0001*\u00020!2\u0006\u0010\"\u001a\u00020\u0018H\u0086\u0002\u001a\u0017\u0010\u001e\u001a\u0004\u0018\u00010\u0001*\u00020!2\u0006\u0010#\u001a\u00020\u0016H\u0086\u0002\u001a\u001f\u0010\u001e\u001a\u0004\u0018\u00010$*\u00020%2\u0006\u0010&\u001a\u00020\u00182\u0006\u0010'\u001a\u00020\u0018H\u0086\u0002\u001a\u0017\u0010\u001e\u001a\u0004\u0018\u00010$*\u00020%2\u0006\u0010(\u001a\u00020\u0016H\u0086\u0002\u001a\u0010\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00180**\u00020$\u001a\f\u0010+\u001a\u0004\u0018\u00010\n*\u00020$\u001a\u0015\u0010,\u001a\u00020\u0016*\u00020\u00162\u0006\u0010-\u001a\u00020\u0018H\u0086\u0002\u001a%\u0010.\u001a\u00020/*\u00020\n2\u0006\u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u000e2\u0006\u00100\u001a\u00020\u000eH\u0086\u0002\"\u0011\u0010\u0000\u001a\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\"\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\"\u0015\u0010\b\u001a\u00020\t*\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\"\u0015\u0010\r\u001a\u00020\u000e*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\"\u0015\u0010\u0011\u001a\u00020\u0012*\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u00061"}, d2={"missingSprite", "Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;", "getMissingSprite", "()Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;", "resourceManager", "Lnet/minecraft/resources/SimpleReloadableResourceManager;", "getResourceManager", "()Lnet/minecraft/resources/SimpleReloadableResourceManager;", "asStream", "Ljava/io/InputStream;", "Ljava/awt/image/BufferedImage;", "getAsStream", "(Ljava/awt/image/BufferedImage;)Ljava/io/InputStream;", "averageColor", "", "getAverageColor", "(Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;)I", "bytes", "", "getBytes", "(Ljava/awt/image/BufferedImage;)[B", "textureLocation", "Lnet/minecraft/util/ResourceLocation;", "iconName", "", "derivesFrom", "", "Lkotlin/Pair;", "Lnet/minecraft/client/renderer/model/BlockModel;", "targetLocation", "get", "x", "y", "Lnet/minecraft/client/renderer/texture/AtlasTexture;", "name", "res", "Lnet/minecraft/resources/IResource;", "Lnet/minecraft/resources/IResourceManager;", "domain", "path", "location", "getLines", "", "loadImage", "plus", "str", "set", "", "value", "forge-1.14.4"})
@JvmName(name="Utils")
public final class Utils {
    @NotNull
    public static final SimpleReloadableResourceManager getResourceManager() {
        IResourceManager iResourceManager = Minecraft.func_71410_x().func_195551_G();
        if (iResourceManager == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.minecraft.resources.SimpleReloadableResourceManager");
        }
        return (SimpleReloadableResourceManager)iResourceManager;
    }

    @NotNull
    public static final ResourceLocation plus(@NotNull ResourceLocation $this$plus, @NotNull String str) {
        return new ResourceLocation($this$plus.func_110624_b(), $this$plus.func_110623_a() + str);
    }

    @Nullable
    public static final IResource get(@NotNull IResourceManager $this$get, @NotNull String domain, @NotNull String path) {
        return Utils.get($this$get, new ResourceLocation(domain, path));
    }

    @Nullable
    public static final IResource get(@NotNull IResourceManager $this$get, @NotNull ResourceLocation location) {
        return mods.octarinecore.Utils.tryDefault(null, (Function0)new Function0<IResource>($this$get, location){
            final /* synthetic */ IResourceManager $this_get;
            final /* synthetic */ ResourceLocation $location;

            public final IResource invoke() {
                return this.$this_get.func_199002_a(this.$location);
            }
            {
                this.$this_get = iResourceManager;
                this.$location = resourceLocation;
                super(0);
            }
        });
    }

    @Nullable
    public static final TextureAtlasSprite get(@NotNull AtlasTexture $this$get, @NotNull ResourceLocation res) {
        return $this$get.func_195424_a(res);
    }

    @Nullable
    public static final TextureAtlasSprite get(@NotNull AtlasTexture $this$get, @NotNull String name) {
        return $this$get.func_195424_a(new ResourceLocation(name));
    }

    @NotNull
    public static final TextureAtlasSprite getMissingSprite() {
        return (TextureAtlasSprite)MissingTextureSprite.func_217790_a();
    }

    @Nullable
    public static final BufferedImage loadImage(@NotNull IResource $this$loadImage) {
        return ImageIO.read($this$loadImage.func_199027_b());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final List<String> getLines(@NotNull IResource $this$getLines) {
        boolean bl = false;
        ArrayList<String> result = new ArrayList<String>();
        InputStream inputStream = $this$getLines.func_199027_b();
        Charset charset = Charsets.UTF_8;
        boolean bl2 = false;
        Closeable closeable = inputStream;
        int n = 0;
        closeable = new InputStreamReader((InputStream)closeable, charset);
        n = 8192;
        boolean bl3 = false;
        Reader $this$useLines$iv = closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n);
        boolean $i$f$useLines = false;
        Closeable closeable2 = $this$useLines$iv;
        int n2 = 8192;
        n = 0;
        closeable2 = closeable2 instanceof BufferedReader ? (BufferedReader)closeable2 : new BufferedReader((Reader)closeable2, n2);
        n2 = 0;
        Throwable throwable = null;
        try {
            BufferedReader it$iv = (BufferedReader)closeable2;
            boolean bl4 = false;
            Sequence it = TextStreamsKt.lineSequence((BufferedReader)it$iv);
            boolean bl5 = false;
            Sequence $this$forEach$iv = it;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it2 = (String)element$iv;
                boolean bl6 = false;
                result.add(it2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable);
        }
        return result;
    }

    public static final int get(@NotNull BufferedImage $this$get, int x, int y) {
        return $this$get.getRGB(x, y);
    }

    public static final void set(@NotNull BufferedImage $this$set, int x, int y, int value) {
        $this$set.setRGB(x, y, value);
    }

    @NotNull
    public static final InputStream getAsStream(@NotNull BufferedImage $this$asStream) {
        byte[] byArray;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        boolean bl = false;
        boolean bl2 = false;
        ByteArrayOutputStream it = byteArrayOutputStream;
        boolean bl3 = false;
        ImageIO.write((RenderedImage)$this$asStream, "PNG", it);
        byte[] byArray2 = byArray = it.toByteArray();
        return new ByteArrayInputStream(byArray2);
    }

    @NotNull
    public static final byte[] getBytes(@NotNull BufferedImage $this$bytes) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        boolean bl = false;
        boolean bl2 = false;
        ByteArrayOutputStream it = byteArrayOutputStream;
        boolean bl3 = false;
        ImageIO.write((RenderedImage)$this$bytes, "PNG", it);
        return it.toByteArray();
    }

    /*
     * WARNING - void declaration
     */
    public static final int getAverageColor(@NotNull TextureAtlasSprite $this$averageColor) {
        int numOpaque = 0;
        double sumHueX = 0.0;
        double sumHueY = 0.0;
        float sumSaturation = 0.0f;
        float sumBrightness = 0.0f;
        int n = 0;
        int n2 = $this$averageColor.func_94211_a();
        while (n < n2) {
            void x;
            int n3 = 0;
            int n4 = $this$averageColor.func_94216_b();
            while (n3 < n4) {
                void y;
                int pixel = $this$averageColor.getPixelRGBA(0, (int)x, (int)y);
                int alpha = pixel >> 24 & 0xFF;
                HSB hsb = HSB.Companion.fromColor(pixel);
                if (alpha == 255) {
                    ++numOpaque;
                    sumHueX += Math.cos(((double)hsb.getHue() - 0.5) * (Math.PI * 2));
                    sumHueY += Math.sin(((double)hsb.getHue() - 0.5) * (Math.PI * 2));
                    sumSaturation += hsb.getSaturation();
                    sumBrightness += hsb.getBrightness();
                }
                ++y;
            }
            ++x;
        }
        n2 = 0;
        float avgHue = (float)(Math.atan2(sumHueY, sumHueX) / (Math.PI * 2) + 0.5);
        return new HSB(avgHue, sumSaturation / (float)numOpaque, sumBrightness / (float)numOpaque).getAsColor();
    }

    @NotNull
    public static final ResourceLocation textureLocation(@NotNull String iconName) {
        ResourceLocation resourceLocation = new ResourceLocation(iconName);
        boolean bl = false;
        boolean bl2 = false;
        ResourceLocation it = resourceLocation;
        boolean bl3 = false;
        return StringsKt.startsWith$default((String)it.func_110623_a(), (String)"mcpatcher", (boolean)false, (int)2, null) ? it : new ResourceLocation(it.func_110624_b(), "textures/" + it.func_110623_a());
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean derivesFrom(@NotNull Pair<? extends BlockModel, ? extends ResourceLocation> $this$derivesFrom, @NotNull ResourceLocation targetLocation) {
        void var14_12;
        String string;
        void $this$stripStart$iv$iv;
        void $this$stripStart$iv;
        ResourceLocation resourceLocation = (ResourceLocation)$this$derivesFrom.getSecond();
        String str$iv = "models/";
        boolean $i$f$stripStart = false;
        String string2 = $this$stripStart$iv.func_110623_a();
        String string3 = $this$stripStart$iv.func_110624_b();
        boolean ignoreCase$iv$iv = true;
        boolean $i$f$stripStart2 = false;
        if (StringsKt.startsWith((String)$this$stripStart$iv$iv, (String)str$iv, (boolean)ignoreCase$iv$iv)) {
            void var11_9 = $this$stripStart$iv$iv;
            int n = str$iv.length();
            boolean bl = false;
            void v0 = var11_9;
            if (v0 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = v0.substring(n);
            string = string4;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
        } else {
            string = $this$stripStart$iv$iv;
        }
        void var15_13 = var14_12 = string;
        String string5 = string3;
        if (Intrinsics.areEqual((Object)new ResourceLocation(string5, (String)var15_13), (Object)targetLocation)) {
            return true;
        }
        if (((BlockModel)$this$derivesFrom.getFirst()).field_178315_d != null && ((BlockModel)$this$derivesFrom.getFirst()).getParentLocation() != null) {
            BlockModel blockModel = ((BlockModel)$this$derivesFrom.getFirst()).field_178315_d;
            if (blockModel == null) {
                Intrinsics.throwNpe();
            }
            ResourceLocation resourceLocation2 = ((BlockModel)$this$derivesFrom.getFirst()).getParentLocation();
            if (resourceLocation2 == null) {
                Intrinsics.throwNpe();
            }
            return Utils.derivesFrom((Pair<? extends BlockModel, ? extends ResourceLocation>)new Pair((Object)blockModel, (Object)resourceLocation2), targetLocation);
        }
        return false;
    }
}

