/*
 * Decompiled with CFR 0.152.
 */
package mods.betterfoliage.util;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import mods.betterfoliage.model.Color;
import mods.betterfoliage.model.HSB;
import mods.betterfoliage.util.Atlas;
import mods.betterfoliage.util.ResourcesKt;
import net.minecraft.client.renderer.model.Material;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000j\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a&\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0010\u001a\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0006\u001a\u0014\u0010\u001c\u001a\u0004\u0018\u00010\u001d*\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001a\u001a\u001d\u0010\u001e\u001a\u00020\u0010*\u00020\f2\u0006\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u0010H\u0086\u0002\u001a\u0017\u0010\u001e\u001a\u0004\u0018\u00010\u0007*\u00020!2\u0006\u0010\"\u001a\u00020#H\u0086\n\u001a\u0017\u0010\u001e\u001a\u0004\u0018\u00010\u0007*\u00020!2\u0006\u0010$\u001a\u00020%H\u0086\n\u001a\f\u0010&\u001a\u0004\u0018\u00010\f*\u00020'\u001a\u0012\u0010(\u001a\u00020\f*\u00020)2\u0006\u0010*\u001a\u00020%\u001a%\u0010+\u001a\u00020\u0016*\u00020\f2\u0006\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u00102\u0006\u0010,\u001a\u00020\u0010H\u0086\u0002\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0006*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\"\u0015\u0010\n\u001a\u00020\u000b*\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006-"}, d2={"atlas", "Lmods/betterfoliage/util/Atlas;", "Lnet/minecraft/client/renderer/model/Material;", "getAtlas", "(Lnet/minecraft/client/renderer/model/Material;)Lmods/betterfoliage/util/Atlas;", "averageColor", "Lmods/betterfoliage/model/HSB;", "Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;", "getAverageColor", "(Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;)Lmods/betterfoliage/model/HSB;", "bytes", "", "Ljava/awt/image/BufferedImage;", "getBytes", "(Ljava/awt/image/BufferedImage;)[B", "blendRGB", "", "rgb1", "rgb2", "weight1", "weight2", "logColorOverride", "", "logger", "Lorg/apache/logging/log4j/Logger;", "threshold", "", "hsb", "colorOverride", "Lmods/betterfoliage/model/Color;", "get", "x", "y", "Lnet/minecraft/client/renderer/texture/AtlasTexture;", "name", "", "res", "Lnet/minecraft/util/ResourceLocation;", "loadImage", "Lnet/minecraft/resources/IResource;", "loadSprite", "Lnet/minecraft/resources/IResourceManager;", "id", "set", "value", "forge-1.15.2"})
public final class SpritesKt {
    @NotNull
    public static final Atlas getAtlas(@NotNull Material $this$atlas) {
        Atlas atlas;
        Atlas atlas2;
        block2: {
            Atlas[] atlasArray = Atlas.values();
            boolean bl = false;
            Atlas[] atlasArray2 = atlasArray;
            boolean bl2 = false;
            Atlas[] atlasArray3 = atlasArray2;
            int n = atlasArray3.length;
            for (int i = 0; i < n; ++i) {
                Atlas atlas3;
                Atlas it = atlas3 = atlasArray3[i];
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it.getResourceId(), (Object)$this$atlas.func_229310_a_())) continue;
                atlas2 = atlas3;
                break block2;
            }
            atlas2 = atlas = null;
        }
        if (atlas2 == null) {
            atlas = Atlas.BLOCKS;
        }
        return atlas;
    }

    @Nullable
    public static final TextureAtlasSprite get(@NotNull AtlasTexture $this$get, @NotNull ResourceLocation res) {
        int $i$f$get = 0;
        return $this$get.func_195424_a(res);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final TextureAtlasSprite get(@NotNull AtlasTexture $this$get, @NotNull String name) {
        void $this$get$iv;
        int $i$f$get = 0;
        AtlasTexture atlasTexture = $this$get;
        ResourceLocation res$iv = new ResourceLocation(name);
        boolean $i$f$get2 = false;
        return $this$get$iv.func_195424_a(res$iv);
    }

    @NotNull
    public static final BufferedImage loadSprite(@NotNull IResourceManager $this$loadSprite, @NotNull ResourceLocation id) {
        Object object = ResourcesKt.get($this$loadSprite, id);
        if (object == null || (object = SpritesKt.loadImage(object)) == null) {
            throw (Throwable)new IOException("Cannot load resource " + id);
        }
        return object;
    }

    @Nullable
    public static final BufferedImage loadImage(@NotNull IResource $this$loadImage) {
        return ImageIO.read($this$loadImage.func_199027_b());
    }

    public static final int get(@NotNull BufferedImage $this$get, int x, int y) {
        return $this$get.getRGB(x, y);
    }

    public static final void set(@NotNull BufferedImage $this$set, int x, int y, int value) {
        $this$set.setRGB(x, y, value);
    }

    @NotNull
    public static final byte[] getBytes(@NotNull BufferedImage $this$bytes) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        boolean bl = false;
        boolean bl2 = false;
        ByteArrayOutputStream it = byteArrayOutputStream;
        boolean bl3 = false;
        ImageIO.write((RenderedImage)$this$bytes, "PNG", it);
        return it.toByteArray();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final HSB getAverageColor(@NotNull TextureAtlasSprite $this$averageColor) {
        int numOpaque = 0;
        double sumHueX = 0.0;
        double sumHueY = 0.0;
        float sumSaturation = 0.0f;
        float sumBrightness = 0.0f;
        int n = 0;
        int n2 = $this$averageColor.func_94211_a();
        while (n < n2) {
            void x;
            int n3 = 0;
            int n4 = $this$averageColor.func_94216_b();
            while (n3 < n4) {
                void y;
                int pixel = $this$averageColor.getPixelRGBA(0, (int)x, (int)y);
                int alpha = pixel >> 24 & 0xFF;
                HSB hsb = HSB.Companion.fromColorRGBA(pixel);
                if (alpha == 255) {
                    ++numOpaque;
                    double d = ((double)hsb.getHue() - 0.5) * (Math.PI * 2);
                    double d2 = sumHueX;
                    boolean bl = false;
                    double d3 = Math.cos(d);
                    sumHueX = d2 + d3;
                    d = ((double)hsb.getHue() - 0.5) * (Math.PI * 2);
                    d2 = sumHueY;
                    bl = false;
                    d3 = Math.sin(d);
                    sumHueY = d2 + d3;
                    sumSaturation += hsb.getSaturation();
                    sumBrightness += hsb.getBrightness();
                }
                ++y;
            }
            ++x;
        }
        n2 = 0;
        float avgHue = (float)(Math.atan2(sumHueY, sumHueX) / (Math.PI * 2) + 0.5);
        return new HSB(avgHue, sumSaturation / (float)numOpaque, sumBrightness / (float)numOpaque);
    }

    public static final int blendRGB(int rgb1, int rgb2, int weight1, int weight2) {
        int r = ((rgb1 >> 16 & 0xFF) * weight1 + (rgb2 >> 16 & 0xFF) * weight2) / (weight1 + weight2);
        int g = ((rgb1 >> 8 & 0xFF) * weight1 + (rgb2 >> 8 & 0xFF) * weight2) / (weight1 + weight2);
        int b = ((rgb1 & 0xFF) * weight1 + (rgb2 & 0xFF) * weight2) / (weight1 + weight2);
        int a = rgb1 >> 24 & 0xFF;
        int result = a << 24 | r << 16 | g << 8 | b;
        return result;
    }

    public static final void logColorOverride(@NotNull Logger logger, double threshold, @NotNull HSB hsb) {
        if ((double)hsb.getSaturation() >= threshold) {
            logger.log(Level.INFO, "         brightness " + hsb.getBrightness());
            logger.log(Level.INFO, "         saturation " + hsb.getSaturation() + " >= " + threshold + ", will use texture color");
        } else {
            logger.log(Level.INFO, "         saturation " + hsb.getSaturation() + " < " + threshold + ", will use block color");
        }
    }

    @Nullable
    public static final Color colorOverride(@NotNull HSB $this$colorOverride, double threshold) {
        Color color;
        if ((double)$this$colorOverride.getSaturation() < threshold) {
            color = null;
        } else {
            int n = HSB.copy$default($this$colorOverride, 0.0f, 0.0f, RangesKt.coerceAtMost((float)($this$colorOverride.getBrightness() * 2.0f), (float)0.9f), 3, null).getAsColor();
            boolean bl = false;
            boolean bl2 = false;
            int it = n;
            boolean bl3 = false;
            color = new Color(it);
        }
        return color;
    }
}

