/*
 * Decompiled with CFR 0.152.
 */
package mods.betterfoliage.render.particle;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import mods.betterfoliage.model.FixedSpriteSet;
import mods.betterfoliage.model.SpriteSet;
import mods.betterfoliage.render.particle.TextureMatcher;
import mods.betterfoliage.resource.VeryEarlyReloadListener;
import mods.betterfoliage.util.Atlas;
import mods.betterfoliage.util.HasLogger;
import mods.betterfoliage.util.ResourcesKt;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0011\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0006H\u0086\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u001aH\u0007J\b\u0010\u001b\u001a\u00020\u0016H\u0016R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR-\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b0\nj\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b`\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001c"}, d2={"Lmods/betterfoliage/render/particle/LeafParticleRegistry;", "Lmods/betterfoliage/util/HasLogger;", "Lmods/betterfoliage/resource/VeryEarlyReloadListener;", "()V", "allTypes", "", "", "getAllTypes", "()Ljava/util/List;", "particles", "Ljava/util/HashMap;", "Lmods/betterfoliage/model/SpriteSet;", "Lkotlin/collections/HashMap;", "getParticles", "()Ljava/util/HashMap;", "typeMappings", "Lmods/betterfoliage/render/particle/TextureMatcher;", "getTypeMappings", "()Lmods/betterfoliage/render/particle/TextureMatcher;", "get", "type", "handlePostStitch", "", "event", "Lnet/minecraftforge/client/event/TextureStitchEvent$Post;", "handlePreStitch", "Lnet/minecraftforge/client/event/TextureStitchEvent$Pre;", "onReloadStarted", "forge-1.16"})
public final class LeafParticleRegistry
extends HasLogger
implements VeryEarlyReloadListener {
    @NotNull
    private static final TextureMatcher typeMappings;
    @NotNull
    private static final HashMap<String, SpriteSet> particles;
    @NotNull
    public static final LeafParticleRegistry INSTANCE;

    @NotNull
    public final TextureMatcher getTypeMappings() {
        return typeMappings;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getAllTypes() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = typeMappings.getMappings();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TextureMatcher.Mapping mapping = (TextureMatcher.Mapping)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getType();
            collection.add(string);
        }
        return CollectionsKt.distinct((Iterable)CollectionsKt.plus((Collection)((List)destination$iv$iv), (Object)"default"));
    }

    @NotNull
    public final HashMap<String, SpriteSet> getParticles() {
        return particles;
    }

    @NotNull
    public final SpriteSet get(@NotNull String type) {
        SpriteSet spriteSet = particles.get(type);
        if (spriteSet == null) {
            SpriteSet spriteSet2 = particles.get("default");
            Intrinsics.checkNotNull((Object)spriteSet2);
            spriteSet = spriteSet2;
        }
        return spriteSet;
    }

    @Override
    public void onReloadStarted() {
        typeMappings.loadMappings(new ResourceLocation("betterfoliage", "leaf_texture_mappings.cfg"));
        this.getDetailLogger().log(Level.INFO, "Loaded leaf particle mappings, types = [" + CollectionsKt.joinToString$default((Iterable)this.getAllTypes(), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + ']');
    }

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent
    public final void handlePreStitch(@NotNull TextureStitchEvent.Pre event) {
        if (Intrinsics.areEqual((Object)event.getMap().func_229223_g_(), (Object)Atlas.PARTICLES.getResourceId())) {
            Iterable $this$forEach$iv = this.getAllTypes();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$filterTo$iv$iv;
                Iterable $this$mapTo$iv$iv;
                String leafType = (String)element$iv;
                boolean bl = false;
                Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)16);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    void idx;
                    int item$iv$iv;
                    int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    ResourceLocation resourceLocation = new ResourceLocation("betterfoliage", "particle/falling_leaf_" + leafType + '_' + (int)idx);
                    collection.add(resourceLocation);
                }
                Iterable $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$filter = false;
                $this$mapTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    ResourceLocation it = (ResourceLocation)element$iv$iv;
                    boolean bl3 = false;
                    if (!ResourcesKt.getResourceManager().func_219533_b(Atlas.PARTICLES.file(it))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List locations = (List)destination$iv$iv;
                INSTANCE.getDetailLogger().log(Level.INFO, "Registering sprites for leaf particle type [" + leafType + "], " + locations.size() + " sprites found");
                Iterable $this$forEach$iv2 = locations;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    ResourceLocation it = (ResourceLocation)element$iv2;
                    boolean bl4 = false;
                    event.addSprite(it);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent
    public final void handlePostStitch(@NotNull TextureStitchEvent.Post event) {
        if (Intrinsics.areEqual((Object)event.getMap().func_229223_g_(), (Object)Atlas.PARTICLES.getResourceId())) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = typeMappings.getMappings();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                TextureMatcher.Mapping mapping = (TextureMatcher.Mapping)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                String string = it.getType();
                collection.add(string);
            }
            Iterable $this$forEach$iv = CollectionsKt.distinct((Iterable)CollectionsKt.plus((Collection)((List)destination$iv$iv), (Object)"default"));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$filterTo$iv$iv;
                ResourceLocation resourceLocation;
                Collection collection;
                Iterable $this$mapTo$iv$iv2;
                String leafType = (String)element$iv;
                boolean bl = false;
                Iterable $this$map$iv2 = (Iterable)RangesKt.until((int)0, (int)16);
                boolean $i$f$map2 = false;
                Iterable bl2 = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                Iterator iterator = $this$mapTo$iv$iv2.iterator();
                while (iterator.hasNext()) {
                    void idx;
                    int item$iv$iv;
                    int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                    collection = destination$iv$iv2;
                    boolean bl3 = false;
                    resourceLocation = new ResourceLocation("betterfoliage", "particle/falling_leaf_" + leafType + '_' + (int)idx);
                    collection.add(resourceLocation);
                }
                $this$map$iv2 = (List)destination$iv$iv2;
                $i$f$map2 = false;
                $this$mapTo$iv$iv2 = $this$map$iv2;
                destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it;
                    ResourceLocation idx = (ResourceLocation)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl4 = false;
                    resourceLocation = event.getMap().func_195424_a((ResourceLocation)it);
                    collection.add(resourceLocation);
                }
                Iterable $this$filter$iv = (List)destination$iv$iv2;
                boolean $i$f$filter = false;
                $this$mapTo$iv$iv2 = $this$filter$iv;
                destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    TextureAtlasSprite it = (TextureAtlasSprite)element$iv$iv;
                    boolean bl5 = false;
                    if (!(!(it instanceof MissingTextureSprite))) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                List sprites = (List)destination$iv$iv2;
                INSTANCE.getDetailLogger().log(Level.INFO, "Leaf particle type [" + leafType + "], " + sprites.size() + " sprites in atlas");
                ((Map)particles).put(leafType, new FixedSpriteSet(sprites));
            }
        }
    }

    private LeafParticleRegistry() {
    }

    static {
        LeafParticleRegistry leafParticleRegistry;
        INSTANCE = leafParticleRegistry = new LeafParticleRegistry();
        typeMappings = new TextureMatcher();
        boolean bl = false;
        particles = new HashMap();
    }

    @Override
    @NotNull
    public CompletableFuture<Void> func_215226_a(@NotNull IFutureReloadListener.IStage stage, @NotNull IResourceManager resourceManager, @NotNull IProfiler preparationsProfiler, @NotNull IProfiler reloadProfiler, @NotNull Executor backgroundExecutor, @NotNull Executor gameExecutor) {
        return VeryEarlyReloadListener.DefaultImpls.reload(this, stage, resourceManager, preparationsProfiler, reloadProfiler, backgroundExecutor, gameExecutor);
    }
}

