/*
 * Decompiled with CFR 0.152.
 */
package mods.betterfoliage.client.texture;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import mods.betterfoliage.client.Client;
import mods.betterfoliage.client.config.Config;
import mods.betterfoliage.client.integration.OptifineCTM;
import mods.betterfoliage.client.texture.LeafGenerator;
import mods.betterfoliage.client.texture.LeafInfo;
import mods.betterfoliage.client.texture.TextureMatcher;
import mods.betterfoliage.kotlin.Metadata;
import mods.betterfoliage.kotlin.Pair;
import mods.betterfoliage.kotlin.TuplesKt;
import mods.betterfoliage.kotlin.TypeCastException;
import mods.betterfoliage.kotlin.collections.MapsKt;
import mods.betterfoliage.kotlin.jvm.internal.Intrinsics;
import mods.octarinecore.client.resource.IconSet;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.Level;
import org.jetbrains.annotations.NotNull;

@SideOnly(value=Side.CLIENT)
@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0016\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u0016\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\nR\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lmods/betterfoliage/client/texture/LeafRegistry;", "", "()V", "leaves", "", "Lnet/minecraft/util/IIcon;", "Lmods/betterfoliage/client/texture/LeafInfo;", "getLeaves", "()Ljava/util/Map;", "particles", "", "Lmods/octarinecore/client/resource/IconSet;", "getParticles", "typeMappings", "Lmods/betterfoliage/client/texture/TextureMatcher;", "getTypeMappings", "()Lmods/betterfoliage/client/texture/TextureMatcher;", "handleTextureReload", "", "event", "Lnet/minecraftforge/client/event/TextureStitchEvent$Pre;", "registerLeaf", "atlas", "Lnet/minecraft/client/renderer/texture/TextureMap;", "icon", "Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;", "registerParticle", "leafType", "BetterFoliage-compileKotlin"})
public final class LeafRegistry {
    @NotNull
    private static final Map<IIcon, LeafInfo> leaves;
    @NotNull
    private static final Map<String, IconSet> particles;
    @NotNull
    private static final TextureMatcher typeMappings;
    public static final LeafRegistry INSTANCE;

    @NotNull
    public final Map<IIcon, LeafInfo> getLeaves() {
        return leaves;
    }

    @NotNull
    public final Map<String, IconSet> getParticles() {
        return particles;
    }

    @NotNull
    public final TextureMatcher getTypeMappings() {
        return typeMappings;
    }

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent(priority=EventPriority.LOW)
    public final void handleTextureReload(@NotNull TextureStitchEvent.Pre event) {
        Intrinsics.checkParameterIsNotNull(event, "event");
        if (event.map.func_130086_a() != 0) {
            return;
        }
        leaves.clear();
        particles.clear();
        typeMappings.loadMappings(new ResourceLocation("betterfoliage", "leafTextureMappings.cfg"));
        Client.INSTANCE.log(Level.INFO, "Generating leaf textures");
        Object $receiver$iv = new IconSet("betterfoliage", "falling_leaf_default_%d");
        IconSet it = $receiver$iv;
        IIconRegister iIconRegister = (IIconRegister)event.map;
        Intrinsics.checkExpressionValueIsNotNull(iIconRegister, "event.map");
        it.onStitch(iIconRegister);
        particles.put("default", it);
        $receiver$iv = (Iterable)Block.field_149771_c;
        Iterator iterator2 = $receiver$iv.iterator();
        while (iterator2.hasNext()) {
            Iterable $receiver$iv2;
            void $receiver$iv3;
            Collection ctmIcons;
            Object element$iv;
            Object block;
            Object t = block = (element$iv = iterator2.next());
            if (t == null) {
                throw new TypeCastException("null cannot be cast to non-null type net.minecraft.block.Block");
            }
            if (!Config.blocks.INSTANCE.getLeaves().matchesClass((Block)t)) continue;
            ((Block)block).func_149651_a(new IIconRegister(event){
                final /* synthetic */ TextureStitchEvent.Pre $event$inlined;

                public final TextureAtlasSprite registerIcon(String location) {
                    TextureAtlasSprite original = this.$event$inlined.map.getTextureExtry(location);
                    Client.INSTANCE.log(Level.INFO, "Found leaf texture: " + location);
                    TextureMap textureMap = this.$event$inlined.map;
                    Intrinsics.checkExpressionValueIsNotNull(textureMap, "event.map");
                    TextureAtlasSprite textureAtlasSprite = original;
                    Intrinsics.checkExpressionValueIsNotNull(textureAtlasSprite, "original");
                    LeafRegistry.INSTANCE.registerLeaf(textureMap, textureAtlasSprite);
                    if (OptifineCTM.INSTANCE.isAvailable()) {
                        Iterable $receiver$iv;
                        Collection<IIcon> ctmIcons;
                        IIcon iIcon = (IIcon)original;
                        Intrinsics.checkExpressionValueIsNotNull(iIcon, "original");
                        Collection<IIcon> $receiver$iv2 = OptifineCTM.INSTANCE.getAllCTM(iIcon);
                        Collection<IIcon> collection = ctmIcons = $receiver$iv2;
                        if (!$receiver$iv.isEmpty()) {
                            Client.INSTANCE.log(Level.INFO, "Found " + ctmIcons.size() + " CTM variants for texture " + original.func_94215_i());
                            $receiver$iv = ctmIcons;
                            for (T element$iv : $receiver$iv) {
                                IIcon it = (IIcon)element$iv;
                                TextureMap textureMap2 = this.$event$inlined.map;
                                Intrinsics.checkExpressionValueIsNotNull(textureMap2, "event.map");
                                IIcon iIcon2 = it;
                                if (iIcon2 == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type net.minecraft.client.renderer.texture.TextureAtlasSprite");
                                }
                                LeafRegistry.INSTANCE.registerLeaf(textureMap2, (TextureAtlasSprite)iIcon2);
                            }
                        }
                    }
                    return original;
                }
                {
                    this.$event$inlined = pre;
                }
            });
            if (!OptifineCTM.INSTANCE.isAvailable()) continue;
            Collection<IIcon> collection = OptifineCTM.INSTANCE.getAllCTM((Block)block);
            Collection collection2 = ctmIcons = (Collection)$receiver$iv3;
            if (!(!$receiver$iv2.isEmpty())) continue;
            Client.INSTANCE.log(Level.INFO, "Found " + ctmIcons.size() + " CTM variants for block " + Block.func_149682_b((Block)((Block)block)));
            $receiver$iv2 = ctmIcons;
            for (Object element$iv2 : $receiver$iv2) {
                IIcon it2 = (IIcon)element$iv2;
                TextureMap textureMap = event.map;
                Intrinsics.checkExpressionValueIsNotNull(textureMap, "event.map");
                IIcon iIcon = it2;
                if (iIcon == null) {
                    throw new TypeCastException("null cannot be cast to non-null type net.minecraft.client.renderer.texture.TextureAtlasSprite");
                }
                INSTANCE.registerLeaf(textureMap, (TextureAtlasSprite)iIcon);
            }
        }
    }

    public final void registerLeaf(@NotNull TextureMap atlas, @NotNull TextureAtlasSprite icon) {
        Intrinsics.checkParameterIsNotNull(atlas, "atlas");
        Intrinsics.checkParameterIsNotNull(icon, "icon");
        String string = typeMappings.getType(icon);
        if (string == null) {
            string = "default";
        }
        String leafType = string;
        LeafGenerator leafGenerator = Client.INSTANCE.getGenLeaves();
        String string2 = icon.func_94215_i();
        Intrinsics.checkExpressionValueIsNotNull(string2, "icon.iconName");
        IIcon generated = atlas.func_94245_a(leafGenerator.generatedResource(string2, TuplesKt.to("type", leafType)).toString());
        leafType = this.registerParticle(atlas, leafType);
        IIcon iIcon = generated;
        if (iIcon == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.minecraft.client.renderer.texture.TextureAtlasSprite");
        }
        leaves.put((IIcon)icon, new LeafInfo((TextureAtlasSprite)iIcon, leafType, 0, 4, null));
    }

    @NotNull
    public final String registerParticle(@NotNull TextureMap atlas, @NotNull String leafType) {
        Intrinsics.checkParameterIsNotNull(atlas, "atlas");
        Intrinsics.checkParameterIsNotNull(leafType, "leafType");
        if (particles.keySet().contains(leafType) ^ true) {
            IconSet particleSet = new IconSet("betterfoliage", "falling_leaf_" + leafType + "_%d");
            particleSet.onStitch((IIconRegister)atlas);
            if (particleSet.getNum() == 0) {
                Client.INSTANCE.log(Level.WARN, "Leaf particle textures not found for leaf type: " + leafType);
                return "default";
            }
            particles.put(leafType, particleSet);
        }
        return leafType;
    }

    private LeafRegistry() {
        INSTANCE = this;
        leaves = MapsKt.hashMapOf(new Pair[0]);
        particles = MapsKt.hashMapOf(new Pair[0]);
        typeMappings = new TextureMatcher();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    static {
        new LeafRegistry();
    }
}

